/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.converter;

import de.gematik.rbellogger.converter.RbelConverter;
import de.gematik.rbellogger.converter.RbelConverterPlugin;
import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.RbelMapElement;
import de.gematik.rbellogger.data.RbelPathElement;
import de.gematik.rbellogger.data.RbelStringElement;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

public class RbelPathConverter
implements RbelConverterPlugin {
    public RbelMapElement extractParameterMap(URI uri, RbelConverter context, String originalContent) {
        if (uri.getQuery() == null) {
            return new RbelMapElement(Map.of());
        }
        Map rawStringMap = Stream.of(originalContent.split("\\?")[1].split("\\&")).filter(StringUtils::isNotEmpty).collect(Collectors.toMap(param -> param.split("\\=")[0], Function.identity()));
        return new RbelMapElement(Stream.of(uri.getQuery().split("&")).filter(param -> param.contains("=")).map(param -> param.split("=")).collect(Collectors.toMap(array -> array[0], array -> context.convertMessage(array[1]).setRawMessage((String)rawStringMap.get(array[0])))));
    }

    @Override
    public boolean canConvertElement(RbelElement rbel, RbelConverter context) {
        try {
            URI uri = new URI(rbel.getContent());
            boolean hasQuery = uri.getQuery() != null;
            boolean hasProtocol = uri.getScheme() != null;
            return hasQuery || hasProtocol || rbel.getContent().startsWith("/");
        }
        catch (URISyntaxException e) {
            return false;
        }
    }

    @Override
    public RbelElement convertElement(RbelElement rbel, RbelConverter context) {
        URI uri = this.convertToUri(rbel);
        return new RbelPathElement(new RbelStringElement(rbel.getContent().split("\\?")[0]), this.extractParameterMap(uri, context, rbel.getContent()), rbel.getContent());
    }

    private URI convertToUri(RbelElement target) {
        try {
            return new URI(target.getContent());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Unable to convert Path-Element", e);
        }
    }
}

