/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.captures;

import com.sun.jna.Platform;
import de.gematik.rbellogger.apps.PCapException;
import de.gematik.rbellogger.captures.RbelCapturer;
import de.gematik.rbellogger.converter.RbelConverter;
import de.gematik.rbellogger.data.RbelElement;
import java.io.File;
import java.util.Arrays;
import org.pcap4j.core.BpfProgram;
import org.pcap4j.core.NotOpenException;
import org.pcap4j.core.PacketListener;
import org.pcap4j.core.PcapDumper;
import org.pcap4j.core.PcapHandle;
import org.pcap4j.core.PcapNativeException;
import org.pcap4j.core.PcapNetworkInterface;
import org.pcap4j.core.PcapStat;
import org.pcap4j.core.Pcaps;
import org.pcap4j.packet.Packet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PCapCapture
extends RbelCapturer {
    private static final Logger log = LoggerFactory.getLogger(PCapCapture.class);
    private String deviceName;
    private String pcapFile;
    private String filter;
    private boolean printMessageToSystemOut;
    private Thread captureThread;
    private PcapHandle handle;
    private PcapDumper dumper;

    public PCapCapture(RbelConverter rbelConverter, String deviceName, String pcapFile, String filter, boolean printMessageToSystemOut) {
        super(rbelConverter);
        this.deviceName = deviceName;
        this.pcapFile = pcapFile;
        this.filter = filter;
        this.printMessageToSystemOut = printMessageToSystemOut;
    }

    private static void setWindowsNpcapPath() {
        if (System.getProperty("os.name").startsWith("Windows")) {
            Object prop = System.getProperty("jna.library.path");
            prop = prop == null || ((String)prop).isEmpty() ? "C:/Windows/System32/Npcap" : (String)prop + ";C:/Windows/System32/Npcap";
            System.setProperty("jna.library.path", (String)prop);
        }
    }

    @Override
    public RbelCapturer initialize() {
        PCapCapture.setWindowsNpcapPath();
        if (this.pcapFile != null) {
            this.getOfflinePcapHandle();
        } else if (this.deviceName != null) {
            this.getOnlineHandle();
        } else {
            throw new IllegalArgumentException("Either device or pcap file must be specified");
        }
        if (!this.handle.isOpen()) {
            throw new RuntimeException("Source not open for reading!");
        }
        if (this.filter == null) {
            this.filter = "host 127.0.0.1 and tcp port 8080";
        }
        log.info("Applying filter '" + this.filter + "'");
        this.captureThread = new Thread(() -> {
            try {
                this.handle.setFilter(this.filter, BpfProgram.BpfCompileMode.OPTIMIZE);
                int maxPackets = -1;
                this.handle.loop(-1, (PacketListener)new RBelPacketListener(this.handle, this.dumper));
            }
            catch (InterruptedException e) {
                log.info("Packet capturing interrupted...");
            }
            catch (NotOpenException | PcapNativeException e) {
                throw new RuntimeException(e);
            }
        });
        this.captureThread.start();
        return this;
    }

    private void getOnlineHandle() {
        try {
            this.getLivePcapHandle();
            this.dumper = this.handle.dumpOpen("out.pcap");
        }
        catch (NotOpenException | PcapNativeException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() {
        try {
            this.captureThread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        try {
            this.handle.breakLoop();
        }
        catch (NotOpenException notOpenException) {
            // empty catch block
        }
        this.tryToPrintStats();
        this.handle.close();
        if (this.dumper != null) {
            this.dumper.close();
        }
    }

    private void tryToPrintStats() {
        if (this.deviceName != null && this.printMessageToSystemOut) {
            try {
                PcapStat stats = this.handle.getStats();
                log.info("Packets received: " + stats.getNumPacketsReceived());
                log.info("Packets dropped: " + stats.getNumPacketsDropped());
                log.info("Packets dropped by interface: " + stats.getNumPacketsDroppedByIf());
                if (Platform.isWindows()) {
                    log.info("Packets captured: " + stats.getNumPacketsCaptured());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void getLivePcapHandle() {
        log.info("Capturing traffic live from device " + this.deviceName);
        PcapNetworkInterface device = Pcaps.getDevByName((String)this.deviceName);
        int snapshotLength = 65536;
        int readTimeout = 50;
        this.handle = device.openLive(65536, PcapNetworkInterface.PromiscuousMode.PROMISCUOUS, 50);
    }

    private void getOfflinePcapHandle() {
        log.info("Reading traffic from pcap file " + new File(this.pcapFile).getAbsolutePath());
        try {
            this.handle = Pcaps.openOffline((String)this.pcapFile, (PcapHandle.TimestampPrecision)PcapHandle.TimestampPrecision.NANO);
        }
        catch (PcapNativeException e) {
            try {
                this.handle = Pcaps.openOffline((String)this.pcapFile);
            }
            catch (PcapNativeException e1) {
                throw new RuntimeException(e1);
            }
        }
    }

    public static PCapCaptureBuilder builder() {
        return new PCapCaptureBuilder();
    }

    public static class PCapCaptureBuilder {
        private RbelConverter rbelConverter;
        private String deviceName;
        private String pcapFile;
        private String filter;
        private boolean printMessageToSystemOut;

        PCapCaptureBuilder() {
        }

        public PCapCaptureBuilder rbelConverter(RbelConverter rbelConverter) {
            this.rbelConverter = rbelConverter;
            return this;
        }

        public PCapCaptureBuilder deviceName(String deviceName) {
            this.deviceName = deviceName;
            return this;
        }

        public PCapCaptureBuilder pcapFile(String pcapFile) {
            this.pcapFile = pcapFile;
            return this;
        }

        public PCapCaptureBuilder filter(String filter) {
            this.filter = filter;
            return this;
        }

        public PCapCaptureBuilder printMessageToSystemOut(boolean printMessageToSystemOut) {
            this.printMessageToSystemOut = printMessageToSystemOut;
            return this;
        }

        public PCapCapture build() {
            return new PCapCapture(this.rbelConverter, this.deviceName, this.pcapFile, this.filter, this.printMessageToSystemOut);
        }

        public String toString() {
            return "PCapCapture.PCapCaptureBuilder(rbelConverter=" + this.rbelConverter + ", deviceName=" + this.deviceName + ", pcapFile=" + this.pcapFile + ", filter=" + this.filter + ", printMessageToSystemOut=" + this.printMessageToSystemOut + ")";
        }
    }

    class RBelPacketListener
    implements PacketListener {
        private final PcapHandle handle;
        private final PcapDumper dumper;
        private boolean chunkedTransfer = false;
        private String chunkedMessage;

        public void gotPacket(Packet packet) {
            String content = this.getPayloadAsString(packet);
            this.processMessage(content);
            try {
                if (this.dumper != null) {
                    this.dumper.dump(packet, this.handle.getTimestamp());
                }
            }
            catch (NotOpenException e) {
                e.printStackTrace();
            }
        }

        private void processMessage(String content) {
            try {
                if (this.chunkedTransfer) {
                    this.processChunkedMessage(content);
                }
                if (!this.chunkedTransfer) {
                    this.processSimpleHttpPackets(content);
                }
            }
            catch (Exception e) {
                throw new PCapException("Failed parsing content '" + content + "'", e);
            }
        }

        private void processChunkedMessage(String content) {
            if (!this.isHttp(content)) {
                int eol = content.indexOf("\r\n");
                this.chunkedMessage = this.chunkedMessage + (eol == -1 ? content : content.substring(eol + 4));
            } else {
                RbelElement convertedMultiPartMsg = PCapCapture.this.getRbelConverter().convertMessage(this.chunkedMessage);
                if (PCapCapture.this.printMessageToSystemOut) {
                    log.info("Multi:" + convertedMultiPartMsg.getContent());
                }
                this.chunkedMessage = null;
                this.chunkedTransfer = false;
            }
        }

        private void processSimpleHttpPackets(String content) {
            RbelElement convertMessage;
            if (content.contains("GET /EXIT_RBELLOGGER")) {
                this.handle.breakLoop();
                return;
            }
            if (this.isHttpResponse(content)) {
                convertMessage = PCapCapture.this.getRbelConverter().convertMessage(content);
            } else if (this.isGetOrDeleteRequest(content)) {
                convertMessage = PCapCapture.this.getRbelConverter().convertMessage(content);
            } else if (content.startsWith("POST ") || content.startsWith("PUT")) {
                this.chunkedMessage = content;
                this.chunkedTransfer = true;
                convertMessage = null;
            } else {
                convertMessage = PCapCapture.this.getRbelConverter().convertMessage(content);
            }
            if (PCapCapture.this.printMessageToSystemOut && convertMessage != null && !content.isEmpty()) {
                log.info("RBEL: " + convertMessage.getContent());
            }
        }

        private String getPayloadAsString(Packet packet) {
            Packet pp = packet.getPayload();
            if (pp == null) {
                throw new PCapException("Payload of packet is NULL!");
            }
            int offset = 0;
            while (pp != null) {
                if (pp.getHeader() != null) {
                    offset += pp.getHeader().length();
                }
                pp = pp.getPayload();
            }
            byte[] by = packet.getPayload().getRawData();
            by = Arrays.copyOfRange(by, offset, by.length);
            return new String(by);
        }

        private boolean isHttp(String content) {
            return this.isHttpRequest(content) || this.isHttpResponse(content);
        }

        private boolean isHttpResponse(String content) {
            return content.startsWith("HTTP/");
        }

        private boolean isHttpRequest(String content) {
            return this.isGetOrDeleteRequest(content) || this.isPostOrPutRequest(content);
        }

        private boolean isGetOrDeleteRequest(String content) {
            return content.startsWith("GET ") || content.startsWith("DELETE ");
        }

        private boolean isPostOrPutRequest(String content) {
            return content.startsWith("POST ") || content.startsWith("PUT ");
        }

        public RBelPacketListener(PcapHandle handle, PcapDumper dumper) {
            this.handle = handle;
            this.dumper = dumper;
        }
    }
}

