/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.apps;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import de.gematik.rbellogger.RbelLogger;
import de.gematik.rbellogger.captures.PCapCapture;
import de.gematik.rbellogger.converter.RbelConfiguration;
import de.gematik.rbellogger.converter.initializers.RbelKeyFolderInitializer;
import de.gematik.rbellogger.data.RbelJweElement;
import de.gematik.rbellogger.key.RbelKey;
import de.gematik.rbellogger.key.RbelKeyManager;
import de.gematik.rbellogger.renderer.RbelHtmlRenderer;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.pcap4j.core.PcapNativeException;
import org.pcap4j.core.Pcaps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import wiremock.org.apache.commons.codec.digest.DigestUtils;

public class PCapCaptureApp {
    private static final Logger log = LoggerFactory.getLogger(PCapCaptureApp.class);
    @Parameter(names={"-device"})
    private String deviceName;
    @Parameter(names={"-keyFolder"})
    private String keyFolder;
    @Parameter(names={"-list-devices"})
    private boolean listDevices;
    @Parameter(names={"-pcap"})
    private String pcapFile;
    @Parameter(names={"-filter"})
    private String filter;
    @Parameter(names={"-dump"})
    private boolean printMessageToSystemOut;
    @Parameter(names={"-html"})
    private String htmlFile;

    public static void main(String[] args) {
        PCapCaptureApp.setWindowsNpcapPath();
        PCapCaptureApp main = new PCapCaptureApp();
        JCommander.newBuilder().addObject((Object)main).build().parse(args);
        main.run();
    }

    private static void setWindowsNpcapPath() {
        if (System.getProperty("os.name").startsWith("Windows")) {
            Object prop = System.getProperty("jna.library.path");
            prop = prop == null || ((String)prop).isEmpty() ? "C:/Windows/System32/Npcap" : (String)prop + ";C:/Windows/System32/Npcap";
            System.setProperty("jna.library.path", (String)prop);
        }
    }

    public void run() {
        if (this.printMessageToSystemOut) {
            log.info("Activated system out channel");
        }
        if (this.listDevices) {
            this.printAllPcapDevicesToSystemOut();
            return;
        }
        RbelLogger rbelLogger = RbelLogger.build(new RbelConfiguration().addKey("IDP symmetricEncryptionKey", new SecretKeySpec(DigestUtils.sha256((String)"geheimerSchluesselDerNochGehashtWird"), "AES"), RbelKey.PRECEDENCE_KEY_FOLDER).addInitializer(new RbelKeyFolderInitializer(this.keyFolder)).addPostConversionListener(RbelJweElement.class, RbelKeyManager.RBEL_IDP_TOKEN_KEY_LISTENER).addCapturer(PCapCapture.builder().printMessageToSystemOut(true).deviceName(this.deviceName).filter(this.filter).build()));
        if (StringUtils.isNotBlank((CharSequence)this.htmlFile)) {
            Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                try {
                    FileUtils.writeStringToFile((File)new File(this.htmlFile), (String)RbelHtmlRenderer.render(rbelLogger.getMessageHistory()), (Charset)Charset.defaultCharset());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                log.info("Saved HTML report to " + new File(this.htmlFile).getAbsolutePath());
            }));
        }
        while (true) {
            try {
                while (true) {
                    Thread.sleep(10L);
                }
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    private void printAllPcapDevicesToSystemOut() throws PcapNativeException {
        Pcaps.findAllDevs().forEach(dev -> log.info((dev.isUp() ? "UP " : "DOWN ") + dev.getName() + " - " + dev.getDescription()));
    }

    private static String $default$deviceName() {
        return "lo0";
    }

    private static String $default$keyFolder() {
        return "src/test/resources";
    }

    private static String $default$htmlFile() {
        return "out.html";
    }

    public static PCapCaptureAppBuilder builder() {
        return new PCapCaptureAppBuilder();
    }

    public PCapCaptureApp() {
        this.deviceName = PCapCaptureApp.$default$deviceName();
        this.keyFolder = PCapCaptureApp.$default$keyFolder();
        this.htmlFile = PCapCaptureApp.$default$htmlFile();
    }

    public PCapCaptureApp(String deviceName, String keyFolder, boolean listDevices, String pcapFile, String filter, boolean printMessageToSystemOut, String htmlFile) {
        this.deviceName = deviceName;
        this.keyFolder = keyFolder;
        this.listDevices = listDevices;
        this.pcapFile = pcapFile;
        this.filter = filter;
        this.printMessageToSystemOut = printMessageToSystemOut;
        this.htmlFile = htmlFile;
    }

    public static class PCapCaptureAppBuilder {
        private boolean deviceName$set;
        private String deviceName$value;
        private boolean keyFolder$set;
        private String keyFolder$value;
        private boolean listDevices;
        private String pcapFile;
        private String filter;
        private boolean printMessageToSystemOut;
        private boolean htmlFile$set;
        private String htmlFile$value;

        PCapCaptureAppBuilder() {
        }

        public PCapCaptureAppBuilder deviceName(String deviceName) {
            this.deviceName$value = deviceName;
            this.deviceName$set = true;
            return this;
        }

        public PCapCaptureAppBuilder keyFolder(String keyFolder) {
            this.keyFolder$value = keyFolder;
            this.keyFolder$set = true;
            return this;
        }

        public PCapCaptureAppBuilder listDevices(boolean listDevices) {
            this.listDevices = listDevices;
            return this;
        }

        public PCapCaptureAppBuilder pcapFile(String pcapFile) {
            this.pcapFile = pcapFile;
            return this;
        }

        public PCapCaptureAppBuilder filter(String filter) {
            this.filter = filter;
            return this;
        }

        public PCapCaptureAppBuilder printMessageToSystemOut(boolean printMessageToSystemOut) {
            this.printMessageToSystemOut = printMessageToSystemOut;
            return this;
        }

        public PCapCaptureAppBuilder htmlFile(String htmlFile) {
            this.htmlFile$value = htmlFile;
            this.htmlFile$set = true;
            return this;
        }

        public PCapCaptureApp build() {
            String deviceName$value = this.deviceName$value;
            if (!this.deviceName$set) {
                deviceName$value = PCapCaptureApp.$default$deviceName();
            }
            String keyFolder$value = this.keyFolder$value;
            if (!this.keyFolder$set) {
                keyFolder$value = PCapCaptureApp.$default$keyFolder();
            }
            String htmlFile$value = this.htmlFile$value;
            if (!this.htmlFile$set) {
                htmlFile$value = PCapCaptureApp.$default$htmlFile();
            }
            return new PCapCaptureApp(deviceName$value, keyFolder$value, this.listDevices, this.pcapFile, this.filter, this.printMessageToSystemOut, htmlFile$value);
        }

        public String toString() {
            return "PCapCaptureApp.PCapCaptureAppBuilder(deviceName$value=" + this.deviceName$value + ", keyFolder$value=" + this.keyFolder$value + ", listDevices=" + this.listDevices + ", pcapFile=" + this.pcapFile + ", filter=" + this.filter + ", printMessageToSystemOut=" + this.printMessageToSystemOut + ", htmlFile$value=" + this.htmlFile$value + ")";
        }
    }
}

