/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.apache.http.impl.entity;

import wiremock.org.apache.http.HttpException;
import wiremock.org.apache.http.HttpMessage;
import wiremock.org.apache.http.ProtocolException;
import wiremock.org.apache.http.annotation.Contract;
import wiremock.org.apache.http.annotation.ThreadingBehavior;
import wiremock.org.apache.http.entity.ContentLengthStrategy;
import wiremock.org.apache.http.impl.entity.LaxContentLengthStrategy;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class DisallowIdentityContentLengthStrategy
implements ContentLengthStrategy {
    public static final DisallowIdentityContentLengthStrategy INSTANCE = new DisallowIdentityContentLengthStrategy(new LaxContentLengthStrategy(0));
    private final ContentLengthStrategy contentLengthStrategy;

    public DisallowIdentityContentLengthStrategy(ContentLengthStrategy contentLengthStrategy) {
        this.contentLengthStrategy = contentLengthStrategy;
    }

    @Override
    public long determineLength(HttpMessage message) throws HttpException {
        long result = this.contentLengthStrategy.determineLength(message);
        if (result == -1L) {
            throw new ProtocolException("Identity transfer encoding cannot be used");
        }
        return result;
    }
}

