/*
 * Decompiled with CFR 0.152.
 */
package org.jnetpcap.packet;

import java.lang.ref.WeakReference;
import org.jnetpcap.JBufferHandler;
import org.jnetpcap.PcapHeader;
import org.jnetpcap.nio.JBuffer;
import org.jnetpcap.nio.JMemory;
import org.jnetpcap.packet.JHeader;
import org.jnetpcap.packet.JHeaderPool;
import org.jnetpcap.packet.JPacket;
import org.jnetpcap.packet.JPcapRecordBuffer;
import org.jnetpcap.packet.PcapPacket;
import org.jnetpcap.packet.TestUtils;

public class TestHeaderState
extends TestUtils {
    final JHeader.State headerState = new JHeader.State(JMemory.POINTER);
    private static WeakReference<JPcapRecordBuffer> bufferRef = null;

    protected JPcapRecordBuffer getBuffer() {
        if (bufferRef == null || bufferRef.get() == null) {
            bufferRef = new WeakReference<JPcapRecordBuffer>(TestHeaderState.loadAllTestPackets());
        }
        return (JPcapRecordBuffer)bufferRef.get();
    }

    public void testRawHeaderdBounds() {
        JPcapRecordBuffer jPcapRecordBuffer = this.getBuffer();
        jPcapRecordBuffer.dispatchToJBuffeHandler(new JBufferHandler<String>(){

            @Override
            public void nextPacket(PcapHeader pcapHeader, JBuffer jBuffer, String string) {
                PcapPacket pcapPacket = new PcapPacket(pcapHeader, jBuffer);
                pcapPacket.scan(1);
                JPacket.State state = pcapPacket.getState();
                for (int i = 0; i < state.getHeaderCount(); ++i) {
                    int n = state.getHeaderOffsetByIndex(i);
                    int n2 = state.getHeaderLengthByIndex(i);
                    pcapPacket.getByteArray(n, n2);
                }
            }
        }, "");
    }

    public void testRawHeaderPropertyAccessAndBounds() {
        JPcapRecordBuffer jPcapRecordBuffer = this.getBuffer();
        out = DISCARD;
        jPcapRecordBuffer.dispatchToJBuffeHandler(new JBufferHandler<String>(){

            @Override
            public void nextPacket(PcapHeader pcapHeader, JBuffer jBuffer, String string) {
                PcapPacket pcapPacket = new PcapPacket(pcapHeader, jBuffer);
                pcapPacket.scan(1);
                JPacket.State state = pcapPacket.getState();
                for (int i = 0; i < state.getHeaderCount(); ++i) {
                    int n = state.getHeaderIdByIndex(i);
                    state.peerHeaderByIndex(i, TestHeaderState.this.headerState);
                    int n2 = TestHeaderState.this.headerState.getOffset();
                    int n3 = TestHeaderState.this.headerState.getPrefix();
                    int n4 = TestHeaderState.this.headerState.getLength();
                    int n5 = TestHeaderState.this.headerState.getGap();
                    int n6 = TestHeaderState.this.headerState.getPayload();
                    int n7 = TestHeaderState.this.headerState.getPostfix();
                    if (TestUtils.out != TestUtils.DISCARD) {
                        TestUtils.out.printf("#%d.%d(%d):: packet.size=%d start=%d pre=%d hdr=%d gap=%d pay=%d post=%d%n", pcapPacket.getFrameNumber(), i, n, pcapPacket.size(), n2, n3, n4, n5, n6, n7);
                    }
                    pcapPacket.getByteArray(n2 - n3, n3);
                    pcapPacket.getByteArray(n2, n4);
                    pcapPacket.getByteArray(n2 + n4, n5);
                    pcapPacket.getByteArray(n2 + n4 + n5, n6);
                    pcapPacket.getByteArray(n2 + n4 + n5 + n6, n7);
                }
            }
        }, "");
    }

    public void testJHeaderPropertyAccessAndBounds() {
        JPcapRecordBuffer jPcapRecordBuffer = this.getBuffer();
        final JHeaderPool jHeaderPool = new JHeaderPool();
        out = DISCARD;
        jPcapRecordBuffer.dispatchToJBuffeHandler(new JBufferHandler<String>(){

            @Override
            public void nextPacket(PcapHeader pcapHeader, JBuffer jBuffer, String string) {
                PcapPacket pcapPacket = new PcapPacket(pcapHeader, jBuffer);
                pcapPacket.scan(1);
                JPacket.State state = pcapPacket.getState();
                for (int i = 0; i < state.getHeaderCount(); ++i) {
                    int n = state.getHeaderIdByIndex(i);
                    JHeader jHeader = jHeaderPool.getHeader(n);
                    pcapPacket.getHeaderByIndex(i, jHeader);
                    if (TestUtils.out != TestUtils.DISCARD) {
                        TestUtils.out.printf("#%d.%d(%d):: packet.size=%d start=%d length=%d pre=%d hdr=%d gap=%d pay=%d post=%d%n", pcapPacket.getFrameNumber(), i, n, pcapPacket.size(), jHeader.getOffset(), jHeader.getLength(), jHeader.getPrefixOffset(), jHeader.getOffset(), jHeader.getGapOffset(), jHeader.getPayloadOffset(), jHeader.getPostfixOffset());
                    }
                    pcapPacket.getByteArray(jHeader.getPrefixOffset(), jHeader.getPrefixLength());
                    pcapPacket.getByteArray(jHeader.getOffset(), jHeader.getLength());
                    pcapPacket.getByteArray(jHeader.getGapOffset(), jHeader.getGapLength());
                    pcapPacket.getByteArray(jHeader.getPayloadOffset(), jHeader.getPayloadLength());
                    pcapPacket.getByteArray(jHeader.getPostfixOffset(), jHeader.getPostfixLength());
                }
            }
        }, "");
    }
}

