/*
 * Decompiled with CFR 0.152.
 */
package org.jnetpcap.packet;

import java.nio.ByteBuffer;
import junit.framework.TestCase;
import org.jnetpcap.ByteBufferHandler;
import org.jnetpcap.JBufferHandler;
import org.jnetpcap.Pcap;
import org.jnetpcap.PcapHeader;
import org.jnetpcap.nio.JBuffer;
import org.jnetpcap.nio.JMemory;
import org.jnetpcap.packet.JPacket;
import org.jnetpcap.packet.JPacketHandler;
import org.jnetpcap.packet.JScanner;
import org.jnetpcap.packet.PcapPacket;
import org.jnetpcap.packet.PeeringException;
import org.jnetpcap.packet.TestUtils;
import org.jnetpcap.packet.format.FormatUtils;
import org.jnetpcap.protocol.lan.Ethernet;
import org.jnetpcap.protocol.network.Ip4;
import org.jnetpcap.protocol.network.Ip6;

public class JHandlerTest
extends TestCase
implements ByteBufferHandler<String>,
JBufferHandler<String>,
JPacketHandler<String> {
    private Ethernet ethernet = new Ethernet();
    private Ip4 ip4 = new Ip4();
    private Ip6 ip6 = new Ip6();
    private PcapPacket packet = new PcapPacket(JMemory.Type.POINTER);
    private JScanner scanner = new JScanner();
    private Pcap pcap;

    protected void setUp() throws Exception {
        this.pcap = TestUtils.openOffline("tests/test-afs.pcap");
        JHandlerTest.assertNotNull((Object)this.pcap);
    }

    protected void tearDown() throws Exception {
        JHandlerTest.assertNotNull((Object)this.pcap);
        this.pcap.close();
    }

    public void testJScannerHandler() {
        this.pcap.dispatch(2, 1, this, "JPacket - testcase");
    }

    public void testJBufferHandler() {
        this.pcap.dispatch(2, this, "JBuffer - testcase");
    }

    public void testPcapHandler() {
        this.pcap.dispatch(2, this, "Pcap handler - testcase");
    }

    @Override
    public void nextPacket(PcapHeader pcapHeader, JBuffer jBuffer, String string) {
        this.packet.peerHeaderAndData(pcapHeader, jBuffer);
        this.scanner.scan(this.packet, 1);
        JHandlerTest.assertTrue((this.packet.getPacketWirelen() > 0 ? 1 : 0) != 0);
        System.out.printf("JHandlerTest::nextPacket() - %s\n", this.packet.getState().toDebugString());
        if (this.packet.hasHeader(this.ethernet)) {
            System.out.println("ethernet.dst=" + this.ethernet.destination());
        }
        if (this.packet.hasHeader(this.ip4)) {
            System.out.println("ip4.ver=" + this.ip4.version());
        }
        if (this.packet.hasHeader(this.ip6)) {
            System.out.println("ip4.ver=" + this.ip4.version());
        }
    }

    @Override
    public void nextPacket(JPacket jPacket, String string) {
        System.out.printf("state=%s", jPacket.getState().toDebugString());
        if (jPacket.hasHeader(this.ethernet)) {
            System.out.println("ethernet.dst=" + FormatUtils.asString(this.ethernet.destination(), ':'));
        }
        if (jPacket.hasHeader(this.ip4)) {
            System.out.println("ip4.ver=" + this.ip4.version());
        }
        if (jPacket.hasHeader(this.ip6)) {
            System.out.println("ip4.ver=" + this.ip4.version());
        }
    }

    @Override
    public void nextPacket(PcapHeader pcapHeader, ByteBuffer byteBuffer, String string) {
        try {
            this.packet.peerHeaderAndData(pcapHeader, byteBuffer);
        }
        catch (PeeringException peeringException) {
            peeringException.printStackTrace();
        }
        this.scanner.scan(this.packet, 1);
        if (this.packet.hasHeader(this.ethernet)) {
            System.out.println("ethernet.dst=" + this.ethernet.destination());
        }
        if (this.packet.hasHeader(this.ip4)) {
            System.out.println("ip4.ver=" + this.ip4.version());
        }
        if (this.packet.hasHeader(this.ip6)) {
            System.out.println("ip4.ver=" + this.ip4.version());
        }
    }
}

