/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.math.ec;

import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.Hashtable;
import java.util.Random;
import org.bouncycastle.math.ec.AbstractECLookupTable;
import org.bouncycastle.math.ec.ECAlgorithms;
import org.bouncycastle.math.ec.ECConstants;
import org.bouncycastle.math.ec.ECFieldElement;
import org.bouncycastle.math.ec.ECLookupTable;
import org.bouncycastle.math.ec.ECMultiplier;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.math.ec.GLVMultiplier;
import org.bouncycastle.math.ec.LongArray;
import org.bouncycastle.math.ec.PreCompCallback;
import org.bouncycastle.math.ec.PreCompInfo;
import org.bouncycastle.math.ec.Tnaf;
import org.bouncycastle.math.ec.WNafL2RMultiplier;
import org.bouncycastle.math.ec.endo.ECEndomorphism;
import org.bouncycastle.math.ec.endo.GLVEndomorphism;
import org.bouncycastle.math.field.FiniteField;
import org.bouncycastle.math.field.FiniteFields;
import org.bouncycastle.util.BigIntegers;
import org.bouncycastle.util.Integers;

public abstract class ECCurve {
    public static final int COORD_AFFINE = 0;
    public static final int COORD_HOMOGENEOUS = 1;
    public static final int COORD_JACOBIAN = 2;
    public static final int COORD_JACOBIAN_CHUDNOVSKY = 3;
    public static final int COORD_JACOBIAN_MODIFIED = 4;
    public static final int COORD_LAMBDA_AFFINE = 5;
    public static final int COORD_LAMBDA_PROJECTIVE = 6;
    public static final int COORD_SKEWED = 7;
    protected FiniteField field;
    protected ECFieldElement a;
    protected ECFieldElement b;
    protected BigInteger order;
    protected BigInteger cofactor;
    protected int coord = 0;
    protected ECEndomorphism endomorphism = null;
    protected ECMultiplier multiplier = null;

    public static int[] getAllCoordinateSystems() {
        return new int[]{0, 1, 2, 3, 4, 5, 6, 7};
    }

    protected ECCurve(FiniteField finiteField) {
        this.field = finiteField;
    }

    public abstract int getFieldSize();

    public abstract ECFieldElement fromBigInteger(BigInteger var1);

    public abstract boolean isValidFieldElement(BigInteger var1);

    public abstract ECFieldElement randomFieldElement(SecureRandom var1);

    public abstract ECFieldElement randomFieldElementMult(SecureRandom var1);

    public synchronized Config configure() {
        return new Config(this.coord, this.endomorphism, this.multiplier);
    }

    public ECPoint validatePoint(BigInteger bigInteger, BigInteger bigInteger2) {
        ECPoint eCPoint = this.createPoint(bigInteger, bigInteger2);
        if (!eCPoint.isValid()) {
            throw new IllegalArgumentException("Invalid point coordinates");
        }
        return eCPoint;
    }

    public ECPoint createPoint(BigInteger bigInteger, BigInteger bigInteger2) {
        return this.createRawPoint(this.fromBigInteger(bigInteger), this.fromBigInteger(bigInteger2));
    }

    protected abstract ECCurve cloneCurve();

    protected abstract ECPoint createRawPoint(ECFieldElement var1, ECFieldElement var2);

    protected abstract ECPoint createRawPoint(ECFieldElement var1, ECFieldElement var2, ECFieldElement[] var3);

    protected ECMultiplier createDefaultMultiplier() {
        if (this.endomorphism instanceof GLVEndomorphism) {
            return new GLVMultiplier(this, (GLVEndomorphism)this.endomorphism);
        }
        return new WNafL2RMultiplier();
    }

    public boolean supportsCoordinateSystem(int n) {
        return n == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PreCompInfo getPreCompInfo(ECPoint eCPoint, String string) {
        Hashtable hashtable;
        this.checkPoint(eCPoint);
        Object object = eCPoint;
        synchronized (object) {
            hashtable = eCPoint.preCompTable;
        }
        if (null == hashtable) {
            return null;
        }
        object = hashtable;
        synchronized (object) {
            return (PreCompInfo)hashtable.get(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PreCompInfo precompute(ECPoint eCPoint, String string, PreCompCallback preCompCallback) {
        Hashtable<String, PreCompInfo> hashtable;
        this.checkPoint(eCPoint);
        Object object = eCPoint;
        synchronized (object) {
            hashtable = eCPoint.preCompTable;
            if (null == hashtable) {
                eCPoint.preCompTable = hashtable = new Hashtable<String, PreCompInfo>(4);
            }
        }
        object = hashtable;
        synchronized (object) {
            PreCompInfo preCompInfo = (PreCompInfo)hashtable.get(string);
            PreCompInfo preCompInfo2 = preCompCallback.precompute(preCompInfo);
            if (preCompInfo2 != preCompInfo) {
                hashtable.put(string, preCompInfo2);
            }
            return preCompInfo2;
        }
    }

    public ECPoint importPoint(ECPoint eCPoint) {
        if (this == eCPoint.getCurve()) {
            return eCPoint;
        }
        if (eCPoint.isInfinity()) {
            return this.getInfinity();
        }
        eCPoint = eCPoint.normalize();
        return this.createPoint(eCPoint.getXCoord().toBigInteger(), eCPoint.getYCoord().toBigInteger());
    }

    public void normalizeAll(ECPoint[] eCPointArray) {
        this.normalizeAll(eCPointArray, 0, eCPointArray.length, null);
    }

    public void normalizeAll(ECPoint[] eCPointArray, int n, int n2, ECFieldElement eCFieldElement) {
        int n3;
        this.checkPoints(eCPointArray, n, n2);
        switch (this.getCoordinateSystem()) {
            case 0: 
            case 5: {
                if (eCFieldElement != null) {
                    throw new IllegalArgumentException("'iso' not valid for affine coordinates");
                }
                return;
            }
        }
        ECFieldElement[] eCFieldElementArray = new ECFieldElement[n2];
        int[] nArray = new int[n2];
        int n4 = 0;
        for (n3 = 0; n3 < n2; ++n3) {
            ECPoint eCPoint = eCPointArray[n + n3];
            if (null == eCPoint || eCFieldElement == null && eCPoint.isNormalized()) continue;
            eCFieldElementArray[n4] = eCPoint.getZCoord(0);
            nArray[n4++] = n + n3;
        }
        if (n4 == 0) {
            return;
        }
        ECAlgorithms.montgomeryTrick((ECFieldElement[])eCFieldElementArray, (int)0, (int)n4, (ECFieldElement)eCFieldElement);
        for (n3 = 0; n3 < n4; ++n3) {
            int n5 = nArray[n3];
            eCPointArray[n5] = eCPointArray[n5].normalize(eCFieldElementArray[n3]);
        }
    }

    public abstract ECPoint getInfinity();

    public FiniteField getField() {
        return this.field;
    }

    public ECFieldElement getA() {
        return this.a;
    }

    public ECFieldElement getB() {
        return this.b;
    }

    public BigInteger getOrder() {
        return this.order;
    }

    public BigInteger getCofactor() {
        return this.cofactor;
    }

    public int getCoordinateSystem() {
        return this.coord;
    }

    protected abstract ECPoint decompressPoint(int var1, BigInteger var2);

    public ECEndomorphism getEndomorphism() {
        return this.endomorphism;
    }

    public synchronized ECMultiplier getMultiplier() {
        if (this.multiplier == null) {
            this.multiplier = this.createDefaultMultiplier();
        }
        return this.multiplier;
    }

    public ECPoint decodePoint(byte[] byArray) {
        ECPoint eCPoint = null;
        int n = (this.getFieldSize() + 7) / 8;
        byte by = byArray[0];
        switch (by) {
            case 0: {
                if (byArray.length != 1) {
                    throw new IllegalArgumentException("Incorrect length for infinity encoding");
                }
                eCPoint = this.getInfinity();
                break;
            }
            case 2: 
            case 3: {
                if (byArray.length != n + 1) {
                    throw new IllegalArgumentException("Incorrect length for compressed encoding");
                }
                int n2 = by & 1;
                BigInteger bigInteger = BigIntegers.fromUnsignedByteArray((byte[])byArray, (int)1, (int)n);
                eCPoint = this.decompressPoint(n2, bigInteger);
                if (eCPoint.implIsValid(true, true)) break;
                throw new IllegalArgumentException("Invalid point");
            }
            case 4: {
                if (byArray.length != 2 * n + 1) {
                    throw new IllegalArgumentException("Incorrect length for uncompressed encoding");
                }
                BigInteger bigInteger = BigIntegers.fromUnsignedByteArray((byte[])byArray, (int)1, (int)n);
                BigInteger bigInteger2 = BigIntegers.fromUnsignedByteArray((byte[])byArray, (int)(1 + n), (int)n);
                eCPoint = this.validatePoint(bigInteger, bigInteger2);
                break;
            }
            case 6: 
            case 7: {
                if (byArray.length != 2 * n + 1) {
                    throw new IllegalArgumentException("Incorrect length for hybrid encoding");
                }
                BigInteger bigInteger = BigIntegers.fromUnsignedByteArray((byte[])byArray, (int)1, (int)n);
                BigInteger bigInteger3 = BigIntegers.fromUnsignedByteArray((byte[])byArray, (int)(1 + n), (int)n);
                if (bigInteger3.testBit(0) != (by == 7)) {
                    throw new IllegalArgumentException("Inconsistent Y coordinate in hybrid encoding");
                }
                eCPoint = this.validatePoint(bigInteger, bigInteger3);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid point encoding 0x" + Integer.toString(by, 16));
            }
        }
        if (by != 0 && eCPoint.isInfinity()) {
            throw new IllegalArgumentException("Invalid infinity encoding");
        }
        return eCPoint;
    }

    public ECLookupTable createCacheSafeLookupTable(ECPoint[] eCPointArray, int n, final int n2) {
        final int n3 = this.getFieldSize() + 7 >>> 3;
        final byte[] byArray = new byte[n2 * n3 * 2];
        int n4 = 0;
        for (int i = 0; i < n2; ++i) {
            ECPoint eCPoint = eCPointArray[n + i];
            byte[] byArray2 = eCPoint.getRawXCoord().toBigInteger().toByteArray();
            byte[] byArray3 = eCPoint.getRawYCoord().toBigInteger().toByteArray();
            int n5 = byArray2.length > n3 ? 1 : 0;
            int n6 = byArray2.length - n5;
            int n7 = byArray3.length > n3 ? 1 : 0;
            int n8 = byArray3.length - n7;
            System.arraycopy(byArray2, n5, byArray, n4 + n3 - n6, n6);
            System.arraycopy(byArray3, n7, byArray, (n4 += n3) + n3 - n8, n8);
            n4 += n3;
        }
        return new AbstractECLookupTable(){

            public int getSize() {
                return n2;
            }

            public ECPoint lookup(int n) {
                byte[] byArray3 = new byte[n3];
                byte[] byArray2 = new byte[n3];
                int n22 = 0;
                for (int i = 0; i < n2; ++i) {
                    int n32 = (i ^ n) - 1 >> 31;
                    for (int j = 0; j < n3; ++j) {
                        int n4 = j;
                        byArray3[n4] = (byte)(byArray3[n4] ^ byArray[n22 + j] & n32);
                        int n5 = j;
                        byArray2[n5] = (byte)(byArray2[n5] ^ byArray[n22 + n3 + j] & n32);
                    }
                    n22 += n3 * 2;
                }
                return this.createPoint(byArray3, byArray2);
            }

            public ECPoint lookupVar(int n) {
                byte[] byArray3 = new byte[n3];
                byte[] byArray2 = new byte[n3];
                int n22 = n * n3 * 2;
                for (int i = 0; i < n3; ++i) {
                    byArray3[i] = byArray[n22 + i];
                    byArray2[i] = byArray[n22 + n3 + i];
                }
                return this.createPoint(byArray3, byArray2);
            }

            private ECPoint createPoint(byte[] byArray3, byte[] byArray2) {
                return ECCurve.this.createRawPoint(ECCurve.this.fromBigInteger(new BigInteger(1, byArray3)), ECCurve.this.fromBigInteger(new BigInteger(1, byArray2)));
            }
        };
    }

    protected void checkPoint(ECPoint eCPoint) {
        if (null == eCPoint || this != eCPoint.getCurve()) {
            throw new IllegalArgumentException("'point' must be non-null and on this curve");
        }
    }

    protected void checkPoints(ECPoint[] eCPointArray) {
        this.checkPoints(eCPointArray, 0, eCPointArray.length);
    }

    protected void checkPoints(ECPoint[] eCPointArray, int n, int n2) {
        if (eCPointArray == null) {
            throw new IllegalArgumentException("'points' cannot be null");
        }
        if (n < 0 || n2 < 0 || n > eCPointArray.length - n2) {
            throw new IllegalArgumentException("invalid range specified for 'points'");
        }
        for (int i = 0; i < n2; ++i) {
            ECPoint eCPoint = eCPointArray[n + i];
            if (null == eCPoint || this == eCPoint.getCurve()) continue;
            throw new IllegalArgumentException("'points' entries must be null or on this curve");
        }
    }

    public boolean equals(ECCurve eCCurve) {
        return this == eCCurve || null != eCCurve && this.getField().equals(eCCurve.getField()) && this.getA().toBigInteger().equals(eCCurve.getA().toBigInteger()) && this.getB().toBigInteger().equals(eCCurve.getB().toBigInteger());
    }

    public boolean equals(Object object) {
        return this == object || object instanceof ECCurve && this.equals((ECCurve)object);
    }

    public int hashCode() {
        return this.getField().hashCode() ^ Integers.rotateLeft(this.getA().toBigInteger().hashCode(), 8) ^ Integers.rotateLeft(this.getB().toBigInteger().hashCode(), 16);
    }

    public static class F2m
    extends ECCurve {
        private int m;
        private int k1;
        private int k2;
        private int k3;
        private BigInteger n;
        private BigInteger h;
        private ECPoint.F2m infinity;
        private byte mu = 0;
        private BigInteger[] si = null;

        public F2m(int n, int n2, BigInteger bigInteger, BigInteger bigInteger2) {
            this(n, n2, 0, 0, bigInteger, bigInteger2, null, null);
        }

        public F2m(int n, int n2, BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4) {
            this(n, n2, 0, 0, bigInteger, bigInteger2, bigInteger3, bigInteger4);
        }

        public F2m(int n, int n2, int n3, int n4, BigInteger bigInteger, BigInteger bigInteger2) {
            this(n, n2, n3, n4, bigInteger, bigInteger2, null, null);
        }

        public F2m(int n, int n2, int n3, int n4, BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4) {
            this.m = n;
            this.k1 = n2;
            this.k2 = n3;
            this.k3 = n4;
            this.n = bigInteger3;
            this.h = bigInteger4;
            if (n2 == 0) {
                throw new IllegalArgumentException("k1 must be > 0");
            }
            if (n3 == 0) {
                if (n4 != 0) {
                    throw new IllegalArgumentException("k3 must be 0 if k2 == 0");
                }
            } else {
                if (n3 <= n2) {
                    throw new IllegalArgumentException("k2 must be > k1");
                }
                if (n4 <= n3) {
                    throw new IllegalArgumentException("k3 must be > k2");
                }
            }
            this.a = this.fromBigInteger(bigInteger);
            this.b = this.fromBigInteger(bigInteger2);
            this.infinity = new ECPoint.F2m(this, null, null);
        }

        @Override
        public int getFieldSize() {
            return this.m;
        }

        @Override
        public ECFieldElement fromBigInteger(BigInteger bigInteger) {
            return new ECFieldElement.F2m(this.m, this.k1, this.k2, this.k3, bigInteger);
        }

        @Override
        public ECPoint createPoint(BigInteger bigInteger, BigInteger bigInteger2, boolean bl) {
            return new ECPoint.F2m(this, this.fromBigInteger(bigInteger), this.fromBigInteger(bigInteger2), bl);
        }

        @Override
        public ECPoint decodePoint(byte[] byArray) {
            ECPoint eCPoint = null;
            switch (byArray[0]) {
                case 0: {
                    if (byArray.length > 1) {
                        throw new RuntimeException("Invalid point encoding");
                    }
                    eCPoint = this.getInfinity();
                    break;
                }
                case 2: 
                case 3: {
                    byte[] byArray2 = new byte[byArray.length - 1];
                    System.arraycopy(byArray, 1, byArray2, 0, byArray2.length);
                    if (byArray[0] == 2) {
                        eCPoint = this.decompressPoint(byArray2, 0);
                        break;
                    }
                    eCPoint = this.decompressPoint(byArray2, 1);
                    break;
                }
                case 4: 
                case 6: 
                case 7: {
                    byte[] byArray3 = new byte[(byArray.length - 1) / 2];
                    byte[] byArray4 = new byte[(byArray.length - 1) / 2];
                    System.arraycopy(byArray, 1, byArray3, 0, byArray3.length);
                    System.arraycopy(byArray, byArray3.length + 1, byArray4, 0, byArray4.length);
                    eCPoint = new ECPoint.F2m(this, new ECFieldElement.F2m(this.m, this.k1, this.k2, this.k3, new BigInteger(1, byArray3)), new ECFieldElement.F2m(this.m, this.k1, this.k2, this.k3, new BigInteger(1, byArray4)), false);
                    break;
                }
                default: {
                    throw new RuntimeException("Invalid point encoding 0x" + Integer.toString(byArray[0], 16));
                }
            }
            return eCPoint;
        }

        @Override
        public ECPoint getInfinity() {
            return this.infinity;
        }

        public boolean isKoblitz() {
            return this.n != null && this.h != null && (this.a.toBigInteger().equals(ECConstants.ZERO) || this.a.toBigInteger().equals(ECConstants.ONE)) && this.b.toBigInteger().equals(ECConstants.ONE);
        }

        synchronized byte getMu() {
            if (this.mu == 0) {
                this.mu = Tnaf.getMu(this);
            }
            return this.mu;
        }

        synchronized BigInteger[] getSi() {
            if (this.si == null) {
                this.si = Tnaf.getSi(this);
            }
            return this.si;
        }

        private ECPoint decompressPoint(byte[] byArray, int n) {
            ECFieldElement.F2m f2m = new ECFieldElement.F2m(this.m, this.k1, this.k2, this.k3, new BigInteger(1, byArray));
            ECFieldElement eCFieldElement = null;
            if (((ECFieldElement)f2m).toBigInteger().equals(ECConstants.ZERO)) {
                eCFieldElement = (ECFieldElement.F2m)this.b;
                for (int i = 0; i < this.m - 1; ++i) {
                    eCFieldElement = ((ECFieldElement)eCFieldElement).square();
                }
            } else {
                ECFieldElement eCFieldElement2 = ((ECFieldElement)f2m).add(this.a).add(this.b.multiply(((ECFieldElement)f2m).square().invert()));
                ECFieldElement eCFieldElement3 = this.solveQuadradicEquation(eCFieldElement2);
                if (eCFieldElement3 == null) {
                    throw new RuntimeException("Invalid point compression");
                }
                int n2 = 0;
                if (eCFieldElement3.toBigInteger().testBit(0)) {
                    n2 = 1;
                }
                if (n2 != n) {
                    eCFieldElement3 = eCFieldElement3.add(new ECFieldElement.F2m(this.m, this.k1, this.k2, this.k3, ECConstants.ONE));
                }
                eCFieldElement = ((ECFieldElement)f2m).multiply(eCFieldElement3);
            }
            return new ECPoint.F2m(this, f2m, eCFieldElement);
        }

        private ECFieldElement solveQuadradicEquation(ECFieldElement eCFieldElement) {
            ECFieldElement.F2m f2m = new ECFieldElement.F2m(this.m, this.k1, this.k2, this.k3, ECConstants.ZERO);
            if (eCFieldElement.toBigInteger().equals(ECConstants.ZERO)) {
                return f2m;
            }
            ECFieldElement eCFieldElement2 = null;
            ECFieldElement eCFieldElement3 = f2m;
            Random random = new Random();
            do {
                ECFieldElement.F2m f2m2 = new ECFieldElement.F2m(this.m, this.k1, this.k2, this.k3, new BigInteger(this.m, random));
                eCFieldElement2 = f2m;
                ECFieldElement eCFieldElement4 = eCFieldElement;
                for (int i = 1; i <= this.m - 1; ++i) {
                    ECFieldElement eCFieldElement5 = eCFieldElement4.square();
                    eCFieldElement2 = ((ECFieldElement)eCFieldElement2).square().add(eCFieldElement5.multiply(f2m2));
                    eCFieldElement4 = eCFieldElement5.add(eCFieldElement);
                }
                if (eCFieldElement4.toBigInteger().equals(ECConstants.ZERO)) continue;
                return null;
            } while ((eCFieldElement3 = ((ECFieldElement)eCFieldElement2).square().add(eCFieldElement2)).toBigInteger().equals(ECConstants.ZERO));
            return eCFieldElement2;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof F2m)) {
                return false;
            }
            F2m f2m = (F2m)object;
            return this.m == f2m.m && this.k1 == f2m.k1 && this.k2 == f2m.k2 && this.k3 == f2m.k3 && this.a.equals(f2m.a) && this.b.equals(f2m.b);
        }

        public int hashCode() {
            return this.a.hashCode() ^ this.b.hashCode() ^ this.m ^ this.k1 ^ this.k2 ^ this.k3;
        }

        public int getM() {
            return this.m;
        }

        public boolean isTrinomial() {
            return this.k2 == 0 && this.k3 == 0;
        }

        public int getK1() {
            return this.k1;
        }

        public int getK2() {
            return this.k2;
        }

        public int getK3() {
            return this.k3;
        }

        public BigInteger getN() {
            return this.n;
        }

        public BigInteger getH() {
            return this.h;
        }
    }

    public static abstract class AbstractF2m
    extends ECCurve {
        private BigInteger[] si = null;

        public static BigInteger inverse(int n, int[] nArray, BigInteger bigInteger) {
            return new LongArray(bigInteger).modInverse(n, nArray).toBigInteger();
        }

        private static FiniteField buildField(int n, int n2, int n3, int n4) {
            if (n2 == 0) {
                throw new IllegalArgumentException("k1 must be > 0");
            }
            if (n3 == 0) {
                if (n4 != 0) {
                    throw new IllegalArgumentException("k3 must be 0 if k2 == 0");
                }
                return FiniteFields.getBinaryExtensionField(new int[]{0, n2, n});
            }
            if (n3 <= n2) {
                throw new IllegalArgumentException("k2 must be > k1");
            }
            if (n4 <= n3) {
                throw new IllegalArgumentException("k3 must be > k2");
            }
            return FiniteFields.getBinaryExtensionField(new int[]{0, n2, n3, n4, n});
        }

        protected AbstractF2m(int n, int n2, int n3, int n4) {
            super(AbstractF2m.buildField(n, n2, n3, n4));
        }

        public ECPoint createPoint(BigInteger bigInteger, BigInteger bigInteger2) {
            ECFieldElement eCFieldElement = this.fromBigInteger(bigInteger);
            ECFieldElement eCFieldElement2 = this.fromBigInteger(bigInteger2);
            int n = this.getCoordinateSystem();
            switch (n) {
                case 5: 
                case 6: {
                    if (eCFieldElement.isZero()) {
                        if (eCFieldElement2.square().equals(this.getB())) break;
                        throw new IllegalArgumentException();
                    }
                    eCFieldElement2 = eCFieldElement2.divide(eCFieldElement).add(eCFieldElement);
                    break;
                }
            }
            return this.createRawPoint(eCFieldElement, eCFieldElement2);
        }

        public boolean isValidFieldElement(BigInteger bigInteger) {
            return bigInteger != null && bigInteger.signum() >= 0 && bigInteger.bitLength() <= this.getFieldSize();
        }

        public ECFieldElement randomFieldElement(SecureRandom secureRandom) {
            int n = this.getFieldSize();
            return this.fromBigInteger(BigIntegers.createRandomBigInteger((int)n, (SecureRandom)secureRandom));
        }

        public ECFieldElement randomFieldElementMult(SecureRandom secureRandom) {
            int n = this.getFieldSize();
            ECFieldElement eCFieldElement = this.fromBigInteger(AbstractF2m.implRandomFieldElementMult(secureRandom, n));
            ECFieldElement eCFieldElement2 = this.fromBigInteger(AbstractF2m.implRandomFieldElementMult(secureRandom, n));
            return eCFieldElement.multiply(eCFieldElement2);
        }

        protected ECPoint decompressPoint(int n, BigInteger bigInteger) {
            ECFieldElement eCFieldElement = this.fromBigInteger(bigInteger);
            ECFieldElement eCFieldElement2 = null;
            if (eCFieldElement.isZero()) {
                eCFieldElement2 = this.getB().sqrt();
            } else {
                ECFieldElement eCFieldElement3 = eCFieldElement.square().invert().multiply(this.getB()).add(this.getA()).add(eCFieldElement);
                ECFieldElement eCFieldElement4 = this.solveQuadraticEquation(eCFieldElement3);
                if (eCFieldElement4 != null) {
                    if (eCFieldElement4.testBitZero() != (n == 1)) {
                        eCFieldElement4 = eCFieldElement4.addOne();
                    }
                    switch (this.getCoordinateSystem()) {
                        case 5: 
                        case 6: {
                            eCFieldElement2 = eCFieldElement4.add(eCFieldElement);
                            break;
                        }
                        default: {
                            eCFieldElement2 = eCFieldElement4.multiply(eCFieldElement);
                        }
                    }
                }
            }
            if (eCFieldElement2 == null) {
                throw new IllegalArgumentException("Invalid point compression");
            }
            return this.createRawPoint(eCFieldElement, eCFieldElement2);
        }

        protected ECFieldElement solveQuadraticEquation(ECFieldElement eCFieldElement) {
            ECFieldElement eCFieldElement2;
            ECFieldElement eCFieldElement3;
            ECFieldElement.AbstractF2m abstractF2m = (ECFieldElement.AbstractF2m)eCFieldElement;
            boolean bl = abstractF2m.hasFastTrace();
            if (bl && 0 != abstractF2m.trace()) {
                return null;
            }
            int n = this.getFieldSize();
            if (0 != (n & 1)) {
                ECFieldElement eCFieldElement4 = abstractF2m.halfTrace();
                if (bl || eCFieldElement4.square().add(eCFieldElement4).add(eCFieldElement).isZero()) {
                    return eCFieldElement4;
                }
                return null;
            }
            if (eCFieldElement.isZero()) {
                return eCFieldElement;
            }
            ECFieldElement eCFieldElement5 = this.fromBigInteger(ECConstants.ZERO);
            Random random = new Random();
            do {
                ECFieldElement eCFieldElement6 = this.fromBigInteger(new BigInteger(n, random));
                eCFieldElement2 = eCFieldElement5;
                ECFieldElement eCFieldElement7 = eCFieldElement;
                for (int i = 1; i < n; ++i) {
                    ECFieldElement eCFieldElement8 = eCFieldElement7.square();
                    eCFieldElement2 = eCFieldElement2.square().add(eCFieldElement8.multiply(eCFieldElement6));
                    eCFieldElement7 = eCFieldElement8.add(eCFieldElement);
                }
                if (eCFieldElement7.isZero()) continue;
                return null;
            } while ((eCFieldElement3 = eCFieldElement2.square().add(eCFieldElement2)).isZero());
            return eCFieldElement2;
        }

        synchronized BigInteger[] getSi() {
            if (this.si == null) {
                this.si = Tnaf.getSi((AbstractF2m)this);
            }
            return this.si;
        }

        public boolean isKoblitz() {
            return this.order != null && this.cofactor != null && this.b.isOne() && (this.a.isZero() || this.a.isOne());
        }

        private static BigInteger implRandomFieldElementMult(SecureRandom secureRandom, int n) {
            BigInteger bigInteger;
            while ((bigInteger = BigIntegers.createRandomBigInteger((int)n, (SecureRandom)secureRandom)).signum() <= 0) {
            }
            return bigInteger;
        }
    }

    public static class Fp
    extends ECCurve {
        BigInteger q;
        ECPoint.Fp infinity;

        public Fp(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3) {
            this.q = bigInteger;
            this.a = this.fromBigInteger(bigInteger2);
            this.b = this.fromBigInteger(bigInteger3);
            this.infinity = new ECPoint.Fp(this, null, null);
        }

        public BigInteger getQ() {
            return this.q;
        }

        @Override
        public int getFieldSize() {
            return this.q.bitLength();
        }

        @Override
        public ECFieldElement fromBigInteger(BigInteger bigInteger) {
            return new ECFieldElement.Fp(this.q, bigInteger);
        }

        @Override
        public ECPoint createPoint(BigInteger bigInteger, BigInteger bigInteger2, boolean bl) {
            return new ECPoint.Fp(this, this.fromBigInteger(bigInteger), this.fromBigInteger(bigInteger2), bl);
        }

        @Override
        public ECPoint decodePoint(byte[] byArray) {
            ECPoint eCPoint = null;
            switch (byArray[0]) {
                case 0: {
                    if (byArray.length > 1) {
                        throw new RuntimeException("Invalid point encoding");
                    }
                    eCPoint = this.getInfinity();
                    break;
                }
                case 2: 
                case 3: {
                    int n;
                    int n2 = byArray[0] & 1;
                    byte[] byArray2 = new byte[byArray.length - 1];
                    System.arraycopy(byArray, 1, byArray2, 0, byArray2.length);
                    ECFieldElement.Fp fp = new ECFieldElement.Fp(this.q, new BigInteger(1, byArray2));
                    ECFieldElement eCFieldElement = ((ECFieldElement)fp).multiply(((ECFieldElement)fp).square().add(this.a)).add(this.b);
                    ECFieldElement eCFieldElement2 = eCFieldElement.sqrt();
                    if (eCFieldElement2 == null) {
                        throw new RuntimeException("Invalid point compression");
                    }
                    int n3 = n = eCFieldElement2.toBigInteger().testBit(0) ? 1 : 0;
                    if (n == n2) {
                        eCPoint = new ECPoint.Fp(this, fp, eCFieldElement2, true);
                        break;
                    }
                    eCPoint = new ECPoint.Fp(this, fp, new ECFieldElement.Fp(this.q, this.q.subtract(eCFieldElement2.toBigInteger())), true);
                    break;
                }
                case 4: 
                case 6: 
                case 7: {
                    byte[] byArray3 = new byte[(byArray.length - 1) / 2];
                    byte[] byArray4 = new byte[(byArray.length - 1) / 2];
                    System.arraycopy(byArray, 1, byArray3, 0, byArray3.length);
                    System.arraycopy(byArray, byArray3.length + 1, byArray4, 0, byArray4.length);
                    eCPoint = new ECPoint.Fp(this, new ECFieldElement.Fp(this.q, new BigInteger(1, byArray3)), new ECFieldElement.Fp(this.q, new BigInteger(1, byArray4)));
                    break;
                }
                default: {
                    throw new RuntimeException("Invalid point encoding 0x" + Integer.toString(byArray[0], 16));
                }
            }
            return eCPoint;
        }

        @Override
        public ECPoint getInfinity() {
            return this.infinity;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof Fp)) {
                return false;
            }
            Fp fp = (Fp)object;
            return this.q.equals(fp.q) && this.a.equals(fp.a) && this.b.equals(fp.b);
        }

        public int hashCode() {
            return this.a.hashCode() ^ this.b.hashCode() ^ this.q.hashCode();
        }
    }

    public static abstract class AbstractFp
    extends ECCurve {
        protected AbstractFp(BigInteger bigInteger) {
            super(FiniteFields.getPrimeField(bigInteger));
        }

        public boolean isValidFieldElement(BigInteger bigInteger) {
            return bigInteger != null && bigInteger.signum() >= 0 && bigInteger.compareTo(this.getField().getCharacteristic()) < 0;
        }

        public ECFieldElement randomFieldElement(SecureRandom secureRandom) {
            BigInteger bigInteger = this.getField().getCharacteristic();
            ECFieldElement eCFieldElement = this.fromBigInteger(AbstractFp.implRandomFieldElement(secureRandom, bigInteger));
            ECFieldElement eCFieldElement2 = this.fromBigInteger(AbstractFp.implRandomFieldElement(secureRandom, bigInteger));
            return eCFieldElement.multiply(eCFieldElement2);
        }

        public ECFieldElement randomFieldElementMult(SecureRandom secureRandom) {
            BigInteger bigInteger = this.getField().getCharacteristic();
            ECFieldElement eCFieldElement = this.fromBigInteger(AbstractFp.implRandomFieldElementMult(secureRandom, bigInteger));
            ECFieldElement eCFieldElement2 = this.fromBigInteger(AbstractFp.implRandomFieldElementMult(secureRandom, bigInteger));
            return eCFieldElement.multiply(eCFieldElement2);
        }

        protected ECPoint decompressPoint(int n, BigInteger bigInteger) {
            ECFieldElement eCFieldElement = this.fromBigInteger(bigInteger);
            ECFieldElement eCFieldElement2 = eCFieldElement.square().add(this.a).multiply(eCFieldElement).add(this.b);
            ECFieldElement eCFieldElement3 = eCFieldElement2.sqrt();
            if (eCFieldElement3 == null) {
                throw new IllegalArgumentException("Invalid point compression");
            }
            if (eCFieldElement3.testBitZero() != (n == 1)) {
                eCFieldElement3 = eCFieldElement3.negate();
            }
            return this.createRawPoint(eCFieldElement, eCFieldElement3);
        }

        private static BigInteger implRandomFieldElement(SecureRandom secureRandom, BigInteger bigInteger) {
            BigInteger bigInteger2;
            while ((bigInteger2 = BigIntegers.createRandomBigInteger((int)bigInteger.bitLength(), (SecureRandom)secureRandom)).compareTo(bigInteger) >= 0) {
            }
            return bigInteger2;
        }

        private static BigInteger implRandomFieldElementMult(SecureRandom secureRandom, BigInteger bigInteger) {
            BigInteger bigInteger2;
            while ((bigInteger2 = BigIntegers.createRandomBigInteger((int)bigInteger.bitLength(), (SecureRandom)secureRandom)).signum() <= 0 || bigInteger2.compareTo(bigInteger) >= 0) {
            }
            return bigInteger2;
        }
    }

    public class Config {
        protected int coord;
        protected ECEndomorphism endomorphism;
        protected ECMultiplier multiplier;

        Config(int n, ECEndomorphism eCEndomorphism, ECMultiplier eCMultiplier) {
            this.coord = n;
            this.endomorphism = eCEndomorphism;
            this.multiplier = eCMultiplier;
        }

        public Config setCoordinateSystem(int n) {
            this.coord = n;
            return this;
        }

        public Config setEndomorphism(ECEndomorphism eCEndomorphism) {
            this.endomorphism = eCEndomorphism;
            return this;
        }

        public Config setMultiplier(ECMultiplier eCMultiplier) {
            this.multiplier = eCMultiplier;
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ECCurve create() {
            if (!ECCurve.this.supportsCoordinateSystem(this.coord)) {
                throw new IllegalStateException("unsupported coordinate system");
            }
            ECCurve eCCurve = ECCurve.this.cloneCurve();
            if (eCCurve == ECCurve.this) {
                throw new IllegalStateException("implementation returned current curve");
            }
            ECCurve eCCurve2 = eCCurve;
            synchronized (eCCurve2) {
                eCCurve.coord = this.coord;
                eCCurve.endomorphism = this.endomorphism;
                eCCurve.multiplier = this.multiplier;
            }
            return eCCurve;
        }
    }
}

