/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.IOException;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1OutputStream;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1String;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.StreamUtil;
import org.bouncycastle.util.Arrays;

public class DERBMPString
extends ASN1Primitive
implements ASN1String {
    private final char[] string;

    public static DERBMPString getInstance(Object object) {
        if (object == null || object instanceof DERBMPString) {
            return (DERBMPString)object;
        }
        if (object instanceof byte[]) {
            try {
                return (DERBMPString)DERBMPString.fromByteArray((byte[])object);
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("encoding error in getInstance: " + exception.toString());
            }
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + object.getClass().getName());
    }

    public static DERBMPString getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        DERObject dERObject = aSN1TaggedObject.getObject();
        if (bl || dERObject instanceof DERBMPString) {
            return DERBMPString.getInstance(dERObject);
        }
        return new DERBMPString(ASN1OctetString.getInstance(dERObject).getOctets());
    }

    DERBMPString(byte[] byArray) {
        if (byArray == null) {
            throw new NullPointerException("'string' cannot be null");
        }
        int n = byArray.length;
        if (0 != (n & 1)) {
            throw new IllegalArgumentException("malformed BMPString encoding encountered");
        }
        int n2 = n / 2;
        char[] cArray = new char[n2];
        for (int i = 0; i != n2; ++i) {
            cArray[i] = (char)(byArray[2 * i] << 8 | byArray[2 * i + 1] & 0xFF);
        }
        this.string = cArray;
    }

    DERBMPString(char[] cArray) {
        if (cArray == null) {
            throw new NullPointerException("'string' cannot be null");
        }
        this.string = cArray;
    }

    public DERBMPString(String string) {
        if (string == null) {
            throw new NullPointerException("'string' cannot be null");
        }
        this.string = string.toCharArray();
    }

    @Override
    public String getString() {
        return new String((char[])this.string);
    }

    public String toString() {
        return this.getString();
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode((char[])this.string);
    }

    @Override
    protected boolean asn1Equals(ASN1Primitive aSN1Primitive) {
        if (!(aSN1Primitive instanceof DERBMPString)) {
            return false;
        }
        DERBMPString dERBMPString = (DERBMPString)((Object)aSN1Primitive);
        return Arrays.areEqual((char[])this.string, (char[])dERBMPString.string);
    }

    @Override
    boolean isConstructed() {
        return false;
    }

    @Override
    int encodedLength() {
        return 1 + StreamUtil.calculateBodyLength(((String)this.string).length * 2) + ((String)this.string).length * 2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    void encode(ASN1OutputStream aSN1OutputStream, boolean bl) throws IOException {
        String string;
        int n;
        int n2 = ((String)this.string).length;
        if (bl) {
            aSN1OutputStream.write(30);
        }
        aSN1OutputStream.writeLength(n2 * 2);
        byte[] byArray = new byte[8];
        int n3 = n2 & 0xFFFFFFFC;
        for (n = 0; n < n3; n += 4) {
            String string2 = this.string[n];
            string = this.string[n + 1];
            String string3 = this.string[n + 2];
            String string4 = this.string[n + 3];
            byArray[0] = (byte)(string2 >> 8);
            byArray[1] = (byte)string2;
            byArray[2] = (byte)(string >> 8);
            byArray[3] = (byte)string;
            byArray[4] = (byte)(string3 >> 8);
            byArray[5] = (byte)string3;
            byArray[6] = (byte)(string4 >> 8);
            byArray[7] = (byte)string4;
            aSN1OutputStream.write(byArray, 0, 8);
        }
        if (n < n2) {
            void var7_9;
            boolean bl2 = false;
            do {
                string = this.string[n];
                byArray[var7_9++] = (byte)(string >> 8);
                byArray[var7_9++] = (byte)string;
            } while (++n < n2);
            aSN1OutputStream.write(byArray, 0, (int)var7_9);
        }
    }
}

