/*
 * Decompiled with CFR 0.152.
 */
package org.jnetpcap.packet;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.PrintStream;
import junit.framework.TestCase;
import org.jnetpcap.packet.PcapPacket;
import org.jnetpcap.packet.TestUtils;
import org.jnetpcap.packet.format.TextFormatter;

public class TestNoSystemOutOutput
extends TestCase {
    private static final File DIR = new File("tests");
    private PrintStream savedOut;
    private PrintStream savedErr;
    private ByteArrayOutputStream out;
    private TextFormatter DISGARD_OUTPUT = new TextFormatter(TestUtils.DEV_NULL);

    protected void setUp() throws Exception {
        this.savedOut = System.out;
        this.savedErr = System.err;
        this.out = new ByteArrayOutputStream();
        System.setOut(new PrintStream(this.out));
        System.setErr(new PrintStream(this.out));
    }

    private void reset() {
        this.out = new ByteArrayOutputStream();
        System.setOut(new PrintStream(this.out));
        System.setErr(new PrintStream(this.out));
    }

    protected void tearDown() throws Exception {
        System.setOut(this.savedOut);
        System.setErr(this.savedErr);
    }

    public void testSystemOutRedirectionIsWorking() {
        TestNoSystemOutOutput.assertTrue((String)"redirection failed", (this.out.size() == 0 ? 1 : 0) != 0);
        System.err.println("hello");
        TestNoSystemOutOutput.assertFalse((String)"redirection failed", (this.out.size() == 0 ? 1 : 0) != 0);
        this.reset();
    }

    public void testNoOutputFromCoreProtocols() throws IOException {
        String[] stringArray;
        for (String string : stringArray = DIR.list(new FilenameFilter(){

            @Override
            public boolean accept(File file, String string) {
                return string.endsWith(".pcap");
            }
        })) {
            for (PcapPacket pcapPacket : TestUtils.getIterable(DIR + "/" + string)) {
                this.DISGARD_OUTPUT.format(pcapPacket);
                TestNoSystemOutOutput.assertTrue((String)("unexpected System.out output found " + string + ": packet=" + pcapPacket.toString() + "\noutput found=" + this.out.toString()), (this.out.size() == 0 ? 1 : 0) != 0);
            }
        }
    }
}

