/*
 * Decompiled with CFR 0.152.
 */
package org.jnetpcap;

import java.util.ArrayList;
import org.jnetpcap.JBufferHandler;
import org.jnetpcap.Pcap;
import org.jnetpcap.PcapHeader;
import org.jnetpcap.PcapIf;
import org.jnetpcap.PcapStat;
import org.jnetpcap.nio.JBuffer;
import org.jnetpcap.packet.TestUtils;

public class TestLivePerformance
extends TestUtils {
    long ts = 0L;
    long te = 0L;
    long pkt = 0L;
    long bytes = 0L;
    long drops = 0L;
    long totPkt = 0L;
    long totBytes = 0L;
    long totTs = 0L;
    long totTe = 0L;

    public void startStats() {
        if (this.ts == 0L) {
            this.totTs = System.currentTimeMillis();
        }
        this.te = this.ts = System.currentTimeMillis();
        this.pkt = 0L;
        this.bytes = 0L;
    }

    public void endStats() {
        this.totTe = this.te = System.currentTimeMillis();
        this.totPkt += this.pkt;
        this.totBytes += this.bytes;
    }

    public void printStats(Pcap pcap) {
        PcapStat pcapStat = new PcapStat();
        pcap.stats(pcapStat);
        double d = (double)this.pkt / ((double)(this.te - this.ts) / 1000.0);
        double d2 = (double)(this.bytes * 8L) / ((double)(this.te - this.ts) / 1000.0);
        System.out.printf("recv=%d, drop=%d, ifDrop=%d pps=%.2f bps=%.2fKb ave=%d bytes\n", pcapStat.getRecv(), pcapStat.getDrop(), pcapStat.getIfDrop(), d, d2 / 1024.0, this.bytes / this.pkt);
    }

    public void printSummary(Pcap pcap) {
        PcapStat pcapStat = new PcapStat();
        pcap.stats(pcapStat);
        double d = (double)this.totPkt / ((double)(this.totTe - this.totTs) / 1000.0);
        double d2 = (double)(this.totBytes * 8L) / ((double)(this.totTe - this.totTs) / 1000.0);
        System.out.printf("TOTAL: recv=%d, drop=%d, ifDrop=%d pps=%.2f bps=%.2fKb ave=%d bytes\n", pcapStat.getRecv(), pcapStat.getDrop(), pcapStat.getIfDrop(), d, d2 / 1024.0, this.bytes / this.pkt);
    }

    public boolean hasDrops(Pcap pcap) {
        PcapStat pcapStat = new PcapStat();
        pcap.stats(pcapStat);
        if (pcapStat.getDrop() != this.drops) {
            this.drops = pcapStat.getDrop();
            return true;
        }
        return false;
    }

    public void testCapture10() {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 65536;
        int n3 = 1;
        int n4 = 0;
        ArrayList<PcapIf> arrayList = new ArrayList<PcapIf>();
        if (Pcap.findAllDevs(arrayList, stringBuilder) != 0) {
            TestLivePerformance.fail((String)stringBuilder.toString());
        }
        final boolean bl = System.getProperty("verbose") != null ? Boolean.parseBoolean(System.getProperty("verbose")) : false;
        boolean bl2 = System.getProperty("dispatch") != null ? Boolean.parseBoolean(System.getProperty("dispatch")) : false;
        int n5 = 0;
        for (PcapIf object2 : arrayList) {
            if (object2.getDescription() == null) {
                if (bl) {
                    System.out.printf("#%d: %s\n", n5, object2.getName());
                }
            } else if (bl) {
                System.out.printf("#%d: %s - %s\n", n5, object2.getName(), object2.getDescription());
            }
            ++n5;
        }
        int n6 = 0;
        TestLivePerformance.assertTrue((String)("device count less then index " + n6), (arrayList.size() > n6 ? 1 : 0) != 0);
        PcapIf pcapIf = (PcapIf)arrayList.get(n6);
        if (bl) {
            System.out.println();
            System.out.printf("Opening %s interface\n", pcapIf.getDescription() != null ? pcapIf.getDescription() : pcapIf.getName());
        }
        Pcap pcap = Pcap.openLive(pcapIf.getName(), n2, n3, n4, stringBuilder);
        TestLivePerformance.assertNotNull((String)stringBuilder.toString(), (Object)pcap);
        final int n7 = System.getProperty("max") != null ? Integer.parseInt(System.getProperty("max")) : 1000;
        JBufferHandler<Pcap> jBufferHandler = new JBufferHandler<Pcap>(){
            int cnt = 0;
            int next = 0;

            @Override
            public void nextPacket(PcapHeader pcapHeader, JBuffer jBuffer, Pcap pcap) {
                if (this.cnt == this.next) {
                    if (bl) {
                        System.out.printf(TestLivePerformance.this.hasDrops(pcap) ? "X" : ".", new Object[0]);
                        System.out.flush();
                    }
                    this.next += n7 / 10;
                }
                ++this.cnt;
                ++TestLivePerformance.this.pkt;
                TestLivePerformance.this.bytes += (long)jBuffer.size();
            }
        };
        int n8 = n = System.getProperty("loops") != null ? Integer.parseInt(System.getProperty("loops")) : 10;
        if (!bl2) {
            for (int i = 0; i < n; ++i) {
                if (bl) {
                    System.out.printf("#%06d: ", i * n7);
                }
                this.startStats();
                if (pcap.loop(n7, jBufferHandler, pcap) != 0) {
                    TestLivePerformance.fail((String)pcap.getErr());
                }
                this.endStats();
                if (!bl) continue;
                System.out.printf("\n#%06d: ", i * n7);
                this.printStats(pcap);
            }
        } else {
            for (int i = 0; i < n; ++i) {
                int n9;
                if (bl) {
                    System.out.printf("#%06d: ", i * n7);
                }
                this.startStats();
                int n10 = 0;
                int n11 = 0;
                while ((n9 = pcap.dispatch(n7, jBufferHandler, pcap)) >= 0 && n10 < n7) {
                    if (n9 < 0) {
                        TestLivePerformance.fail((String)pcap.getErr());
                    }
                    n10 += n9;
                    ++n11;
                }
                this.endStats();
                if (!bl) continue;
                double d = (double)n10 / (double)n11;
                System.out.printf("\n#%06d: calls=%d ppc=%.2f ", i * n7, n11, d);
                this.printStats(pcap);
            }
        }
        this.printSummary(pcap);
        pcap.close();
    }
}

