/*
 * Decompiled with CFR 0.152.
 */
package org.jnetpcap;

import java.io.IOException;
import org.jnetpcap.ByteBufferHandler;
import org.jnetpcap.JBufferHandler;
import org.jnetpcap.Pcap;
import org.jnetpcap.PcapHeader;
import org.jnetpcap.PcapIf;
import org.jnetpcap.PcapTask;
import org.jnetpcap.packet.JPacket;
import org.jnetpcap.packet.JScanner;
import org.jnetpcap.packet.PcapPacket;
import org.jnetpcap.packet.PcapPacketHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PcapUtils {
    public static <T> PcapTask<T> dispatchInBackground(Pcap pcap, int n, final ByteBufferHandler<T> byteBufferHandler, final T t) {
        return new PcapTask<T>(pcap, n, t){

            @Override
            public void run() {
                for (int i = this.count; i > 0; i -= this.result) {
                    if (i != 0) {
                        Thread.yield();
                    }
                    this.result = this.pcap.dispatch(this.count, byteBufferHandler, t);
                    if (this.result < 0) break;
                }
            }
        };
    }

    public static <T> PcapTask<T> dispatchInBackground(Pcap pcap, int n, final JBufferHandler<T> jBufferHandler, final T t) {
        return new PcapTask<T>(pcap, n, t){

            @Override
            public void run() {
                for (int i = this.count; i > 0; i -= this.result) {
                    if (i != 0) {
                        Thread.yield();
                    }
                    this.result = this.pcap.dispatch(this.count, jBufferHandler, t);
                    if (this.result < 0) break;
                }
            }
        };
    }

    public static byte[] getHardwareAddress(PcapIf pcapIf) throws IOException {
        return PcapUtils.getHardwareAddress(pcapIf.getName());
    }

    public static native byte[] getHardwareAddress(String var0) throws IOException;

    public static <T> PcapTask<T> loopInBackground(Pcap pcap, int n, final ByteBufferHandler<T> byteBufferHandler, final T t) {
        return new PcapTask<T>(pcap, n, t){

            @Override
            public void run() {
                this.result = this.pcap.loop(this.count, byteBufferHandler, t);
            }
        };
    }

    public static <T> PcapTask<T> loopInBackground(Pcap pcap, int n, final JBufferHandler<T> jBufferHandler, final T t) {
        return new PcapTask<T>(pcap, n, t){

            @Override
            public void run() {
                this.result = this.pcap.loop(this.count, jBufferHandler, t);
            }
        };
    }

    public static <T> int injectLoop(int n, int n2, PcapPacketHandler<T> pcapPacketHandler, T t, PcapPacket pcapPacket) {
        return PcapUtils.injectLoop(n, n2, pcapPacketHandler, t, pcapPacket, pcapPacket.getState(), pcapPacket.getCaptureHeader(), JScanner.getThreadLocal());
    }

    private static native <T> int injectLoop(int var0, int var1, PcapPacketHandler<T> var2, T var3, PcapPacket var4, JPacket.State var5, PcapHeader var6, JScanner var7);

    private PcapUtils() {
    }
}

