/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.key;

import de.gematik.rbellogger.converter.RbelConverter;
import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.RbelJsonElement;
import de.gematik.rbellogger.data.RbelJweElement;
import de.gematik.rbellogger.data.RbelMapElement;
import de.gematik.rbellogger.key.RbelKey;
import java.security.Key;
import java.util.Base64;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.stream.Stream;
import javax.crypto.spec.SecretKeySpec;

public class RbelKeyManager {
    public static final BiConsumer<RbelJweElement, RbelConverter> RBEL_IDP_TOKEN_KEY_LISTENER = (element, converter) -> Optional.ofNullable(element.getBody()).filter(RbelJsonElement.class::isInstance).map(RbelJsonElement.class::cast).map(json -> json.getJsonElement()).filter(RbelMapElement.class::isInstance).map(RbelMapElement.class::cast).map(map -> map.getChildElements()).filter(map -> map.containsKey("token_key")).map(map -> (RbelElement)map.get("token_key")).map(tokenB64 -> Base64.getUrlDecoder().decode(tokenB64.getContent())).map(tokenKeyBytes -> new SecretKeySpec((byte[])tokenKeyBytes, "AES")).ifPresent(aesKey -> converter.getRbelKeyManager().addKey("token_key", (Key)aesKey, RbelKey.PRECEDENCE_KEY_FOLDER));
    private final Map<String, RbelKey> keyIdToKeyDatabase = new HashMap<String, RbelKey>();

    public RbelKeyManager addAll(Map<String, RbelKey> keys) {
        this.keyIdToKeyDatabase.putAll(keys);
        return this;
    }

    public void addKey(String keyId, Key key, int precedence) {
        this.keyIdToKeyDatabase.put(keyId, RbelKey.builder().keyName(keyId).key(key).precedence(precedence).build());
    }

    public Stream<RbelKey> getAllKeys() {
        return this.keyIdToKeyDatabase.values().stream().sorted(Comparator.comparing(RbelKey::getPrecedence));
    }
}

