/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.data;

import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.RbelHttpMessage;
import de.gematik.rbellogger.data.RbelMapElement;

public class RbelHttpResponse
extends RbelHttpMessage {
    private int responseCode;

    public RbelHttpResponse(RbelMapElement header, RbelElement body, int responseCode) {
        super(header, body);
        this.responseCode = responseCode;
    }

    @Override
    public String getContent() {
        return ELEMENT_SEPARATOR + "HTTP RESPONSE " + this.responseCode + " + \n Headers:\n" + this.getHeader().getContent() + HEADER_SEPARATOR + this.getBody().getContent();
    }

    public static RbelHttpResponseBuilder builder() {
        return new RbelHttpResponseBuilder();
    }

    public int getResponseCode() {
        return this.responseCode;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RbelHttpResponse)) {
            return false;
        }
        RbelHttpResponse other = (RbelHttpResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return this.getResponseCode() == other.getResponseCode();
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof RbelHttpResponse;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getResponseCode();
        return result;
    }

    @Override
    public String toString() {
        return "RbelHttpResponse(responseCode=" + this.getResponseCode() + ")";
    }

    public static class RbelHttpResponseBuilder {
        private RbelMapElement header;
        private RbelElement body;
        private int responseCode;

        RbelHttpResponseBuilder() {
        }

        public RbelHttpResponseBuilder header(RbelMapElement header) {
            this.header = header;
            return this;
        }

        public RbelHttpResponseBuilder body(RbelElement body) {
            this.body = body;
            return this;
        }

        public RbelHttpResponseBuilder responseCode(int responseCode) {
            this.responseCode = responseCode;
            return this;
        }

        public RbelHttpResponse build() {
            return new RbelHttpResponse(this.header, this.body, this.responseCode);
        }

        public String toString() {
            return "RbelHttpResponse.RbelHttpResponseBuilder(header=" + this.header + ", body=" + this.body + ", responseCode=" + this.responseCode + ")";
        }
    }
}

