/*
 * Decompiled with CFR 0.152.
 */
package com.slytechs.library;

import com.slytechs.library.JNILibrary;
import com.slytechs.library.JNISymbol;
import com.slytechs.library.NativeLibrary;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.jnetpcap.Pcap;
import org.jnetpcap.PcapIf;
import org.jnetpcap.nio.JBuffer;
import org.jnetpcap.nio.JMemory;
import org.jnetpcap.packet.TestUtils;
import org.jnetpcap.winpcap.WinPcap;

public class TestLibrary
extends TestUtils {
    @Override
    protected void setUp() throws Exception {
        JNILibrary.register(Pcap.class);
        super.setUp();
    }

    public void testDlopen() {
        long l = NativeLibrary.dlopen("jnetpcap");
        TestLibrary.assertTrue((String)("address = 0x" + l), (l != 0L ? 1 : 0) != 0);
    }

    public void testDlsymbols() {
        JNILibrary jNILibrary = JNILibrary.loadLibrary("jnetpcap-pcap100");
        TestLibrary.assertNotNull((Object)jNILibrary);
        System.out.printf("testDlsymbols() - lib=%X/%s%n", jNILibrary.address, jNILibrary.name);
        jNILibrary.dlsymbol("Java_org_jnetpcap_Pcap_close");
        jNILibrary.dlsymbol("pcap_open_live");
        jNILibrary.dlsymbol("Java_org_jnetpcap_Pcap_create");
    }

    public void testPcapCanSetRfMon() {
        TestLibrary.assertTrue((boolean)Pcap.isLoaded("canSetRfmon", new Class[0]));
    }

    public void _testPcapCanSetRfMond() throws SecurityException, NoSuchMethodException {
        ArrayList<PcapIf> arrayList = new ArrayList<PcapIf>();
        StringBuilder stringBuilder = new StringBuilder();
        Pcap.findAllDevs(arrayList, stringBuilder);
        Pcap pcap = Pcap.create(((PcapIf)arrayList.get(0)).getName(), stringBuilder);
        if (Pcap.isLoaded("canSetRfmon", new Class[0])) {
            pcap.canSetRfmon();
        }
        pcap.close();
    }

    public void testPcapGet080Library() {
        JNILibrary.register(Pcap.class);
        System.out.println(JNILibrary.toStringAllLibraries());
        TestLibrary.assertTrue((boolean)Pcap.isPcap080Loaded());
        JNILibrary jNILibrary = JNILibrary.loadLibrary("jnetpcap");
        TestLibrary.assertNotNull((Object)jNILibrary);
        TestLibrary.assertTrue((boolean)jNILibrary.isLoaded());
        System.out.println(jNILibrary);
    }

    public void testPcapGet100Library() {
        JNILibrary jNILibrary = JNILibrary.loadLibrary("jnetpcap-pcap100");
        TestLibrary.assertNotNull((Object)jNILibrary);
        TestLibrary.assertTrue((String)jNILibrary.errors.toString(), (boolean)jNILibrary.isLoaded());
        System.out.println(jNILibrary);
    }

    public void testPcapGetSymbols() throws SecurityException, NoSuchMethodException {
        JNILibrary.register(Pcap.class);
        TestLibrary.assertTrue((boolean)Pcap.isPcap080Loaded());
        JNILibrary.loadLibrary("jnetpcap");
        Method method = Pcap.class.getMethod("create", String.class, StringBuilder.class);
        JNISymbol jNISymbol = JNILibrary.findSymbol(method);
        TestLibrary.assertNotNull((String)JNISymbol.toJNIName(method), (Object)jNISymbol);
        System.out.println(jNISymbol.toString());
    }

    public void testPcapRegister() {
        TestLibrary.assertTrue((String)String.valueOf(Pcap.getPcap080LoadError()), (boolean)Pcap.isPcap080Loaded());
        JNILibrary jNILibrary = JNILibrary.loadLibrary("jnetpcap");
        System.out.println(jNILibrary);
    }

    public void testWinPcap() {
        JNILibrary.register(WinPcap.class);
        JNILibrary.register(JBuffer.class);
        JNILibrary.register(NativeLibrary.class);
        JNILibrary.loadLibrary("jnetpcap");
        System.out.println(JNILibrary.toStringClassSymbols(NativeLibrary.class, JMemory.class));
    }
}

