/*
 * Decompiled with CFR 0.152.
 */
package org.jnetpcap.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import org.jnetpcap.util.config.JConfig;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JLogger
extends Logger {
    public static final String PROPERTIES_CONFIG = "resources/builtin-logger.properties";
    private static boolean triggerConfigInit = true;

    public JLogger(String string, String string2) {
        super(string, string2);
    }

    public static Logger getLogger(Class<?> clazz) {
        if (triggerConfigInit && clazz != JConfig.class) {
            triggerConfigInit = false;
            JConfig.init();
        }
        return JLogger.getLogger(clazz.getName());
    }

    public static Logger getLogger(Package package_) {
        if (triggerConfigInit) {
            triggerConfigInit = false;
            JConfig.init();
        }
        return JLogger.getLogger(package_.getName());
    }

    public static LogManager readConfiguration(Properties properties) throws SecurityException, IOException {
        LogManager logManager = LogManager.getLogManager();
        return logManager;
    }

    @Override
    public void setLevel(Level level) throws SecurityException {
        super.setLevel(level);
        if (triggerConfigInit) {
            triggerConfigInit = false;
            JConfig.init();
        }
    }

    static {
        try {
            InputStream inputStream = JLogger.class.getClassLoader().getResourceAsStream(PROPERTIES_CONFIG);
            if (inputStream == null) {
                Logger.getLogger("").severe("JLogger.static<>: Unable to find builtin-logger.properties. Is resources directory missing in JAR File?");
            } else {
                inputStream.close();
            }
        }
        catch (Exception exception) {
            Logger.getLogger("").log(Level.SEVERE, "Unable to find jNetPcap logger.properties", exception);
        }
    }
}

