/*
 * Decompiled with CFR 0.152.
 */
package org.jnetpcap.packet.structure;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jnetpcap.packet.JBinding;
import org.jnetpcap.packet.JHeader;
import org.jnetpcap.packet.JPacket;
import org.jnetpcap.packet.JRegistry;
import org.jnetpcap.packet.annotate.Bind;
import org.jnetpcap.packet.structure.AnnotatedBindMethod;
import org.jnetpcap.packet.structure.AnnotatedMethodException;
import org.jnetpcap.packet.structure.HeaderDefinitionError;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotatedBinding
implements JBinding {
    private static final Map<Class<?>, JBinding[]> cache = new HashMap();
    private final AnnotatedBindMethod annotatedBound;
    private final Class<?> definitionClass;
    protected final int[] dependencies;
    private final ThreadLocal<JHeader> headerPool;
    private final int sourceId;
    private final Class<? extends JHeader> targetClass;
    private final int targetId;

    public static void clearCache() {
        cache.clear();
    }

    private static JHeader createHeaderFromClass(Class<? extends JHeader> clazz) {
        try {
            JHeader jHeader = clazz.newInstance();
            return jHeader;
        }
        catch (InstantiationException instantiationException) {
            throw new HeaderDefinitionError(clazz, "problem in the default constructor", instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new HeaderDefinitionError(clazz, "problem in the default constructor", illegalAccessException);
        }
    }

    public static synchronized JBinding[] inspectClass(Class<?> clazz, List<HeaderDefinitionError> list) {
        if (cache.containsKey(clazz)) {
            return cache.get(clazz);
        }
        AnnotatedBindMethod[] annotatedBindMethodArray = AnnotatedBindMethod.inspectClass(clazz, list);
        return AnnotatedBinding.createBindings(clazz, annotatedBindMethodArray, list);
    }

    private static JBinding[] createBindings(Class<?> clazz, AnnotatedBindMethod[] annotatedBindMethodArray, List<HeaderDefinitionError> list) {
        ArrayList<AnnotatedBinding> arrayList = new ArrayList<AnnotatedBinding>();
        Class<? extends JHeader> clazz2 = null;
        for (AnnotatedBindMethod annotatedBindMethod : annotatedBindMethodArray) {
            try {
                Bind bind = annotatedBindMethod.getMethod().getAnnotation(Bind.class);
                clazz2 = bind.to();
                Class<? extends JHeader> clazz3 = bind.from();
                Class<? extends JHeader>[] classArray = bind.dependencies();
                arrayList.add(new AnnotatedBinding(clazz, clazz3, clazz2, annotatedBindMethod, classArray));
            }
            catch (AnnotatedMethodException annotatedMethodException) {
                list.add(annotatedMethodException);
            }
        }
        Object[] objectArray = arrayList.toArray(new JBinding[arrayList.size()]);
        cache.put(clazz, (JBinding[])objectArray);
        return objectArray;
    }

    public static <T extends JHeader> JBinding[] inspectJHeaderClass(Class<T> clazz, List<HeaderDefinitionError> list) {
        if (cache.containsKey(clazz)) {
            return cache.get(clazz);
        }
        AnnotatedBindMethod[] annotatedBindMethodArray = AnnotatedBindMethod.inspectJHeaderClass(clazz, list);
        Class<T> clazz2 = clazz;
        ArrayList<AnnotatedBinding> arrayList = new ArrayList<AnnotatedBinding>();
        Class<? extends JHeader> clazz3 = null;
        for (AnnotatedBindMethod annotatedBindMethod : annotatedBindMethodArray) {
            try {
                Bind bind = annotatedBindMethod.getMethod().getAnnotation(Bind.class);
                clazz3 = bind.to();
                Class<? extends JHeader>[] classArray = bind.dependencies();
                arrayList.add(new AnnotatedBinding(clazz, clazz2, clazz3, annotatedBindMethod, classArray));
            }
            catch (AnnotatedMethodException annotatedMethodException) {
                list.add(annotatedMethodException);
            }
        }
        Object[] objectArray = arrayList.toArray(new JBinding[arrayList.size()]);
        cache.put(clazz, (JBinding[])objectArray);
        return objectArray;
    }

    private AnnotatedBinding(Class<?> clazz, Class<? extends JHeader> clazz2, Class<? extends JHeader> clazz3, AnnotatedBindMethod annotatedBindMethod, Class<? extends JHeader> ... classArray) {
        this.definitionClass = clazz;
        this.targetClass = clazz3;
        this.annotatedBound = annotatedBindMethod;
        this.dependencies = new int[classArray.length];
        this.sourceId = JRegistry.lookupId(clazz2);
        this.targetId = JRegistry.lookupId(clazz3);
        int n = 0;
        for (Class<? extends JHeader> clazz4 : classArray) {
            this.dependencies[n++] = JRegistry.lookupId(clazz4);
        }
        this.headerPool = new ThreadLocal<JHeader>(){

            @Override
            protected JHeader initialValue() {
                return AnnotatedBinding.createHeaderFromClass(AnnotatedBinding.this.targetClass);
            }
        };
    }

    @Override
    public int getSourceId() {
        return this.sourceId;
    }

    public Class<? extends JHeader> getTargetClass() {
        return this.targetClass;
    }

    @Override
    public int getTargetId() {
        return this.targetId;
    }

    @Override
    public boolean isBound(JPacket jPacket, int n) {
        JHeader jHeader = this.headerPool.get();
        int n2 = jPacket.getState().getInstanceCount(jHeader.getId());
        if (n2 == 1) {
            jPacket.getHeader(jHeader);
        } else {
            for (int i = 0; i < n2; ++i) {
                jPacket.getHeader(jHeader, i);
                if (jHeader.getPayloadOffset() == n) break;
            }
        }
        return !jHeader.isHeaderTruncated() && this.annotatedBound.isBound(jPacket, n, jHeader);
    }

    @Override
    public int[] listDependencies() {
        return this.dependencies;
    }

    public String toString() {
        String string = this.definitionClass.getSimpleName();
        String string2 = this.annotatedBound.getMethod().getName();
        String string3 = this.targetClass.getSimpleName();
        return string + "." + string2 + "(JPacket packet, " + string3 + " header):" + "boolean";
    }

    public static JBinding[] inspectClass(Object object, List<HeaderDefinitionError> list) {
        return AnnotatedBinding.inspectClass(object.getClass(), list);
    }

    public static JBinding[] inspectObject(Object object, List<HeaderDefinitionError> list) {
        Class<?> clazz = object.getClass();
        if (cache.containsKey(clazz)) {
            return cache.get(clazz);
        }
        AnnotatedBindMethod[] annotatedBindMethodArray = AnnotatedBindMethod.inspectObject(object, list);
        return AnnotatedBinding.createBindings(clazz, annotatedBindMethodArray, list);
    }
}

