/*
 * Decompiled with CFR 0.152.
 */
package org.jnetpcap.packet;

import org.jnetpcap.nio.JBuffer;
import org.jnetpcap.nio.JMemory;
import org.jnetpcap.packet.PcapPacket;
import org.jnetpcap.packet.TestUtils;
import org.jnetpcap.protocol.network.Ip4;

public class TestJHeader
extends TestUtils {
    public void testJPayloadAccessorGetPayload() {
        PcapPacket pcapPacket = TestUtils.getPcapPacket("tests/test-http-jpeg.pcap", 5);
        Ip4 ip4 = pcapPacket.getHeader(new Ip4());
        TestJHeader.assertNotNull((Object)ip4);
        byte[] byArray = ip4.getPayload();
        TestJHeader.assertEquals((int)0, (int)byArray[0]);
        TestJHeader.assertEquals((int)80, (int)byArray[1]);
        TestJHeader.assertEquals((int)13, (int)byArray[453]);
        TestJHeader.assertEquals((int)10, (int)byArray[454]);
        TestJHeader.assertEquals((int)455, (int)byArray.length);
    }

    public void testJPayloadAccessorTransferPayloadToByteArray() {
        PcapPacket pcapPacket = TestUtils.getPcapPacket("tests/test-http-jpeg.pcap", 5);
        Ip4 ip4 = pcapPacket.getHeader(new Ip4());
        TestJHeader.assertNotNull((Object)ip4);
        byte[] byArray = ip4.transferPayloadTo(new byte[455]);
        TestJHeader.assertEquals((int)0, (int)byArray[0]);
        TestJHeader.assertEquals((int)80, (int)byArray[1]);
        TestJHeader.assertEquals((int)13, (int)byArray[453]);
        TestJHeader.assertEquals((int)10, (int)byArray[454]);
        TestJHeader.assertEquals((int)455, (int)byArray.length);
    }

    public void testJPayloadAccessorPeerPayloadToJBuffer() {
        PcapPacket pcapPacket = TestUtils.getPcapPacket("tests/test-http-jpeg.pcap", 5);
        Ip4 ip4 = pcapPacket.getHeader(new Ip4());
        TestJHeader.assertNotNull((Object)ip4);
        JBuffer jBuffer = ip4.peerPayloadTo(new JBuffer(JMemory.Type.POINTER));
        TestJHeader.assertEquals((int)0, (int)jBuffer.getUByte(0));
        TestJHeader.assertEquals((int)80, (int)jBuffer.getUByte(1));
        TestJHeader.assertEquals((int)13, (int)jBuffer.getUByte(453));
        TestJHeader.assertEquals((int)10, (int)jBuffer.getUByte(454));
        TestJHeader.assertEquals((int)455, (int)jBuffer.size());
    }

    public void testJPayloadAccessorTransferPayloadToJBuffer() {
        PcapPacket pcapPacket = TestUtils.getPcapPacket("tests/test-http-jpeg.pcap", 5);
        Ip4 ip4 = pcapPacket.getHeader(new Ip4());
        TestJHeader.assertNotNull((Object)ip4);
        JBuffer jBuffer = ip4.transferPayloadTo(new JBuffer(455));
        TestJHeader.assertEquals((int)0, (int)jBuffer.getUByte(0));
        TestJHeader.assertEquals((int)80, (int)jBuffer.getUByte(1));
        TestJHeader.assertEquals((int)13, (int)jBuffer.getUByte(453));
        TestJHeader.assertEquals((int)10, (int)jBuffer.getUByte(454));
        TestJHeader.assertEquals((int)455, (int)jBuffer.size());
    }
}

