/*
 * Decompiled with CFR 0.152.
 */
package org.jnetpcap.packet;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.jnetpcap.nio.JBuffer;
import org.jnetpcap.nio.JMemory;
import org.jnetpcap.nio.JStruct;
import org.jnetpcap.packet.JPacket;
import org.jnetpcap.packet.JPayloadAccessor;
import org.jnetpcap.packet.JRegistry;
import org.jnetpcap.packet.format.JFormatter;
import org.jnetpcap.packet.structure.AnnotatedHeader;
import org.jnetpcap.packet.structure.AnnotatedJField;
import org.jnetpcap.packet.structure.JField;
import org.jnetpcap.protocol.JProtocol;

public abstract class JHeader
extends JBuffer
implements JPayloadAccessor {
    public static final int BYTE = 8;
    private static final JField[] DEFAULT_FIELDS = new JField[0];
    protected static final JHeader[] EMPTY_HEADER_ARRAY = new JHeader[0];
    protected AnnotatedHeader annotatedHeader;
    private JField[] fields;
    private int id;
    protected boolean isSubHeader = false;
    private String name;
    private String nicname;
    protected JPacket packet;
    protected final State state;
    private int index = -1;

    public static native int sizeof();

    public JHeader() {
        super(JMemory.Type.POINTER);
        AnnotatedHeader annotatedHeader;
        this.order(ByteOrder.BIG_ENDIAN);
        this.state = new State(JMemory.Type.POINTER);
        JProtocol jProtocol = JProtocol.valueOf(this.getClass());
        if (jProtocol != null) {
            this.id = jProtocol.getId();
            annotatedHeader = JRegistry.lookupAnnotatedHeader(jProtocol);
        } else {
            this.id = JRegistry.lookupId(this.getClass());
            annotatedHeader = JRegistry.lookupAnnotatedHeader(this.getClass());
        }
        this.initFromAnnotatedHeader(annotatedHeader);
    }

    public JHeader(int n, JField[] jFieldArray, String string) {
        this(n, jFieldArray, string, string);
    }

    public JHeader(int n, JField[] jFieldArray, String string, String string2) {
        super(JMemory.Type.POINTER);
        this.fields = jFieldArray;
        this.id = n;
        this.name = string;
        this.nicname = string2;
        this.state = new State(JMemory.Type.POINTER);
        super.order(ByteOrder.nativeOrder());
    }

    public JHeader(int n, String string) {
        this(n, string, string);
    }

    public JHeader(int n, String string, String string2) {
        this(n, DEFAULT_FIELDS, string, string2);
    }

    public JHeader(JProtocol jProtocol) {
        super(JMemory.Type.POINTER);
        this.order(ByteOrder.BIG_ENDIAN);
        this.state = new State(JMemory.Type.POINTER);
        this.id = jProtocol.getId();
        AnnotatedHeader annotatedHeader = JRegistry.lookupAnnotatedHeader(jProtocol);
        this.initFromAnnotatedHeader(annotatedHeader);
    }

    public JHeader(State state, JField[] jFieldArray, String string, String string2) {
        super(JMemory.Type.POINTER);
        this.state = state;
        this.fields = jFieldArray;
        this.name = string;
        this.nicname = string2;
        this.id = state.getId();
        super.order(ByteOrder.nativeOrder());
    }

    public final void decode() {
        this.decodeHeader();
        this.validateHeader();
    }

    protected void decodeHeader() {
    }

    public AnnotatedHeader getAnnotatedHeader() {
        return this.annotatedHeader;
    }

    public String getDescription() {
        return this.annotatedHeader.getDescription();
    }

    public JField[] getFields() {
        JField.sortFieldByOffset(this.fields, this, true);
        return this.fields;
    }

    public byte[] getGap() {
        return this.packet.getByteArray(this.getGapOffset(), this.getGapLength());
    }

    public int getGapLength() {
        return this.state.getGap();
    }

    public int getGapOffset() {
        return this.getOffset() + this.getHeaderLength();
    }

    public byte[] getHeader() {
        return this.packet.getByteArray(this.getHeaderOffset(), this.getHeaderLength());
    }

    public int getHeaderLength() {
        return this.state.getLength();
    }

    public int getHeaderOffset() {
        return this.state.getOffset();
    }

    public final int getId() {
        return this.id;
    }

    public int getLength() {
        return this.state.getLength();
    }

    public final String getName() {
        return this.name;
    }

    public final String getNicname() {
        return this.nicname;
    }

    public int getOffset() {
        return this.state.getOffset();
    }

    public final JPacket getPacket() {
        return this.packet;
    }

    public JHeader getParent() {
        return this;
    }

    public byte[] getPayload() {
        return this.packet.getByteArray(this.getPayloadOffset(), this.getPayloadLength());
    }

    public int getPayloadLength() {
        return this.state.getPayload();
    }

    public int getPayloadOffset() {
        return this.getGapOffset() + this.getGapLength();
    }

    public byte[] getPostfix() {
        return this.packet.getByteArray(this.getPostfixOffset(), this.getPostfixLength());
    }

    public int getPostfixLength() {
        return this.state.getPostfix();
    }

    public int getPostfixOffset() {
        return this.getPayloadOffset() + this.getPayloadLength();
    }

    public byte[] getPrefix() {
        return this.packet.getByteArray(this.getPrefixOffset(), this.getPrefixLength());
    }

    public int getPrefixLength() {
        return this.state.getPrefix();
    }

    public int getPrefixOffset() {
        return this.getOffset() - this.getPrefixLength();
    }

    public State getState() {
        return this.state;
    }

    public JHeader[] getSubHeaders() {
        return EMPTY_HEADER_ARRAY;
    }

    public boolean hasDescription() {
        return this.annotatedHeader.getDescription() != null;
    }

    public boolean hasGap() {
        return this.getGapLength() != 0;
    }

    public boolean hasPayload() {
        return this.getPayloadLength() != 0;
    }

    public boolean hasPostfix() {
        return this.getPostfixLength() != 0;
    }

    public boolean hasPrefix() {
        return this.getPrefixLength() != 0;
    }

    public boolean hasSubHeaders() {
        return false;
    }

    private void initFromAnnotatedHeader(AnnotatedHeader annotatedHeader) {
        this.annotatedHeader = annotatedHeader;
        this.name = annotatedHeader.getName();
        this.nicname = annotatedHeader.getNicname();
        this.fields = AnnotatedJField.fromAnnotatedFields(annotatedHeader.getFields());
    }

    public boolean isGapTruncated() {
        return (this.state.getFlags() & 8) != 0;
    }

    public boolean isHeaderTruncated() {
        return (this.state.getFlags() & 2) != 0;
    }

    public boolean isPayloadTruncated() {
        return (this.state.getFlags() & 4) != 0;
    }

    public boolean isPostfixTruncated() {
        return (this.state.getFlags() & 0x10) != 0;
    }

    public boolean isPrefixTruncated() {
        return (this.state.getFlags() & 1) != 0;
    }

    public int peer(JBuffer jBuffer, int n) {
        return 0;
    }

    public int peer(JHeader jHeader) {
        this.state.peer(jHeader.state);
        return super.peer(jHeader, jHeader.getOffset(), jHeader.getLength());
    }

    public JBuffer peerPayloadTo(JBuffer jBuffer) {
        JPacket jPacket = this.getPacket();
        int n = this.getOffset() + this.size();
        jBuffer.peer(jPacket, n, jPacket.remaining(n));
        return jBuffer;
    }

    public final void setPacket(JPacket jPacket) {
        this.packet = jPacket;
    }

    public void setSubHeaders(JHeader[] jHeaderArray) {
    }

    public String toString() {
        JFormatter jFormatter = JPacket.getFormatter();
        jFormatter.reset();
        try {
            jFormatter.format(this);
        }
        catch (IOException iOException) {
            throw new IllegalStateException("Unexpected StringBuilder IO error");
        }
        return jFormatter.toString();
    }

    public byte[] transferPayloadTo(byte[] byArray) {
        JPacket jPacket = this.getPacket();
        int n = this.getOffset() + this.size();
        return jPacket.getByteArray(n, byArray);
    }

    public ByteBuffer transferPayloadTo(ByteBuffer byteBuffer) {
        JPacket jPacket = this.getPacket();
        int n = this.getOffset() + this.size();
        jPacket.transferTo(byteBuffer, n, jPacket.remaining(n));
        return byteBuffer;
    }

    public JBuffer transferPayloadTo(JBuffer jBuffer) {
        JPacket jPacket = this.getPacket();
        int n = this.getOffset() + this.size();
        jPacket.transferTo(jBuffer, n, jPacket.remaining(n), 0);
        return jBuffer;
    }

    void setIndex(int n) {
        this.index = n;
    }

    public int getIndex() {
        return this.index;
    }

    protected void validateHeader() {
    }

    public boolean hasNextHeader() {
        return this.index + 1 < this.packet.getState().getHeaderCount();
    }

    public int getNextHeaderId() {
        return this.packet.getState().getHeaderIdByIndex(this.index + 1);
    }

    public int getNextHeaderOffset() {
        return this.packet.getState().getHeaderOffsetByIndex(this.index + 1);
    }

    public boolean hasPreviousHeader() {
        return this.index > 0;
    }

    public int getPreviousHeaderId() {
        return this.packet.getState().getHeaderIdByIndex(this.index - 1);
    }

    public int getPreviousHeaderOffset() {
        return this.packet.getState().getHeaderOffsetByIndex(this.index - 1);
    }

    public boolean isFragmented() {
        return (this.getState().getFlags() & 0x100) > 0;
    }

    public static class State
    extends JStruct {
        public static final int FLAG_CRC_INVALID = 128;
        public static final int FLAG_CRC_PERFORMED = 64;
        public static final int FLAG_GAP_TRUNCATED = 8;
        public static final int FLAG_HEADER_TRUNCATED = 2;
        public static final int FLAG_HEURISTIC_BINDING = 32;
        public static final int FLAG_PAYLOAD_TRUNCATED = 4;
        public static final int FLAG_POSTFIX_TRUNCATED = 16;
        public static final int FLAG_PREFIX_TRUNCATED = 1;
        public static final int FLAG_HEADER_FRAGMENTED = 256;
        public static final int FLAG_FIELDS_DISSECTED = 512;
        public static final int FLAG_SUBHEADERS_DISSECTED = 1024;
        public static final int FLAG_IGNORE_BOUNDS = 2048;
        public static final String STRUCT_NAME = "header_t";

        public State(JMemory.Type type) {
            super(STRUCT_NAME, type);
        }

        public native int getFlags();

        public native int getGap();

        public native int getId();

        public native int getLength();

        public native int getOffset();

        public native int getPayload();

        public native int getPostfix();

        public native int getPrefix();

        public boolean isDirect() {
            return true;
        }

        public int peer(State state) {
            if (!state.isDirect()) {
                throw new IllegalStateException("DirectState can only peer with another DirectState");
            }
            return super.peer(state);
        }

        public native void setFlags(int var1);

        public String toString() {
            return "(id=" + this.getId() + ", offset=" + this.getOffset() + ", length=" + this.getLength() + ")";
        }
    }
}

