/*
 * Decompiled with CFR 0.152.
 */
package org.jnetpcap.nio;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.concurrent.CountDownLatch;
import junit.framework.TestCase;
import org.jnetpcap.nio.DisposableGC;
import org.jnetpcap.nio.JMemory;
import org.jnetpcap.nio.JMemoryPool;
import org.jnetpcap.nio.JNumber;
import org.jnetpcap.packet.JMemoryPacket;
import org.jnetpcap.packet.PeeringException;

public class TestJMemory
extends TestCase {
    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testPeerWithNonDirectByteBuffer() {
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        JNumber jNumber = new JNumber(JNumber.Type.INT);
        try {
            jNumber.peer(byteBuffer);
            TestJMemory.fail((String)"expected IllegalArgumentException");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testPeerWithDirectByteBuffer() throws PeeringException {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(4);
        byteBuffer.order(ByteOrder.nativeOrder());
        byteBuffer.putInt(100);
        byteBuffer.flip();
        JNumber jNumber = new JNumber(JNumber.Type.INT);
        jNumber.peer(byteBuffer);
        TestJMemory.assertEquals((int)100, (int)jNumber.intValue());
    }

    public void testTransferToDirectByteBuffer() {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(4);
        byteBuffer.order(ByteOrder.nativeOrder());
        JNumber jNumber = new JNumber(JNumber.Type.INT);
        jNumber.intValue(100);
        jNumber.transferTo(byteBuffer);
        byteBuffer.flip();
        TestJMemory.assertEquals((int)100, (int)byteBuffer.getInt());
    }

    public void testTransferFromDirectByteBuffer() {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(4);
        byteBuffer.order(ByteOrder.nativeOrder());
        byteBuffer.putInt(100);
        byteBuffer.flip();
        JNumber jNumber = new JNumber(JNumber.Type.INT);
        jNumber.transferFrom(byteBuffer);
        TestJMemory.assertEquals((int)100, (int)jNumber.intValue());
    }

    public void testReadFromUninitializedPtr() {
        JNumber jNumber = new JNumber(JMemory.Type.POINTER);
        try {
            TestJMemory.assertEquals((int)100, (int)jNumber.intValue());
            TestJMemory.fail((String)"Expected a native NULL ptr exception");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testLargeMemoryAllocationsFrom50Threads() throws InterruptedException {
        DisposableGC.getDefault().setVerbose(true);
        final CountDownLatch countDownLatch = new CountDownLatch(50);
        int n = 0;
        while (n < 50) {
            int n2 = n++;
            JMemoryPool jMemoryPool = new JMemoryPool();
            final int n3 = 1024 * n2;
            Thread thread = new Thread(){

                @Override
                public void run() {
                    for (int i = 0; i < 5000; ++i) {
                        new JMemoryPacket(n3);
                    }
                    countDownLatch.countDown();
                }
            };
            thread.start();
        }
        countDownLatch.await();
        DisposableGC.getDefault().setVerbose(false);
    }
}

