/*
 * Decompiled with CFR 0.152.
 */
package org.jnetpcap.header;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;
import org.jnetpcap.header.MyHeader;
import org.jnetpcap.nio.JBuffer;
import org.jnetpcap.packet.JHeader;
import org.jnetpcap.packet.JSubHeader;
import org.jnetpcap.packet.PcapPacket;
import org.jnetpcap.packet.TestUtils;
import org.jnetpcap.packet.annotate.Dynamic;
import org.jnetpcap.packet.annotate.Field;
import org.jnetpcap.packet.annotate.Header;
import org.jnetpcap.packet.annotate.HeaderLength;
import org.jnetpcap.packet.format.JFormatter;
import org.jnetpcap.packet.format.TextFormatter;
import org.jnetpcap.packet.structure.AnnotatedBindMethod;
import org.jnetpcap.packet.structure.AnnotatedBinding;
import org.jnetpcap.packet.structure.AnnotatedField;
import org.jnetpcap.packet.structure.AnnotatedHeader;
import org.jnetpcap.packet.structure.AnnotatedHeaderLengthMethod;
import org.jnetpcap.packet.structure.AnnotatedJField;
import org.jnetpcap.packet.structure.HeaderDefinitionError;
import org.jnetpcap.packet.structure.JField;
import org.jnetpcap.protocol.network.Ip4;

public class TestAnotatedDefinition
extends TestCase {
    private final List<HeaderDefinitionError> errors = new ArrayList<HeaderDefinitionError>();

    protected void setUp() throws Exception {
        this.errors.clear();
        AnnotatedBinding.clearCache();
        AnnotatedBindMethod.clearCache();
        AnnotatedHeaderLengthMethod.clearCache();
    }

    protected void tearDown() throws Exception {
        if (!this.errors.isEmpty()) {
            System.out.println("Found errors:");
            for (HeaderDefinitionError headerDefinitionError : this.errors) {
                System.out.println(headerDefinitionError.getMessage());
            }
            TestAnotatedDefinition.fail((String)("Found " + this.errors.size() + " header definition errors"));
        }
    }

    public void _test1() {
        MyHeader myHeader;
        PcapPacket pcapPacket = TestUtils.getPcapPacket("tests/test-afs.pcap", 0);
        if (pcapPacket.hasHeader(myHeader = new MyHeader()) && myHeader.version() == 4) {
            System.out.printf("found it id=%d\n", myHeader.getId());
            System.out.println(pcapPacket.toString());
        } else {
            System.out.printf("not found id=%d\n", myHeader.getId());
        }
    }

    public void test2() {
        AnnotatedHeader annotatedHeader;
        AnnotatedHeader annotatedHeader2 = AnnotatedHeader.inspectJHeaderClass(TestSubHeader.Sub1.Sub2.Sub3.class, this.errors);
        TestAnotatedDefinition.assertTrue((annotatedHeader2 == (annotatedHeader = AnnotatedHeader.inspectJHeaderClass(TestSubHeader.Sub1.Sub2.Sub3.class, this.errors)) ? 1 : 0) != 0);
    }

    public void testWithMyHeader() {
        AnnotatedHeader annotatedHeader = AnnotatedHeader.inspectJHeaderClass(MyHeader.class, this.errors);
    }

    public void testIp4() throws IOException {
        JField[] jFieldArray;
        AnnotatedHeader annotatedHeader = AnnotatedHeader.inspectJHeaderClass(Ip4.class, this.errors);
        AnnotatedField[] annotatedFieldArray = annotatedHeader.getFields();
        for (JField jField : jFieldArray = AnnotatedJField.fromAnnotatedFields(annotatedFieldArray)) {
            System.out.printf("field=%s\n", jField.toString());
        }
        Ip4 ip4 = new Ip4();
        PcapPacket pcapPacket = TestUtils.getPcapPacket("tests/test-afs.pcap", 0);
        if (pcapPacket.hasHeader(2)) {
            Ip4 ip42 = pcapPacket.getHeader(ip4);
            TextFormatter textFormatter = new TextFormatter(System.out);
            textFormatter.format((JHeader)ip42, JFormatter.Detail.MULTI_LINE_FULL_DETAIL);
        }
    }

    @Header(length=40, id=0)
    public static class TestSubHeader
    extends JHeader {

        @Header(length=30)
        public static class Sub1
        extends JSubHeader<TestSubHeader> {

            public static class Sub2
            extends Sub1 {

                @Header(id=1)
                public static class Sub3
                extends Sub2 {
                    @HeaderLength
                    public static int len(JBuffer jBuffer, int n) {
                        return 1;
                    }
                }
            }
        }
    }

    @Header
    public static class TestHeader
    extends JHeader {
        @HeaderLength
        public static int headerLength(JBuffer jBuffer, int n) {
            return 14;
        }

        @Field(offset=0, length=16)
        public int fieldA() {
            return this.getUShort(12);
        }

        @Field(offset=0, length=16)
        public int fieldB() {
            return this.getUShort(12);
        }

        @Dynamic(field="fieldB_Sub1", value=Field.Property.CHECK)
        public boolean hasFieldB_Sub1() {
            return true;
        }

        @Dynamic(field="fieldB_Sub1", value=Field.Property.LENGTH)
        public int fieldB_Sub1Length() {
            return 1;
        }

        @Field(parent="fieldB", offset=0)
        public int fieldB_Sub1() {
            return this.getUByte(12);
        }
    }
}

