/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.math.ec;

import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.Hashtable;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.math.ec.ECAlgorithms;
import org.bouncycastle.math.ec.ECConstants;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECFieldElement;
import org.bouncycastle.math.ec.PreCompCallback;
import org.bouncycastle.math.ec.PreCompInfo;
import org.bouncycastle.math.ec.ValidityPrecompInfo;
import org.bouncycastle.math.ec.WNafMultiplier;
import org.bouncycastle.math.ec.WTauNafMultiplier;

public abstract class ECPoint {
    protected static final ECFieldElement[] EMPTY_ZS = new ECFieldElement[0];
    protected ECCurve curve;
    protected ECFieldElement x;
    protected ECFieldElement y;
    protected ECFieldElement[] zs;
    protected Hashtable preCompTable = null;

    protected static ECFieldElement[] getInitialZCoords(ECCurve eCCurve) {
        int n = null == eCCurve ? 0 : eCCurve.getCoordinateSystem();
        switch (n) {
            case 0: 
            case 5: {
                return EMPTY_ZS;
            }
        }
        ECFieldElement eCFieldElement = eCCurve.fromBigInteger(ECConstants.ONE);
        switch (n) {
            case 1: 
            case 2: 
            case 6: {
                return new ECFieldElement[]{eCFieldElement};
            }
            case 3: {
                return new ECFieldElement[]{eCFieldElement, eCFieldElement, eCFieldElement};
            }
            case 4: {
                return new ECFieldElement[]{eCFieldElement, eCCurve.getA()};
            }
        }
        throw new IllegalArgumentException("unknown coordinate system");
    }

    protected ECPoint(ECCurve eCCurve, ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2) {
        this(eCCurve, eCFieldElement, eCFieldElement2, ECPoint.getInitialZCoords((ECCurve)eCCurve));
    }

    protected ECPoint(ECCurve eCCurve, ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2, ECFieldElement[] eCFieldElementArray) {
        this.curve = eCCurve;
        this.x = eCFieldElement;
        this.y = eCFieldElement2;
        this.zs = eCFieldElementArray;
    }

    protected abstract boolean satisfiesCurveEquation();

    protected boolean satisfiesOrder() {
        if (ECConstants.ONE.equals(this.curve.getCofactor())) {
            return true;
        }
        BigInteger bigInteger = this.curve.getOrder();
        return bigInteger == null || ECAlgorithms.referenceMultiply((ECPoint)this, (BigInteger)bigInteger).isInfinity();
    }

    public final ECPoint getDetachedPoint() {
        return this.normalize().detach();
    }

    public ECCurve getCurve() {
        return this.curve;
    }

    protected abstract ECPoint detach();

    protected int getCurveCoordinateSystem() {
        return null == this.curve ? 0 : this.curve.getCoordinateSystem();
    }

    public ECFieldElement getAffineXCoord() {
        this.checkNormalized();
        return this.getXCoord();
    }

    public ECFieldElement getAffineYCoord() {
        this.checkNormalized();
        return this.getYCoord();
    }

    public ECFieldElement getXCoord() {
        return this.x;
    }

    public ECFieldElement getYCoord() {
        return this.y;
    }

    public ECFieldElement getZCoord(int n) {
        return n < 0 || n >= this.zs.length ? null : this.zs[n];
    }

    public ECFieldElement[] getZCoords() {
        int n = this.zs.length;
        if (n == 0) {
            return EMPTY_ZS;
        }
        ECFieldElement[] eCFieldElementArray = new ECFieldElement[n];
        System.arraycopy(this.zs, 0, eCFieldElementArray, 0, n);
        return eCFieldElementArray;
    }

    public final ECFieldElement getRawXCoord() {
        return this.x;
    }

    public final ECFieldElement getRawYCoord() {
        return this.y;
    }

    protected final ECFieldElement[] getRawZCoords() {
        return this.zs;
    }

    protected void checkNormalized() {
        if (!this.isNormalized()) {
            throw new IllegalStateException("point not in normal form");
        }
    }

    public boolean isNormalized() {
        int n = this.getCurveCoordinateSystem();
        return n == 0 || n == 5 || this.isInfinity() || this.zs[0].isOne();
    }

    public ECPoint normalize() {
        if (this.isInfinity()) {
            return this;
        }
        switch (this.getCurveCoordinateSystem()) {
            case 0: 
            case 5: {
                return this;
            }
        }
        ECFieldElement eCFieldElement = this.getZCoord(0);
        if (eCFieldElement.isOne()) {
            return this;
        }
        if (null == this.curve) {
            throw new IllegalStateException("Detached points must be in affine coordinates");
        }
        SecureRandom secureRandom = CryptoServicesRegistrar.getSecureRandom();
        ECFieldElement eCFieldElement2 = this.curve.randomFieldElementMult(secureRandom);
        ECFieldElement eCFieldElement3 = eCFieldElement.multiply(eCFieldElement2).invert().multiply(eCFieldElement2);
        return this.normalize(eCFieldElement3);
    }

    ECPoint normalize(ECFieldElement eCFieldElement) {
        switch (this.getCurveCoordinateSystem()) {
            case 1: 
            case 6: {
                return this.createScaledPoint(eCFieldElement, eCFieldElement);
            }
            case 2: 
            case 3: 
            case 4: {
                ECFieldElement eCFieldElement2 = eCFieldElement.square();
                ECFieldElement eCFieldElement3 = eCFieldElement2.multiply(eCFieldElement);
                return this.createScaledPoint(eCFieldElement2, eCFieldElement3);
            }
        }
        throw new IllegalStateException("not a projective coordinate system");
    }

    protected ECPoint createScaledPoint(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2) {
        return this.getCurve().createRawPoint(this.getRawXCoord().multiply(eCFieldElement), this.getRawYCoord().multiply(eCFieldElement2));
    }

    public boolean isInfinity() {
        return this.x == null || this.y == null || this.zs.length > 0 && this.zs[0].isZero();
    }

    public boolean isValid() {
        return this.implIsValid(false, true);
    }

    boolean isValidPartial() {
        return this.implIsValid(false, false);
    }

    boolean implIsValid(final boolean bl, final boolean bl2) {
        if (this.isInfinity()) {
            return true;
        }
        ValidityPrecompInfo validityPrecompInfo = (ValidityPrecompInfo)this.getCurve().precompute(this, "bc_validity", new PreCompCallback(){

            public PreCompInfo precompute(PreCompInfo preCompInfo) {
                ValidityPrecompInfo validityPrecompInfo;
                ValidityPrecompInfo validityPrecompInfo2 = validityPrecompInfo = preCompInfo instanceof ValidityPrecompInfo ? (ValidityPrecompInfo)preCompInfo : null;
                if (validityPrecompInfo == null) {
                    validityPrecompInfo = new ValidityPrecompInfo();
                }
                if (validityPrecompInfo.hasFailed()) {
                    return validityPrecompInfo;
                }
                if (!validityPrecompInfo.hasCurveEquationPassed()) {
                    if (!bl && !ECPoint.this.satisfiesCurveEquation()) {
                        validityPrecompInfo.reportFailed();
                        return validityPrecompInfo;
                    }
                    validityPrecompInfo.reportCurveEquationPassed();
                }
                if (bl2 && !validityPrecompInfo.hasOrderPassed()) {
                    if (!ECPoint.this.satisfiesOrder()) {
                        validityPrecompInfo.reportFailed();
                        return validityPrecompInfo;
                    }
                    validityPrecompInfo.reportOrderPassed();
                }
                return validityPrecompInfo;
            }
        });
        return !validityPrecompInfo.hasFailed();
    }

    public ECPoint scaleX(ECFieldElement eCFieldElement) {
        return this.isInfinity() ? this : this.getCurve().createRawPoint(this.getRawXCoord().multiply(eCFieldElement), this.getRawYCoord(), this.getRawZCoords());
    }

    public ECPoint scaleXNegateY(ECFieldElement eCFieldElement) {
        return this.isInfinity() ? this : this.getCurve().createRawPoint(this.getRawXCoord().multiply(eCFieldElement), this.getRawYCoord().negate(), this.getRawZCoords());
    }

    public ECPoint scaleY(ECFieldElement eCFieldElement) {
        return this.isInfinity() ? this : this.getCurve().createRawPoint(this.getRawXCoord(), this.getRawYCoord().multiply(eCFieldElement), this.getRawZCoords());
    }

    public ECPoint scaleYNegateX(ECFieldElement eCFieldElement) {
        return this.isInfinity() ? this : this.getCurve().createRawPoint(this.getRawXCoord().negate(), this.getRawYCoord().multiply(eCFieldElement), this.getRawZCoords());
    }

    public boolean equals(ECPoint eCPoint) {
        if (null == eCPoint) {
            return false;
        }
        ECCurve eCCurve = this.getCurve();
        ECCurve eCCurve2 = eCPoint.getCurve();
        boolean bl = null == eCCurve;
        boolean bl2 = null == eCCurve2;
        boolean bl3 = this.isInfinity();
        boolean bl4 = eCPoint.isInfinity();
        if (bl3 || bl4) {
            return bl3 && bl4 && (bl || bl2 || eCCurve.equals(eCCurve2));
        }
        ECPoint eCPoint2 = this;
        ECPoint eCPoint3 = eCPoint;
        if (!bl || !bl2) {
            if (bl) {
                eCPoint3 = eCPoint3.normalize();
            } else if (bl2) {
                eCPoint2 = eCPoint2.normalize();
            } else {
                if (!eCCurve.equals(eCCurve2)) {
                    return false;
                }
                ECPoint[] eCPointArray = new ECPoint[]{this, eCCurve.importPoint(eCPoint3)};
                eCCurve.normalizeAll(eCPointArray);
                eCPoint2 = eCPointArray[0];
                eCPoint3 = eCPointArray[1];
            }
        }
        return eCPoint2.getXCoord().equals(eCPoint3.getXCoord()) && eCPoint2.getYCoord().equals(eCPoint3.getYCoord());
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ECPoint)) {
            return false;
        }
        return this.equals((ECPoint)object);
    }

    public int hashCode() {
        int n;
        ECCurve eCCurve = this.getCurve();
        int n2 = n = null == eCCurve ? 0 : ~eCCurve.hashCode();
        if (!this.isInfinity()) {
            ECPoint eCPoint = this.normalize();
            n ^= eCPoint.getXCoord().hashCode() * 17;
            n ^= eCPoint.getYCoord().hashCode() * 257;
        }
        return n;
    }

    public String toString() {
        if (this.isInfinity()) {
            return "INF";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('(');
        stringBuffer.append(this.getRawXCoord());
        stringBuffer.append(',');
        stringBuffer.append(this.getRawYCoord());
        for (int i = 0; i < this.zs.length; ++i) {
            stringBuffer.append(',');
            stringBuffer.append(this.zs[i]);
        }
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    public byte[] getEncoded(boolean bl) {
        if (this.isInfinity()) {
            return new byte[1];
        }
        ECPoint eCPoint = this.normalize();
        byte[] byArray = eCPoint.getXCoord().getEncoded();
        if (bl) {
            byte[] byArray2 = new byte[byArray.length + 1];
            byArray2[0] = (byte)(eCPoint.getCompressionYTilde() ? 3 : 2);
            System.arraycopy(byArray, 0, byArray2, 1, byArray.length);
            return byArray2;
        }
        byte[] byArray3 = eCPoint.getYCoord().getEncoded();
        byte[] byArray4 = new byte[byArray.length + byArray3.length + 1];
        byArray4[0] = 4;
        System.arraycopy(byArray, 0, byArray4, 1, byArray.length);
        System.arraycopy(byArray3, 0, byArray4, byArray.length + 1, byArray3.length);
        return byArray4;
    }

    protected abstract boolean getCompressionYTilde();

    public abstract ECPoint add(ECPoint var1);

    public abstract ECPoint negate();

    public abstract ECPoint subtract(ECPoint var1);

    public ECPoint timesPow2(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("'e' cannot be negative");
        }
        ECPoint eCPoint = this;
        while (--n >= 0) {
            eCPoint = eCPoint.twice();
        }
        return eCPoint;
    }

    public abstract ECPoint twice();

    public ECPoint twicePlus(ECPoint eCPoint) {
        return this.twice().add(eCPoint);
    }

    public ECPoint threeTimes() {
        return this.twicePlus(this);
    }

    public ECPoint multiply(BigInteger bigInteger) {
        return this.getCurve().getMultiplier().multiply(this, bigInteger);
    }

    public static class F2m
    extends ECPoint {
        public F2m(ECCurve eCCurve, ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2) {
            this(eCCurve, eCFieldElement, eCFieldElement2, false);
        }

        public F2m(ECCurve eCCurve, ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2, boolean bl) {
            super(eCCurve, eCFieldElement, eCFieldElement2);
            if (eCFieldElement != null && eCFieldElement2 == null || eCFieldElement == null && eCFieldElement2 != null) {
                throw new IllegalArgumentException("Exactly one of the field elements is null");
            }
            if (eCFieldElement != null) {
                ECFieldElement.F2m.checkFieldElements(this.x, this.y);
                if (eCCurve != null) {
                    ECFieldElement.F2m.checkFieldElements(this.x, this.curve.getA());
                }
            }
            this.withCompression = bl;
        }

        @Override
        public byte[] getEncoded() {
            byte[] byArray;
            if (this.isInfinity()) {
                return new byte[1];
            }
            int n = converter.getByteLength(this.x);
            byte[] byArray2 = converter.integerToBytes(this.getX().toBigInteger(), n);
            if (this.withCompression) {
                byArray = new byte[n + 1];
                byArray[0] = 2;
                if (!this.getX().toBigInteger().equals(ECConstants.ZERO) && this.getY().multiply(this.getX().invert()).toBigInteger().testBit(0)) {
                    byArray[0] = 3;
                }
                System.arraycopy(byArray2, 0, byArray, 1, n);
            } else {
                byte[] byArray3 = converter.integerToBytes(this.getY().toBigInteger(), n);
                byArray = new byte[n + n + 1];
                byArray[0] = 4;
                System.arraycopy(byArray2, 0, byArray, 1, n);
                System.arraycopy(byArray3, 0, byArray, n + 1, n);
            }
            return byArray;
        }

        private static void checkPoints(ECPoint eCPoint, ECPoint eCPoint2) {
            if (!eCPoint.curve.equals(eCPoint2.curve)) {
                throw new IllegalArgumentException("Only points on the same curve can be added or subtracted");
            }
        }

        @Override
        public ECPoint add(ECPoint eCPoint) {
            F2m.checkPoints(this, eCPoint);
            return this.addSimple((F2m)eCPoint);
        }

        public F2m addSimple(F2m f2m) {
            F2m f2m2 = f2m;
            if (this.isInfinity()) {
                return f2m2;
            }
            if (f2m2.isInfinity()) {
                return this;
            }
            ECFieldElement.F2m f2m3 = (ECFieldElement.F2m)f2m2.getX();
            ECFieldElement.F2m f2m4 = (ECFieldElement.F2m)f2m2.getY();
            if (this.x.equals(f2m3)) {
                if (this.y.equals(f2m4)) {
                    return (F2m)this.twice();
                }
                return (F2m)this.curve.getInfinity();
            }
            ECFieldElement.F2m f2m5 = (ECFieldElement.F2m)this.y.add(f2m4).divide(this.x.add(f2m3));
            ECFieldElement.F2m f2m6 = (ECFieldElement.F2m)f2m5.square().add(f2m5).add(this.x).add(f2m3).add(this.curve.getA());
            ECFieldElement.F2m f2m7 = (ECFieldElement.F2m)f2m5.multiply(this.x.add(f2m6)).add(f2m6).add(this.y);
            return new F2m(this.curve, f2m6, f2m7, this.withCompression);
        }

        @Override
        public ECPoint subtract(ECPoint eCPoint) {
            F2m.checkPoints(this, eCPoint);
            return this.subtractSimple((F2m)eCPoint);
        }

        public F2m subtractSimple(F2m f2m) {
            if (f2m.isInfinity()) {
                return this;
            }
            return this.addSimple((F2m)f2m.negate());
        }

        @Override
        public ECPoint twice() {
            if (this.isInfinity()) {
                return this;
            }
            if (this.x.toBigInteger().signum() == 0) {
                return this.curve.getInfinity();
            }
            ECFieldElement.F2m f2m = (ECFieldElement.F2m)this.x.add(this.y.divide(this.x));
            ECFieldElement.F2m f2m2 = (ECFieldElement.F2m)f2m.square().add(f2m).add(this.curve.getA());
            ECFieldElement eCFieldElement = this.curve.fromBigInteger(ECConstants.ONE);
            ECFieldElement.F2m f2m3 = (ECFieldElement.F2m)this.x.square().add(f2m2.multiply(f2m.add(eCFieldElement)));
            return new F2m(this.curve, f2m2, f2m3, this.withCompression);
        }

        @Override
        public ECPoint negate() {
            return new F2m(this.curve, this.getX(), this.getY().add(this.getX()), this.withCompression);
        }

        @Override
        synchronized void assertECMultiplier() {
            if (this.multiplier == null) {
                this.multiplier = ((ECCurve.F2m)this.curve).isKoblitz() ? new WTauNafMultiplier() : new WNafMultiplier();
            }
        }
    }

    public static abstract class AbstractF2m
    extends ECPoint {
        protected AbstractF2m(ECCurve eCCurve, ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2) {
            super(eCCurve, eCFieldElement, eCFieldElement2);
        }

        protected AbstractF2m(ECCurve eCCurve, ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2, ECFieldElement[] eCFieldElementArray) {
            super(eCCurve, eCFieldElement, eCFieldElement2, eCFieldElementArray);
        }

        protected boolean satisfiesCurveEquation() {
            ECFieldElement eCFieldElement;
            ECCurve eCCurve = this.getCurve();
            ECFieldElement eCFieldElement2 = this.x;
            ECFieldElement eCFieldElement3 = eCCurve.getA();
            ECFieldElement eCFieldElement4 = eCCurve.getB();
            int n = eCCurve.getCoordinateSystem();
            if (n == 6) {
                ECFieldElement eCFieldElement5;
                ECFieldElement eCFieldElement6;
                ECFieldElement eCFieldElement7 = this.zs[0];
                boolean bl = eCFieldElement7.isOne();
                if (eCFieldElement2.isZero()) {
                    ECFieldElement eCFieldElement8 = this.y;
                    ECFieldElement eCFieldElement9 = eCFieldElement8.square();
                    ECFieldElement eCFieldElement10 = eCFieldElement4;
                    if (!bl) {
                        eCFieldElement10 = eCFieldElement10.multiply(eCFieldElement7.square());
                    }
                    return eCFieldElement9.equals(eCFieldElement10);
                }
                ECFieldElement eCFieldElement11 = this.y;
                ECFieldElement eCFieldElement12 = eCFieldElement2.square();
                if (bl) {
                    eCFieldElement6 = eCFieldElement11.square().add(eCFieldElement11).add(eCFieldElement3);
                    eCFieldElement5 = eCFieldElement12.square().add(eCFieldElement4);
                } else {
                    ECFieldElement eCFieldElement13 = eCFieldElement7.square();
                    ECFieldElement eCFieldElement14 = eCFieldElement13.square();
                    eCFieldElement6 = eCFieldElement11.add(eCFieldElement7).multiplyPlusProduct(eCFieldElement11, eCFieldElement3, eCFieldElement13);
                    eCFieldElement5 = eCFieldElement12.squarePlusProduct(eCFieldElement4, eCFieldElement14);
                }
                eCFieldElement6 = eCFieldElement6.multiply(eCFieldElement12);
                return eCFieldElement6.equals(eCFieldElement5);
            }
            ECFieldElement eCFieldElement15 = this.y;
            ECFieldElement eCFieldElement16 = eCFieldElement15.add(eCFieldElement2).multiply(eCFieldElement15);
            switch (n) {
                case 0: {
                    break;
                }
                case 1: {
                    eCFieldElement = this.zs[0];
                    if (eCFieldElement.isOne()) break;
                    ECFieldElement eCFieldElement17 = eCFieldElement.square();
                    ECFieldElement eCFieldElement18 = eCFieldElement.multiply(eCFieldElement17);
                    eCFieldElement16 = eCFieldElement16.multiply(eCFieldElement);
                    eCFieldElement3 = eCFieldElement3.multiply(eCFieldElement);
                    eCFieldElement4 = eCFieldElement4.multiply(eCFieldElement18);
                    break;
                }
                default: {
                    throw new IllegalStateException("unsupported coordinate system");
                }
            }
            eCFieldElement = eCFieldElement2.add(eCFieldElement3).multiply(eCFieldElement2.square()).add(eCFieldElement4);
            return eCFieldElement16.equals(eCFieldElement);
        }

        protected boolean satisfiesOrder() {
            BigInteger bigInteger = this.curve.getCofactor();
            if (ECConstants.TWO.equals(bigInteger)) {
                ECPoint eCPoint = this.normalize();
                ECFieldElement eCFieldElement = eCPoint.getAffineXCoord();
                return 0 != ((ECFieldElement.AbstractF2m)eCFieldElement).trace();
            }
            if (ECConstants.FOUR.equals(bigInteger)) {
                ECPoint eCPoint = this.normalize();
                ECFieldElement eCFieldElement = eCPoint.getAffineXCoord();
                ECFieldElement eCFieldElement2 = ((ECCurve.AbstractF2m)this.curve).solveQuadraticEquation(eCFieldElement.add(this.curve.getA()));
                if (null == eCFieldElement2) {
                    return false;
                }
                ECFieldElement eCFieldElement3 = eCPoint.getAffineYCoord();
                ECFieldElement eCFieldElement4 = eCFieldElement.multiply(eCFieldElement2).add(eCFieldElement3);
                return 0 == ((ECFieldElement.AbstractF2m)eCFieldElement4).trace();
            }
            return super.satisfiesOrder();
        }

        public ECPoint scaleX(ECFieldElement eCFieldElement) {
            if (this.isInfinity()) {
                return this;
            }
            int n = this.getCurveCoordinateSystem();
            switch (n) {
                case 5: {
                    ECFieldElement eCFieldElement2 = this.getRawXCoord();
                    ECFieldElement eCFieldElement3 = this.getRawYCoord();
                    ECFieldElement eCFieldElement4 = eCFieldElement2.multiply(eCFieldElement);
                    ECFieldElement eCFieldElement5 = eCFieldElement3.add(eCFieldElement2).divide(eCFieldElement).add(eCFieldElement4);
                    return this.getCurve().createRawPoint(eCFieldElement2, eCFieldElement5, this.getRawZCoords());
                }
                case 6: {
                    ECFieldElement eCFieldElement6 = this.getRawXCoord();
                    ECFieldElement eCFieldElement7 = this.getRawYCoord();
                    ECFieldElement eCFieldElement8 = this.getRawZCoords()[0];
                    ECFieldElement eCFieldElement9 = eCFieldElement6.multiply(eCFieldElement.square());
                    ECFieldElement eCFieldElement10 = eCFieldElement7.add(eCFieldElement6).add(eCFieldElement9);
                    ECFieldElement eCFieldElement11 = eCFieldElement8.multiply(eCFieldElement);
                    return this.getCurve().createRawPoint(eCFieldElement9, eCFieldElement10, new ECFieldElement[]{eCFieldElement11});
                }
            }
            return super.scaleX(eCFieldElement);
        }

        public ECPoint scaleXNegateY(ECFieldElement eCFieldElement) {
            return this.scaleX(eCFieldElement);
        }

        public ECPoint scaleY(ECFieldElement eCFieldElement) {
            if (this.isInfinity()) {
                return this;
            }
            int n = this.getCurveCoordinateSystem();
            switch (n) {
                case 5: 
                case 6: {
                    ECFieldElement eCFieldElement2 = this.getRawXCoord();
                    ECFieldElement eCFieldElement3 = this.getRawYCoord();
                    ECFieldElement eCFieldElement4 = eCFieldElement3.add(eCFieldElement2).multiply(eCFieldElement).add(eCFieldElement2);
                    return this.getCurve().createRawPoint(eCFieldElement2, eCFieldElement4, this.getRawZCoords());
                }
            }
            return super.scaleY(eCFieldElement);
        }

        public ECPoint scaleYNegateX(ECFieldElement eCFieldElement) {
            return this.scaleY(eCFieldElement);
        }

        public ECPoint subtract(ECPoint eCPoint) {
            if (eCPoint.isInfinity()) {
                return this;
            }
            return this.add(eCPoint.negate());
        }

        public AbstractF2m tau() {
            if (this.isInfinity()) {
                return this;
            }
            ECCurve eCCurve = this.getCurve();
            int n = eCCurve.getCoordinateSystem();
            ECFieldElement eCFieldElement = this.x;
            switch (n) {
                case 0: 
                case 5: {
                    ECFieldElement eCFieldElement2 = this.y;
                    return (AbstractF2m)eCCurve.createRawPoint(eCFieldElement.square(), eCFieldElement2.square());
                }
                case 1: 
                case 6: {
                    ECFieldElement eCFieldElement3 = this.y;
                    ECFieldElement eCFieldElement4 = this.zs[0];
                    return (AbstractF2m)eCCurve.createRawPoint(eCFieldElement.square(), eCFieldElement3.square(), new ECFieldElement[]{eCFieldElement4.square()});
                }
            }
            throw new IllegalStateException("unsupported coordinate system");
        }

        public AbstractF2m tauPow(int n) {
            if (this.isInfinity()) {
                return this;
            }
            ECCurve eCCurve = this.getCurve();
            int n2 = eCCurve.getCoordinateSystem();
            ECFieldElement eCFieldElement = this.x;
            switch (n2) {
                case 0: 
                case 5: {
                    ECFieldElement eCFieldElement2 = this.y;
                    return (AbstractF2m)eCCurve.createRawPoint(eCFieldElement.squarePow(n), eCFieldElement2.squarePow(n));
                }
                case 1: 
                case 6: {
                    ECFieldElement eCFieldElement3 = this.y;
                    ECFieldElement eCFieldElement4 = this.zs[0];
                    return (AbstractF2m)eCCurve.createRawPoint(eCFieldElement.squarePow(n), eCFieldElement3.squarePow(n), new ECFieldElement[]{eCFieldElement4.squarePow(n)});
                }
            }
            throw new IllegalStateException("unsupported coordinate system");
        }
    }

    public static class Fp
    extends ECPoint {
        public Fp(ECCurve eCCurve, ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2) {
            this(eCCurve, eCFieldElement, eCFieldElement2, false);
        }

        public Fp(ECCurve eCCurve, ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2, boolean bl) {
            super(eCCurve, eCFieldElement, eCFieldElement2);
            if (eCFieldElement != null && eCFieldElement2 == null || eCFieldElement == null && eCFieldElement2 != null) {
                throw new IllegalArgumentException("Exactly one of the field elements is null");
            }
            this.withCompression = bl;
        }

        @Override
        public byte[] getEncoded() {
            if (this.isInfinity()) {
                return new byte[1];
            }
            int n = converter.getByteLength(this.x);
            if (this.withCompression) {
                int n2 = this.getY().toBigInteger().testBit(0) ? 3 : 2;
                byte[] byArray = converter.integerToBytes(this.getX().toBigInteger(), n);
                byte[] byArray2 = new byte[byArray.length + 1];
                byArray2[0] = n2;
                System.arraycopy(byArray, 0, byArray2, 1, byArray.length);
                return byArray2;
            }
            byte[] byArray = converter.integerToBytes(this.getX().toBigInteger(), n);
            byte[] byArray3 = converter.integerToBytes(this.getY().toBigInteger(), n);
            byte[] byArray4 = new byte[byArray.length + byArray3.length + 1];
            byArray4[0] = 4;
            System.arraycopy(byArray, 0, byArray4, 1, byArray.length);
            System.arraycopy(byArray3, 0, byArray4, byArray.length + 1, byArray3.length);
            return byArray4;
        }

        @Override
        public ECPoint add(ECPoint eCPoint) {
            if (this.isInfinity()) {
                return eCPoint;
            }
            if (eCPoint.isInfinity()) {
                return this;
            }
            if (this.x.equals(eCPoint.x)) {
                if (this.y.equals(eCPoint.y)) {
                    return this.twice();
                }
                return this.curve.getInfinity();
            }
            ECFieldElement eCFieldElement = eCPoint.y.subtract(this.y).divide(eCPoint.x.subtract(this.x));
            ECFieldElement eCFieldElement2 = eCFieldElement.square().subtract(this.x).subtract(eCPoint.x);
            ECFieldElement eCFieldElement3 = eCFieldElement.multiply(this.x.subtract(eCFieldElement2)).subtract(this.y);
            return new Fp(this.curve, eCFieldElement2, eCFieldElement3);
        }

        @Override
        public ECPoint twice() {
            if (this.isInfinity()) {
                return this;
            }
            if (this.y.toBigInteger().signum() == 0) {
                return this.curve.getInfinity();
            }
            ECFieldElement eCFieldElement = this.curve.fromBigInteger(BigInteger.valueOf(2L));
            ECFieldElement eCFieldElement2 = this.curve.fromBigInteger(BigInteger.valueOf(3L));
            ECFieldElement eCFieldElement3 = this.x.square().multiply(eCFieldElement2).add(this.curve.a).divide(this.y.multiply(eCFieldElement));
            ECFieldElement eCFieldElement4 = eCFieldElement3.square().subtract(this.x.multiply(eCFieldElement));
            ECFieldElement eCFieldElement5 = eCFieldElement3.multiply(this.x.subtract(eCFieldElement4)).subtract(this.y);
            return new Fp(this.curve, eCFieldElement4, eCFieldElement5, this.withCompression);
        }

        @Override
        public ECPoint subtract(ECPoint eCPoint) {
            if (eCPoint.isInfinity()) {
                return this;
            }
            return this.add(eCPoint.negate());
        }

        @Override
        public ECPoint negate() {
            return new Fp(this.curve, this.x, this.y.negate(), this.withCompression);
        }

        @Override
        synchronized void assertECMultiplier() {
            if (this.multiplier == null) {
                this.multiplier = new WNafMultiplier();
            }
        }
    }

    public static abstract class AbstractFp
    extends ECPoint {
        protected AbstractFp(ECCurve eCCurve, ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2) {
            super(eCCurve, eCFieldElement, eCFieldElement2);
        }

        protected AbstractFp(ECCurve eCCurve, ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2, ECFieldElement[] eCFieldElementArray) {
            super(eCCurve, eCFieldElement, eCFieldElement2, eCFieldElementArray);
        }

        protected boolean getCompressionYTilde() {
            return this.getAffineYCoord().testBitZero();
        }

        protected boolean satisfiesCurveEquation() {
            ECFieldElement eCFieldElement;
            ECFieldElement eCFieldElement2 = this.x;
            ECFieldElement eCFieldElement3 = this.y;
            ECFieldElement eCFieldElement4 = this.curve.getA();
            ECFieldElement eCFieldElement5 = this.curve.getB();
            ECFieldElement eCFieldElement6 = eCFieldElement3.square();
            switch (this.getCurveCoordinateSystem()) {
                case 0: {
                    break;
                }
                case 1: {
                    eCFieldElement = this.zs[0];
                    if (eCFieldElement.isOne()) break;
                    ECFieldElement eCFieldElement7 = eCFieldElement.square();
                    ECFieldElement eCFieldElement8 = eCFieldElement.multiply(eCFieldElement7);
                    eCFieldElement6 = eCFieldElement6.multiply(eCFieldElement);
                    eCFieldElement4 = eCFieldElement4.multiply(eCFieldElement7);
                    eCFieldElement5 = eCFieldElement5.multiply(eCFieldElement8);
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    eCFieldElement = this.zs[0];
                    if (eCFieldElement.isOne()) break;
                    ECFieldElement eCFieldElement9 = eCFieldElement.square();
                    ECFieldElement eCFieldElement10 = eCFieldElement9.square();
                    ECFieldElement eCFieldElement11 = eCFieldElement9.multiply(eCFieldElement10);
                    eCFieldElement4 = eCFieldElement4.multiply(eCFieldElement10);
                    eCFieldElement5 = eCFieldElement5.multiply(eCFieldElement11);
                    break;
                }
                default: {
                    throw new IllegalStateException("unsupported coordinate system");
                }
            }
            eCFieldElement = eCFieldElement2.square().add(eCFieldElement4).multiply(eCFieldElement2).add(eCFieldElement5);
            return eCFieldElement6.equals(eCFieldElement);
        }

        public ECPoint subtract(ECPoint eCPoint) {
            if (eCPoint.isInfinity()) {
                return this;
            }
            return this.add(eCPoint.negate());
        }
    }
}

