/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider;

import java.security.PublicKey;
import java.security.cert.CertPathValidatorException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Date;
import org.bouncycastle.jcajce.PKIXCertRevocationChecker;
import org.bouncycastle.jcajce.PKIXCertRevocationCheckerParameters;
import org.bouncycastle.jcajce.PKIXExtendedParameters;
import org.bouncycastle.jcajce.util.JcaJceHelper;
import org.bouncycastle.jce.provider.AnnotatedException;
import org.bouncycastle.jce.provider.RFC3280CertPathUtilities;

class ProvCrlRevocationChecker
implements PKIXCertRevocationChecker {
    private final JcaJceHelper helper;
    private PKIXCertRevocationCheckerParameters params;

    public ProvCrlRevocationChecker(JcaJceHelper jcaJceHelper) {
        this.helper = jcaJceHelper;
    }

    public void setParameter(String string, Object object) {
    }

    public void initialize(PKIXCertRevocationCheckerParameters pKIXCertRevocationCheckerParameters) {
        this.params = pKIXCertRevocationCheckerParameters;
    }

    public void init(boolean bl) throws CertPathValidatorException {
        if (bl) {
            throw new CertPathValidatorException("forward checking not supported");
        }
    }

    public void check(Certificate certificate) throws CertPathValidatorException {
        try {
            RFC3280CertPathUtilities.checkCRLs((PKIXCertRevocationCheckerParameters)this.params, (PKIXExtendedParameters)this.params.getParamsPKIX(), (X509Certificate)((X509Certificate)certificate), (Date)this.params.getValidDate(), (X509Certificate)this.params.getSigningCert(), (PublicKey)this.params.getWorkingPublicKey(), this.params.getCertPath().getCertificates(), (JcaJceHelper)this.helper);
        }
        catch (AnnotatedException annotatedException) {
            Throwable throwable = annotatedException;
            if (null != annotatedException.getCause()) {
                throwable = annotatedException.getCause();
            }
            throw new CertPathValidatorException(annotatedException.getMessage(), throwable, this.params.getCertPath(), this.params.getIndex());
        }
    }
}

