/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.x9;

import java.util.Enumeration;
import java.util.Vector;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.anssi.ANSSINamedCurves;
import org.bouncycastle.asn1.cryptlib.CryptlibObjectIdentifiers;
import org.bouncycastle.asn1.cryptopro.ECGOST3410NamedCurves;
import org.bouncycastle.asn1.gm.GMNamedCurves;
import org.bouncycastle.asn1.nist.NISTNamedCurves;
import org.bouncycastle.asn1.sec.SECNamedCurves;
import org.bouncycastle.asn1.teletrust.TeleTrusTNamedCurves;
import org.bouncycastle.asn1.x9.X962NamedCurves;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.asn1.x9.X9ECPoint;
import org.bouncycastle.crypto.ec.CustomNamedCurves;
import org.bouncycastle.crypto.params.ECDomainParameters;

public class ECNamedCurveTable {
    public static X9ECParameters getByName(String string) {
        X9ECParameters x9ECParameters = X962NamedCurves.getByName(string);
        if (x9ECParameters == null) {
            x9ECParameters = SECNamedCurves.getByName(string);
        }
        if (x9ECParameters == null) {
            x9ECParameters = NISTNamedCurves.getByName(string);
        }
        if (x9ECParameters == null) {
            x9ECParameters = TeleTrusTNamedCurves.getByName(string);
        }
        if (x9ECParameters == null) {
            x9ECParameters = ANSSINamedCurves.getByName(string);
        }
        if (x9ECParameters == null) {
            x9ECParameters = ECNamedCurveTable.fromDomainParameters(ECGOST3410NamedCurves.getByName(string));
        }
        if (x9ECParameters == null) {
            x9ECParameters = GMNamedCurves.getByName(string);
        }
        return x9ECParameters;
    }

    public static ASN1ObjectIdentifier getOID(String string) {
        DERObjectIdentifier dERObjectIdentifier = X962NamedCurves.getOID(string);
        if (dERObjectIdentifier == null) {
            dERObjectIdentifier = SECNamedCurves.getOID(string);
        }
        if (dERObjectIdentifier == null) {
            dERObjectIdentifier = NISTNamedCurves.getOID(string);
        }
        if (dERObjectIdentifier == null) {
            dERObjectIdentifier = TeleTrusTNamedCurves.getOID(string);
        }
        if (dERObjectIdentifier == null) {
            dERObjectIdentifier = ANSSINamedCurves.getOID(string);
        }
        if (dERObjectIdentifier == null) {
            dERObjectIdentifier = ECGOST3410NamedCurves.getOID(string);
        }
        if (dERObjectIdentifier == null) {
            dERObjectIdentifier = GMNamedCurves.getOID(string);
        }
        if (dERObjectIdentifier == null && string.equals("curve25519")) {
            dERObjectIdentifier = CryptlibObjectIdentifiers.curvey25519;
        }
        return dERObjectIdentifier;
    }

    public static String getName(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        String string = X962NamedCurves.getName((ASN1ObjectIdentifier)aSN1ObjectIdentifier);
        if (string == null) {
            string = SECNamedCurves.getName((ASN1ObjectIdentifier)aSN1ObjectIdentifier);
        }
        if (string == null) {
            string = NISTNamedCurves.getName((ASN1ObjectIdentifier)aSN1ObjectIdentifier);
        }
        if (string == null) {
            string = TeleTrusTNamedCurves.getName((ASN1ObjectIdentifier)aSN1ObjectIdentifier);
        }
        if (string == null) {
            string = ANSSINamedCurves.getName(aSN1ObjectIdentifier);
        }
        if (string == null) {
            string = ECGOST3410NamedCurves.getName((ASN1ObjectIdentifier)aSN1ObjectIdentifier);
        }
        if (string == null) {
            string = GMNamedCurves.getName(aSN1ObjectIdentifier);
        }
        if (string == null) {
            string = CustomNamedCurves.getName(aSN1ObjectIdentifier);
        }
        return string;
    }

    public static X9ECParameters getByOID(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        X9ECParameters x9ECParameters = X962NamedCurves.getByOID((ASN1ObjectIdentifier)aSN1ObjectIdentifier);
        if (x9ECParameters == null) {
            x9ECParameters = SECNamedCurves.getByOID((ASN1ObjectIdentifier)aSN1ObjectIdentifier);
        }
        if (x9ECParameters == null) {
            x9ECParameters = TeleTrusTNamedCurves.getByOID((ASN1ObjectIdentifier)aSN1ObjectIdentifier);
        }
        if (x9ECParameters == null) {
            x9ECParameters = ANSSINamedCurves.getByOID(aSN1ObjectIdentifier);
        }
        if (x9ECParameters == null) {
            x9ECParameters = ECNamedCurveTable.fromDomainParameters(ECGOST3410NamedCurves.getByOID((ASN1ObjectIdentifier)aSN1ObjectIdentifier));
        }
        if (x9ECParameters == null) {
            x9ECParameters = GMNamedCurves.getByOID(aSN1ObjectIdentifier);
        }
        return x9ECParameters;
    }

    public static Enumeration getNames() {
        Vector vector = new Vector();
        ECNamedCurveTable.addEnumeration(vector, X962NamedCurves.getNames());
        ECNamedCurveTable.addEnumeration(vector, SECNamedCurves.getNames());
        ECNamedCurveTable.addEnumeration(vector, NISTNamedCurves.getNames());
        ECNamedCurveTable.addEnumeration(vector, TeleTrusTNamedCurves.getNames());
        ECNamedCurveTable.addEnumeration(vector, ANSSINamedCurves.getNames());
        ECNamedCurveTable.addEnumeration(vector, ECGOST3410NamedCurves.getNames());
        ECNamedCurveTable.addEnumeration(vector, GMNamedCurves.getNames());
        return vector.elements();
    }

    private static void addEnumeration(Vector vector, Enumeration enumeration) {
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
    }

    private static X9ECParameters fromDomainParameters(ECDomainParameters eCDomainParameters) {
        return eCDomainParameters == null ? null : new X9ECParameters(eCDomainParameters.getCurve(), new X9ECPoint(eCDomainParameters.getG(), false), eCDomainParameters.getN(), eCDomainParameters.getH(), eCDomainParameters.getSeed());
    }
}

