/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.IOException;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1OutputStream;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1String;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.StreamUtil;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Strings;

public class DERT61String
extends ASN1Primitive
implements ASN1String {
    private byte[] string;

    public static DERT61String getInstance(Object object) {
        if (object == null || object instanceof DERT61String) {
            return (DERT61String)object;
        }
        if (object instanceof byte[]) {
            try {
                return (DERT61String)DERT61String.fromByteArray((byte[])object);
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("encoding error in getInstance: " + exception.toString());
            }
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + object.getClass().getName());
    }

    public static DERT61String getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        DERObject dERObject = aSN1TaggedObject.getObject();
        if (bl || dERObject instanceof DERT61String) {
            return DERT61String.getInstance(dERObject);
        }
        return new DERT61String(ASN1OctetString.getInstance(dERObject).getOctets());
    }

    public DERT61String(byte[] byArray) {
        this.string = Arrays.clone(byArray);
    }

    public DERT61String(String string) {
        this.string = Strings.toByteArray(string);
    }

    @Override
    public String getString() {
        return Strings.fromByteArray((byte[])this.string);
    }

    public String toString() {
        return this.getString();
    }

    @Override
    boolean isConstructed() {
        return false;
    }

    @Override
    int encodedLength() {
        return 1 + StreamUtil.calculateBodyLength(((String)this.string).length) + ((String)this.string).length;
    }

    @Override
    void encode(ASN1OutputStream aSN1OutputStream, boolean bl) throws IOException {
        aSN1OutputStream.writeEncoded(bl, 20, (byte[])this.string);
    }

    public byte[] getOctets() {
        return Arrays.clone((byte[])this.string);
    }

    @Override
    boolean asn1Equals(ASN1Primitive aSN1Primitive) {
        if (!(aSN1Primitive instanceof DERT61String)) {
            return false;
        }
        return Arrays.areEqual((byte[])this.string, (byte[])((DERT61String)((Object)aSN1Primitive)).string);
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode((byte[])this.string);
    }
}

