/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.renderer;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import de.gematik.rbellogger.converter.RbelValueShader;
import de.gematik.rbellogger.data.RbelBearerTokenElement;
import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.RbelHttpRequest;
import de.gematik.rbellogger.data.RbelHttpResponse;
import de.gematik.rbellogger.data.RbelJsonElement;
import de.gematik.rbellogger.data.RbelJweElement;
import de.gematik.rbellogger.data.RbelJweEncryptionInfo;
import de.gematik.rbellogger.data.RbelJwtElement;
import de.gematik.rbellogger.data.RbelJwtSignature;
import de.gematik.rbellogger.data.RbelMapElement;
import de.gematik.rbellogger.data.RbelNullElement;
import de.gematik.rbellogger.data.RbelPathElement;
import de.gematik.rbellogger.data.RbelStringElement;
import j2html.TagCreator;
import j2html.tags.ContainerTag;
import j2html.tags.DomContent;
import j2html.tags.EmptyTag;
import j2html.tags.UnescapedText;
import java.nio.charset.StandardCharsets;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.io.IOUtils;

public class RbelHtmlRenderer {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final String CLS_HEADER = "is-primary";
    private static final String CLS_BODY = "is-info";
    private static final String CLS_PKIOK = "is-success";
    private static final String CLS_PKINOK = "is-primary";
    private static final Map<String, String> elementIndices = new HashMap<String, String>();
    private final Map<Class<? extends RbelElement>, BiFunction<RbelElement, Optional<String>, ContainerTag>> htmlRenderer = new HashMap<Class<? extends RbelElement>, BiFunction<RbelElement, Optional<String>, ContainerTag>>();
    private final RbelValueShader rbelValueShader;
    private String currentKey;
    private String title = "RBelLogger";
    private String subTitle = "<p>The [R]everse [B]ridle [E]vent [L]ogger pays tribute to the fact that many agile projects' specifications, alas somewhat complete, lack specificality. Using PoCs most of the time does not resolve this as the code is not well enough documented and communication between nodes is not observable or logged in a well enough readable manner.</p> <p>This is where the RBeL Logger comes into play.</p> <p>Attaching it to a network, RestAssured or Wiremock interface or instructing it to read from a recorded PCAP file, produces this shiny communication log supporting Plain HTTP, JSON, JWT and even JWE!</p>";

    public RbelHtmlRenderer() {
        this(new RbelValueShader());
    }

    private static EmptyTag link2CSS(String url) {
        return (EmptyTag)((EmptyTag)TagCreator.link().attr("rel", "stylesheet")).withHref(url);
    }

    private static ContainerTag ancestorTitle() {
        return (ContainerTag)TagCreator.div().withClass("tile is-ancestor");
    }

    private static ContainerTag vertParentTitle() {
        return (ContainerTag)TagCreator.div().withClass("tile is-vertical is-parent");
    }

    private static ContainerTag childBoxNotifTitle(String addClasses) {
        return (ContainerTag)TagCreator.div().withClass("tile is-child box notification " + addClasses);
    }

    private static ContainerTag t1ms(String text) {
        return (ContainerTag)TagCreator.h1(text).withClass("is-family-monospace title");
    }

    private static ContainerTag t2(String text) {
        return (ContainerTag)TagCreator.h2(text).withClass("title");
    }

    public static String render(List<RbelElement> elements) {
        return RbelHtmlRenderer.render(elements, new RbelValueShader());
    }

    public static String render(List<RbelElement> elements, RbelValueShader valueShader) {
        return new RbelHtmlRenderer(valueShader).performRendering(elements);
    }

    public String doRender(List<RbelElement> elements) {
        return this.performRendering(elements);
    }

    private static DomContent renderMenu(List<RbelElement> elements) {
        return ((ContainerTag)TagCreator.div().withClass(" column is-one-fifth menu is-size-4 sidebar")).with(new DomContent[]{((ContainerTag)((ContainerTag)TagCreator.a(new DomContent[]{TagCreator.i().withClass("fas fa-angle-double-up")}).withId("collapse-all")).withHref("#")).withClass("is-pulled-right mr-3"), ((ContainerTag)((ContainerTag)TagCreator.a(new DomContent[]{TagCreator.i().withClass("fas fa-angle-double-down")}).withId("expand-all")).withHref("#")).withClass("is-pulled-right mr-3"), TagCreator.h2("Flow").withClass("mb-4 ml-2"), ((ContainerTag)TagCreator.div().withClass("ml-5")).with(elements.stream().map(RbelHtmlRenderer::menuTab).collect(Collectors.toList()))});
    }

    private static void initializeElementIndexMap(List<RbelElement> elements) {
        IntStream.range(0, elements.size()).forEach(i -> elementIndices.put(((RbelElement)elements.get(i)).getUUID(), String.valueOf(i + 1)));
    }

    private static DomContent menuTab(RbelElement element) {
        if (element instanceof RbelHttpRequest) {
            return ((ContainerTag)TagCreator.div().withClass("ml-5")).with((DomContent)((ContainerTag)((ContainerTag)TagCreator.a().withHref("#" + element.getUUID())).withClass("mt-3 is-block")).with(new DomContent[]{TagCreator.div(new DomContent[]{TagCreator.span(elementIndices.get(element.getUUID())).withClass("tag is-info is-light mr-1"), TagCreator.i().withClass("fas fa-share"), TagCreator.text(" REQUEST")}).withClass("menu-label mb-1 has-text-link"), ((ContainerTag)TagCreator.div(((RbelHttpRequest)element).getMethod() + "  " + ((RbelHttpRequest)element).getPath().getOriginalUrl()).attr("style", "text-overflow: ellipsis;overflow: hidden;")).withClass("is-size-6 ml-3")}));
        }
        return ((ContainerTag)TagCreator.a(new DomContent[]{TagCreator.span(elementIndices.get(element.getUUID())).withClass("tag is-info is-light mr-1"), TagCreator.i().withClass("fas fa-reply"), TagCreator.text(" RESPONSE")}).withHref("#" + element.getUUID())).withClass("menu-label ml-5 mt-3 is-block has-text-success");
    }

    private JsonElement shadeJson(JsonElement input, Optional<String> key) {
        if (input.isJsonPrimitive()) {
            if (key.isPresent() && this.rbelValueShader.shouldConvert(key.get())) {
                return new JsonPrimitive(this.rbelValueShader.convert(key.get(), input.getAsJsonPrimitive().getAsString()));
            }
            return input;
        }
        if (input.isJsonObject()) {
            JsonObject output = new JsonObject();
            for (Map.Entry<String, JsonElement> element : input.getAsJsonObject().entrySet()) {
                output.add(element.getKey(), this.shadeJson(element.getValue(), Optional.of(element.getKey())));
            }
            return output;
        }
        if (input.isJsonArray()) {
            JsonArray output = new JsonArray();
            for (JsonElement element : input.getAsJsonArray()) {
                output.add(this.shadeJson(element, Optional.empty()));
            }
            return output;
        }
        if (input.isJsonNull()) {
            return input;
        }
        throw new RuntimeException("Unshadeable JSON-Type " + input.getClass().getSimpleName());
    }

    private String performElementToTextConversion(RbelElement el, Optional<String> key) {
        return key.map(keyValue -> this.rbelValueShader.convert((String)keyValue, el.getContent())).orElse(el.getContent()).replace("\n", "<br/>");
    }

    private ContainerTag collapsibleCard(ContainerTag title, ContainerTag body) {
        return ((ContainerTag)TagCreator.div().withClass("container page-break mx-3 my-6")).with((DomContent)((ContainerTag)TagCreator.div().withClass("card full-width")).with(((ContainerTag)TagCreator.header().withClass("card-header")).with((DomContent)((ContainerTag)TagCreator.div().withClass("card-header-title card-toggle")).with((DomContent)title)), ((ContainerTag)TagCreator.div().withClass("card-content")).with((DomContent)TagCreator.div().with((DomContent)body))));
    }

    private ContainerTag renderUrlContent(RbelElement el) {
        String originalUrl = ((RbelPathElement)el).getOriginalUrl();
        return TagCreator.div(new UnescapedText(originalUrl.replace("?", "?<br/>").replace("&", "<br/>&")));
    }

    private List<ContainerTag> convertNested(RbelElement el) {
        return el.traverseAndReturnNestedMembers().entrySet().stream().filter(child -> !(child.getValue() instanceof RbelStringElement)).map(child -> ((ContainerTag)TagCreator.article().withClass("tile is-ancestor notification is-warning my-6")).with(new DomContent[]{((ContainerTag)TagCreator.h2((String)child.getKey()).withClass("title")).withStyle("word-break: keep-all;"), TagCreator.div(new DomContent[]{this.convert((RbelElement)child.getValue(), Optional.ofNullable((String)child.getKey())).withClass("notification tile is-child box")}).withClass("notification tile is-parent")})).collect(Collectors.toList());
    }

    private synchronized String performRendering(List<RbelElement> elements) {
        RbelHtmlRenderer.initializeElementIndexMap(elements);
        return TagCreator.document(TagCreator.html(TagCreator.head(new DomContent[]{TagCreator.meta().attr("charset", "utf-8"), ((EmptyTag)TagCreator.meta().attr("name", "viewport")).attr("content", "width=device-width, initial-scale=1"), TagCreator.title().withText("Rbel Flow"), RbelHtmlRenderer.link2CSS("https://cdn.jsdelivr.net/npm/bulma@0.9.1/css/bulma.min.css"), RbelHtmlRenderer.link2CSS("https://jenil.github.io/bulmaswatch/simplex/bulmaswatch.min.css"), RbelHtmlRenderer.link2CSS("https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.2/css/all.min.css"), TagCreator.tag("style").with((DomContent)new UnescapedText(IOUtils.resourceToString("/rbel.css", StandardCharsets.UTF_8)))}), TagCreator.body().with((DomContent)((ContainerTag)TagCreator.section().withClass("main-content")).with(((ContainerTag)TagCreator.section().withClass("columns is-vcentered header")).with(((ContainerTag)TagCreator.div().withClass("column is-one-fifth is-inline-block logo")).with((DomContent)TagCreator.img().withSrc("https://colinbeavan.com/wp-content/uploads/2018/05/backwards.jpg")), ((ContainerTag)TagCreator.div().withClass("is-inline-block")).with(new DomContent[]{TagCreator.h1(this.title).withClass("is-size-1 mb-3"), TagCreator.div(new UnescapedText(this.subTitle)).withClass("is-size-6 is-italic is-clearfix")})), ((ContainerTag)TagCreator.section().withClass("columns is-fullheight")).with(RbelHtmlRenderer.renderMenu(elements), ((ContainerTag)TagCreator.div().withClass("column m-6")).with(new DomContent[]{TagCreator.div("Created " + DateTimeFormatter.RFC_1123_DATE_TIME.format(ZonedDateTime.now())).withClass("is-italic is-size-6 is-pulled-right mr-6"), TagCreator.div().with(elements.stream().map(el -> this.convert((RbelElement)el, Optional.empty())).collect(Collectors.toList())), TagCreator.div("Created " + DateTimeFormatter.RFC_1123_DATE_TIME.format(ZonedDateTime.now())).withClass("is-italic is-size-6 is-pulled-right mr-6")})))).with((DomContent)TagCreator.script().with((DomContent)new UnescapedText(IOUtils.resourceToString("/rbel.js", StandardCharsets.UTF_8))))));
    }

    private ContainerTag convert(RbelElement element, Optional<String> key) {
        if (this.htmlRenderer.containsKey(element.getClass())) {
            return this.htmlRenderer.get(element.getClass()).apply(element, key);
        }
        return TagCreator.p().withText(element.getClass().getSimpleName() + "<br/> " + element.getContent());
    }

    private RbelHtmlRenderer(RbelValueShader rbelValueShader) {
        this.htmlRenderer.put(RbelHttpRequest.class, (el, key) -> this.collapsibleCard((ContainerTag)TagCreator.div().with(new DomContent[]{TagCreator.a().withName(el.getUUID()), TagCreator.i().withClass("fas fa-toggle-on toggle-icon is-pulled-right mr-3 is-size-3 has-text-link"), TagCreator.h1(new DomContent[]{TagCreator.span(elementIndices.get(el.getUUID())).withClass("tag is-info is-light mr-3 is-size-3"), TagCreator.i().withClass("fas fa-share"), TagCreator.text(" " + ((RbelHttpRequest)el).getMethod() + " Request")}).withClass("title has-text-link"), ((ContainerTag)TagCreator.div().withClass("container is-widescreen")).with((DomContent)TagCreator.div(this.convert(((RbelHttpRequest)el).getPath(), null)).withClass("is-family-monospace title is-size-4"))}).withClass("full-width"), RbelHtmlRenderer.ancestorTitle().with((DomContent)((ContainerTag)TagCreator.div().withClass("tile is-parent is-vertical ")).with(RbelHtmlRenderer.childBoxNotifTitle("is-primary").with(RbelHtmlRenderer.t2("REQ Headers"), this.convert(((RbelHttpRequest)el).getHeader(), Optional.empty())), RbelHtmlRenderer.childBoxNotifTitle(CLS_BODY).with(RbelHtmlRenderer.t2("REQ Body"), this.convert(((RbelHttpRequest)el).getBody(), Optional.empty()))))));
        this.htmlRenderer.put(RbelHttpResponse.class, (el, key) -> this.collapsibleCard((ContainerTag)TagCreator.div().with(new DomContent[]{TagCreator.a().withName(el.getUUID()), TagCreator.i().withClass("fas fa-toggle-on toggle-icon is-pulled-right mr-3 is-size-3 has-text-success"), TagCreator.h1(new DomContent[]{TagCreator.span(elementIndices.get(el.getUUID())).withClass("tag is-info is-light mr-3 is-size-3"), TagCreator.i().withClass("fas fa-reply"), TagCreator.text(" Response")}).withClass("title has-text-success")}).withClass("full-width"), ((ContainerTag)TagCreator.div().withClass("container is-widescreen")).with(RbelHtmlRenderer.t1ms("" + ((RbelHttpResponse)el).getResponseCode()), RbelHtmlRenderer.ancestorTitle().with((DomContent)((ContainerTag)TagCreator.div().withClass("tile is-parent is-vertical ")).with(RbelHtmlRenderer.childBoxNotifTitle("is-primary").with(RbelHtmlRenderer.t2("RES Headers"), this.convert(((RbelHttpResponse)el).getHeader(), Optional.empty())), ((ContainerTag)TagCreator.div().withClass("tile is-child is-vertical box notification is-info")).with(RbelHtmlRenderer.t2("RES Body"), this.convert(((RbelHttpResponse)el).getBody(), Optional.empty())))))));
        this.htmlRenderer.put(RbelMapElement.class, (el, key) -> ((ContainerTag)TagCreator.table().withClass("table")).with(TagCreator.thead(TagCreator.tr(TagCreator.th("name"), TagCreator.th("value"))), TagCreator.tbody().with(((RbelMapElement)el).getElementMap().entrySet().stream().map(entry -> TagCreator.tr(TagCreator.td(TagCreator.pre((String)entry.getKey())), TagCreator.td(new DomContent[]{TagCreator.pre().with((DomContent)this.convert((RbelElement)entry.getValue(), Optional.ofNullable((String)entry.getKey()))).withClass("value")}))).collect(Collectors.toList()))));
        this.htmlRenderer.put(RbelJsonElement.class, (el, key) -> RbelHtmlRenderer.ancestorTitle().with((DomContent)RbelHtmlRenderer.vertParentTitle().with((DomContent)((ContainerTag)TagCreator.div().withClass("tile is-child ")).with((DomContent)TagCreator.pre(GSON.toJson(this.shadeJson(JsonParser.parseString(((RbelJsonElement)el).getCompleteJsonString()), Optional.empty()))).withClass("json")).with(this.convertNested((RbelElement)el)))));
        this.htmlRenderer.put(RbelJwtElement.class, (el, key) -> TagCreator.div(RbelHtmlRenderer.t1ms("JWT"), RbelHtmlRenderer.ancestorTitle().with((DomContent)RbelHtmlRenderer.vertParentTitle().with(RbelHtmlRenderer.childBoxNotifTitle("is-primary").with(RbelHtmlRenderer.t2("Headers"), this.convert(((RbelJwtElement)el).getHeader(), Optional.empty())), RbelHtmlRenderer.childBoxNotifTitle(CLS_BODY).with(RbelHtmlRenderer.t2("Body"), this.convert(((RbelJwtElement)el).getBody(), Optional.empty())), this.convert(((RbelJwtElement)el).getSignature(), Optional.empty())))));
        this.htmlRenderer.put(RbelJweElement.class, (el, key) -> TagCreator.div(RbelHtmlRenderer.t1ms("JWE"), RbelHtmlRenderer.ancestorTitle().with((DomContent)RbelHtmlRenderer.vertParentTitle().with(RbelHtmlRenderer.childBoxNotifTitle("is-primary").with(RbelHtmlRenderer.t2("Headers"), this.convert(((RbelJweElement)el).getHeader(), Optional.empty())), RbelHtmlRenderer.childBoxNotifTitle(CLS_BODY).with(RbelHtmlRenderer.t2("Body"), this.convert(((RbelJweElement)el).getBody(), Optional.empty())), this.convert(((RbelJweElement)el).getEncryptionInfo(), Optional.empty())))));
        this.htmlRenderer.put(RbelJwtSignature.class, (el, key) -> RbelHtmlRenderer.childBoxNotifTitle(((RbelJwtSignature)el).isValid() ? CLS_PKIOK : "is-primary").with(RbelHtmlRenderer.t2("Signature"), TagCreator.p().withText("Was verified using Key ").with((DomContent)TagCreator.b(((RbelJwtSignature)el).getVerifiedUsing()))));
        this.htmlRenderer.put(RbelJweEncryptionInfo.class, (el, key) -> RbelHtmlRenderer.childBoxNotifTitle(((RbelJweEncryptionInfo)el).isWasDecryptable() ? CLS_PKIOK : "is-primary").with(RbelHtmlRenderer.t2("Encryption info"), TagCreator.p().withText("Was decrypted using Key ").with((DomContent)TagCreator.b(((RbelJweEncryptionInfo)el).getDecryptedUsingKeyWithId()))));
        this.htmlRenderer.put(RbelNullElement.class, (el, key) -> TagCreator.div("- empty -"));
        this.htmlRenderer.put(RbelPathElement.class, (el, key) -> {
            ContainerTag urlContent = this.renderUrlContent((RbelElement)el);
            if (el.getChildElements().isEmpty()) {
                return TagCreator.div().with((DomContent)urlContent);
            }
            return RbelHtmlRenderer.ancestorTitle().with((DomContent)RbelHtmlRenderer.vertParentTitle().with((DomContent)((ContainerTag)TagCreator.div().withClass("tile is-child")).with((DomContent)urlContent).with(this.convertNested((RbelElement)el))));
        });
        this.htmlRenderer.put(RbelBearerTokenElement.class, (el, key) -> {
            ContainerTag tokenContent = TagCreator.div(TagCreator.text(this.performElementToTextConversion((RbelElement)el, (Optional<String>)key)));
            if (((RbelBearerTokenElement)el).getBearerToken() instanceof RbelStringElement) {
                return tokenContent;
            }
            return RbelHtmlRenderer.ancestorTitle().with((DomContent)RbelHtmlRenderer.vertParentTitle().with((DomContent)((ContainerTag)TagCreator.div().withClass("tile is-child")).with((DomContent)tokenContent).with(this.convertNested((RbelElement)el))));
        });
        this.htmlRenderer.put(RbelStringElement.class, (el, key) -> TagCreator.div(TagCreator.text(this.performElementToTextConversion((RbelElement)el, (Optional<String>)key))));
        this.rbelValueShader = rbelValueShader;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setSubTitle(String subTitle) {
        this.subTitle = subTitle;
    }
}

