/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.data;

import de.gematik.rbellogger.converter.RbelConverter;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.platform.commons.util.ReflectionUtils;

public abstract class RbelElement {
    private final String uuid = UUID.randomUUID().toString();

    public abstract String getContent();

    public boolean isNestedBoundary() {
        return true;
    }

    public Map<String, RbelElement> getChildElements() {
        Map<String, RbelElement> collect = Stream.of(this.getClass().getDeclaredFields()).filter(f -> RbelElement.class.isAssignableFrom(f.getType())).collect(Collectors.toMap(Field::getName, field -> {
            try {
                return (RbelElement)ReflectionUtils.tryToReadFieldValue(field, this).get();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }));
        return collect;
    }

    public void triggerPostConversionListener(RbelConverter context) {
        context.triggerPostConversionListenerFor(this);
    }

    public Map<String, RbelElement> traverseAndReturnNestedMembers() {
        return this.traverseAndReturnNestedMembers(this.getClass());
    }

    public Map<String, RbelElement> traverseAndReturnNestedMembers(Class<? extends RbelElement> identityClass) {
        HashMap<String, RbelElement> result = new HashMap<String, RbelElement>();
        for (Map.Entry<String, RbelElement> child : this.getChildElements().entrySet()) {
            for (Map.Entry<String, RbelElement> grandchild : child.getValue().traverseAndReturnNestedMembersWithStopAtNextBoundary(identityClass).entrySet()) {
                if (grandchild.getKey().isEmpty()) {
                    result.put(child.getKey(), grandchild.getValue());
                    continue;
                }
                result.put(child.getKey() + "." + grandchild.getKey(), grandchild.getValue());
            }
        }
        return result;
    }

    public Map<String, RbelElement> traverseAndReturnNestedMembersWithStopAtNextBoundary(Class<? extends RbelElement> identityClass) {
        if (this.isNestedBoundary() && !this.getClass().isAssignableFrom(identityClass)) {
            return Map.of("", this);
        }
        return this.traverseAndReturnNestedMembers(identityClass);
    }

    public String getUUID() {
        return this.uuid;
    }
}

