/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.converter;

import de.gematik.rbellogger.data.RbelElement;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.function.BiConsumer;

public class RbelValueShader {
    private final Map<String, String> formatStrings = new HashMap<String, String>();

    public RbelValueShader() {
    }

    public void loadFromResource(String fileOrResource) {
        Properties p = new Properties();
        if (fileOrResource.startsWith("classpath:")) {
            try (InputStream is = this.getClass().getResourceAsStream(fileOrResource.substring("classpath:".length()));){
                p.load(is);
            }
        }
        try (FileInputStream fis = new FileInputStream(fileOrResource);){
            p.load(fis);
        }
        p.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> this.formatStrings.put(key.toString(), value.toString())));
    }

    public RbelValueShader(Map<String, String> formatStrings) {
        this.formatStrings.putAll(formatStrings);
    }

    public boolean shouldConvert(String attributeName) {
        return this.formatStrings.containsKey(attributeName);
    }

    public String convert(String attributeName, Object value) {
        if (this.formatStrings.containsKey(attributeName)) {
            return String.format(this.formatStrings.get(attributeName), this.toStringValue(value));
        }
        return this.toStringValue(value);
    }

    private String toStringValue(Object value) {
        if (value instanceof RbelElement) {
            return ((RbelElement)value).getContent();
        }
        return value.toString();
    }
}

