/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.converter;

import de.gematik.rbellogger.converter.RbelConverter;
import de.gematik.rbellogger.converter.RbelConverterPlugin;
import de.gematik.rbellogger.converter.brainpool.BrainpoolCurves;
import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.RbelJwtElement;
import de.gematik.rbellogger.data.RbelJwtSignature;
import java.security.Key;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Optional;
import org.jose4j.json.JsonUtil;
import org.jose4j.jws.JsonWebSignature;
import org.jose4j.lang.JoseException;

public class RbelJwtConverter
implements RbelConverterPlugin {
    @Override
    public boolean canConvertElement(RbelElement rbel, RbelConverter context) {
        try {
            JsonWebSignature jsonWebSignature = this.initializeJws(rbel);
            JsonUtil.parseJson(jsonWebSignature.getHeaders().getFullHeaderAsJsonString());
            return true;
        }
        catch (JoseException e) {
            return false;
        }
    }

    @Override
    public RbelElement convertElement(RbelElement rbel, RbelConverter context) {
        JsonWebSignature jsonWebSignature = this.initializeJws(rbel);
        RbelElement headerElement = context.convertMessage(jsonWebSignature.getHeaders().getFullHeaderAsJsonString());
        RbelElement bodyElement = context.convertMessage(jsonWebSignature.getUnverifiedPayload());
        RbelJwtSignature signature = context.getKeyIdToKeyDatabase().entrySet().stream().map(entry -> this.verifySig(jsonWebSignature, (Key)entry.getValue(), (String)entry.getKey())).filter(Optional::isPresent).map(Optional::get).findAny().or(() -> this.tryToGetKeyFromX5cHeaderClaim(jsonWebSignature).map(key -> this.verifySig(jsonWebSignature, (Key)key, "x5c-header certificate")).filter(Optional::isPresent).map(Optional::get)).orElseGet(() -> new RbelJwtSignature(false, null));
        return new RbelJwtElement(headerElement, bodyElement, signature);
    }

    private Optional<PublicKey> tryToGetKeyFromX5cHeaderClaim(JsonWebSignature jsonWebSignature) {
        return Optional.ofNullable(jsonWebSignature.getCertificateChainHeaderValue()).map(list -> (X509Certificate)list.get(0)).map(Certificate::getPublicKey);
    }

    private JsonWebSignature initializeJws(RbelElement rbel) {
        JsonWebSignature jsonWebSignature = new JsonWebSignature();
        jsonWebSignature.setCompactSerialization(rbel.getContent());
        return jsonWebSignature;
    }

    private Optional<RbelJwtSignature> verifySig(JsonWebSignature jsonWebSignature, Key key, String keyId) {
        try {
            jsonWebSignature.setKey(key);
            this.tryToGetKeyFromX5cHeaderClaim(jsonWebSignature);
            if (jsonWebSignature.verifySignature()) {
                return Optional.of(new RbelJwtSignature(true, keyId));
            }
            return Optional.empty();
        }
        catch (JoseException e) {
            return Optional.empty();
        }
    }

    static {
        BrainpoolCurves.init();
    }
}

