/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.converter;

import de.gematik.rbellogger.converter.RbelConverter;
import de.gematik.rbellogger.converter.RbelConverterPlugin;
import de.gematik.rbellogger.converter.brainpool.BrainpoolCurves;
import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.RbelJweElement;
import de.gematik.rbellogger.data.RbelJweEncryptionInfo;
import de.gematik.rbellogger.data.RbelJwtSignature;
import de.gematik.rbellogger.data.RbelStringElement;
import java.security.Key;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.tuple.Pair;
import org.jose4j.jwa.AlgorithmConstraints;
import org.jose4j.jwe.JsonWebEncryption;
import org.jose4j.jws.JsonWebSignature;
import org.jose4j.lang.JoseException;

public class RbelJweConverter
implements RbelConverterPlugin {
    @Override
    public boolean canConvertElement(RbelElement rbel, RbelConverter context) {
        return this.initializeJwe(rbel).isPresent();
    }

    @Override
    public RbelElement convertElement(RbelElement rbel, RbelConverter context) {
        JsonWebEncryption jwe = this.initializeJwe(rbel).get();
        Optional<Pair<String, String>> correctKeyAndPayload = this.findCorrectKeyAndReturnPayload(context, jwe);
        if (correctKeyAndPayload.isEmpty()) {
            return new RbelJweElement(context.convertMessage(jwe.getHeaders().getFullHeaderAsJsonString()), new RbelStringElement("<Encrypted Payload>"), new RbelJweEncryptionInfo(false, null));
        }
        return new RbelJweElement(context.convertMessage(jwe.getHeaders().getFullHeaderAsJsonString()), context.convertMessage(correctKeyAndPayload.get().getValue()), new RbelJweEncryptionInfo(true, correctKeyAndPayload.get().getKey()));
    }

    private Optional<Pair<String, String>> findCorrectKeyAndReturnPayload(RbelConverter context, JsonWebEncryption jwe) {
        for (Map.Entry<String, Key> keyEntry : context.getKeyIdToKeyDatabase().entrySet()) {
            try {
                jwe.setKey(keyEntry.getValue());
                return Optional.of(Pair.of(keyEntry.getKey(), jwe.getPayload()));
            }
            catch (Exception e) {
            }
        }
        return Optional.empty();
    }

    private Optional<PublicKey> tryToGetKeyFromX5cHeaderClaim(JsonWebSignature jsonWebSignature) {
        return Optional.ofNullable(jsonWebSignature.getCertificateChainHeaderValue()).map(list -> (X509Certificate)list.get(0)).map(Certificate::getPublicKey);
    }

    private Optional<JsonWebEncryption> initializeJwe(RbelElement rbel) {
        JsonWebEncryption receiverJwe = new JsonWebEncryption();
        receiverJwe.setDoKeyValidation(false);
        receiverJwe.setAlgorithmConstraints(AlgorithmConstraints.NO_CONSTRAINTS);
        try {
            receiverJwe.setCompactSerialization(rbel.getContent());
            receiverJwe.getHeaders();
            return Optional.ofNullable(receiverJwe);
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    private Optional<RbelJwtSignature> verifySig(JsonWebSignature jsonWebSignature, Key key, String keyId) {
        try {
            jsonWebSignature.setKey(key);
            this.tryToGetKeyFromX5cHeaderClaim(jsonWebSignature);
            return Optional.of(new RbelJwtSignature(jsonWebSignature.verifySignature(), keyId));
        }
        catch (JoseException e) {
            return Optional.empty();
        }
    }

    static {
        BrainpoolCurves.init();
    }
}

