/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.converter;

import de.gematik.rbellogger.converter.RbelConverter;
import de.gematik.rbellogger.converter.RbelCurlHttpMessageConverter;
import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.RbelHttpRequest;
import de.gematik.rbellogger.data.RbelMapElement;
import de.gematik.rbellogger.data.RbelPathElement;
import de.gematik.rbellogger.data.RbelStringElement;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.tuple.Pair;

public class RbelHttpRequestConverter
extends RbelCurlHttpMessageConverter {
    @Override
    public boolean canConvertElement(RbelElement rbel, RbelConverter context) {
        return rbel instanceof RbelStringElement && (rbel.getContent().startsWith("GET") || rbel.getContent().startsWith("POST") || rbel.getContent().startsWith("PUT") || rbel.getContent().startsWith("DELETE"));
    }

    @Override
    public RbelElement convertElement(RbelElement rbel, RbelConverter context) {
        int space = rbel.getContent().indexOf(" ");
        int space2 = rbel.getContent().indexOf(" ", space + 1);
        String method = rbel.getContent().substring(0, space);
        String path = rbel.getContent().substring(space + 1, space2);
        String[] lines = rbel.getContent().split(RbelHttpRequestConverter.findLineSeparator(rbel.getContent()));
        int bodySeparator = Arrays.asList(lines).indexOf("");
        Map<String, RbelElement> headerMap = Arrays.stream(lines).limit(bodySeparator == -1 ? (long)lines.length : (long)bodySeparator).filter(line -> !line.isEmpty() && !line.startsWith(method)).map(line -> this.parseStringToKeyValuePair((String)line, context)).collect(Collectors.toMap(AbstractMap.SimpleImmutableEntry::getKey, AbstractMap.SimpleImmutableEntry::getValue));
        RbelMapElement headers = new RbelMapElement(headerMap);
        String bodyStr = bodySeparator == -1 ? "" : lines[lines.length - 1];
        RbelElement pathElement = context.convertMessage(path);
        if (!(pathElement instanceof RbelPathElement)) {
            throw new RuntimeException("Encountered ill-formatted path: " + path);
        }
        return new RbelHttpRequest(headers, context.convertMessage(this.convertBodyToRbelElement(bodyStr, headerMap, context)), method, (RbelPathElement)pathElement);
    }

    private RbelElement convertBodyToRbelElement(String bodyStr, Map<String, RbelElement> headerMap, RbelConverter context) {
        if (headerMap.containsKey("Content-Type") && headerMap.get("Content-Type").getContent().startsWith("application/x-www-form-urlencoded")) {
            return new RbelMapElement(Stream.of(bodyStr.split("&")).map(param -> param.split("=")).filter(params -> ((String[])params).length == 2).map(paramList -> Pair.of(paramList[0], context.convertMessage(paramList[1]))).collect(Collectors.toMap(Pair::getKey, Pair::getValue)));
        }
        return new RbelStringElement(bodyStr);
    }
}

