/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.converter;

import de.gematik.rbellogger.converter.RbelBearerTokenConverter;
import de.gematik.rbellogger.converter.RbelConfiguration;
import de.gematik.rbellogger.converter.RbelConverterPlugin;
import de.gematik.rbellogger.converter.RbelCurlHttpMessageConverter;
import de.gematik.rbellogger.converter.RbelHttpRequestConverter;
import de.gematik.rbellogger.converter.RbelJsonConverter;
import de.gematik.rbellogger.converter.RbelJweConverter;
import de.gematik.rbellogger.converter.RbelJwtConverter;
import de.gematik.rbellogger.converter.RbelPathConverter;
import de.gematik.rbellogger.converter.listener.RbelX5cKeyReader;
import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.RbelHttpMessage;
import de.gematik.rbellogger.data.RbelMapElement;
import de.gematik.rbellogger.data.RbelStringElement;
import java.security.Key;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

public class RbelConverter {
    private final List<RbelElement> messageHistory = new ArrayList<RbelElement>();
    private final Map<String, Key> keyIdToKeyDatabase = new HashMap<String, Key>();
    private final Map<Class<? extends RbelElement>, List<BiConsumer<RbelElement, RbelConverter>>> postConversionListener = new HashMap<Class<? extends RbelElement>, List<BiConsumer<RbelElement, RbelConverter>>>();
    private final List<RbelConverterPlugin> converterPlugins = new ArrayList<RbelBearerTokenConverter>(List.of(new RbelCurlHttpMessageConverter(), new RbelHttpRequestConverter(), new RbelJwtConverter(), new RbelJsonConverter(), new RbelJweConverter(), new RbelPathConverter(), new RbelBearerTokenConverter()));

    public static RbelConverter build() {
        return RbelConverter.build(new RbelConfiguration());
    }

    public static RbelConverter build(RbelConfiguration configuration) {
        RbelConverter rbelConverter = new RbelConverter();
        rbelConverter.registerListener(RbelMapElement.class, new RbelX5cKeyReader());
        if (configuration.getPostConversionListener() != null) {
            configuration.getPostConversionListener().entrySet().stream().forEach(entry -> ((List)entry.getValue()).stream().forEach(listener -> rbelConverter.registerListener((Class)entry.getKey(), (BiConsumer<RbelElement, RbelConverter>)listener)));
            rbelConverter.postConversionListener.putAll(configuration.getPostConversionListener());
        }
        for (Consumer<RbelConverter> initializer : configuration.getInitializers()) {
            initializer.accept(rbelConverter);
        }
        rbelConverter.getKeyIdToKeyDatabase().putAll(configuration.getKeys());
        return rbelConverter;
    }

    public RbelElement convertMessage(String input) {
        return this.convertMessage(new RbelStringElement(input));
    }

    public RbelElement convertMessage(RbelElement input) {
        RbelElement result = this.converterPlugins.stream().filter(plugin -> plugin.canConvertElement(input, this)).map(plugin -> plugin.convertElement(input, this)).findFirst().orElse(input);
        if (result instanceof RbelHttpMessage) {
            this.messageHistory.add(result);
        }
        result.triggerPostConversionListener(this);
        return result;
    }

    public void registerListener(Class<? extends RbelElement> clazz, BiConsumer<RbelElement, RbelConverter> listener) {
        this.postConversionListener.computeIfAbsent(clazz, key -> new ArrayList()).add(listener);
    }

    public void triggerPostConversionListenerFor(RbelElement element) {
        if (this.postConversionListener.containsKey(element.getClass())) {
            this.postConversionListener.get(element.getClass()).forEach(consumer -> consumer.accept(element, this));
        }
    }

    private RbelConverter() {
    }

    public List<RbelElement> getMessageHistory() {
        return this.messageHistory;
    }

    public Map<String, Key> getKeyIdToKeyDatabase() {
        return this.keyIdToKeyDatabase;
    }

    public Map<Class<? extends RbelElement>, List<BiConsumer<RbelElement, RbelConverter>>> getPostConversionListener() {
        return this.postConversionListener;
    }

    public List<RbelConverterPlugin> getConverterPlugins() {
        return this.converterPlugins;
    }
}

