/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.converter;

import de.gematik.rbellogger.converter.RbelConverter;
import de.gematik.rbellogger.data.RbelElement;
import java.security.Key;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

public class RbelConfiguration {
    private Map<Class<? extends RbelElement>, List<BiConsumer<RbelElement, RbelConverter>>> postConversionListener = new HashMap<Class<? extends RbelElement>, List<BiConsumer<RbelElement, RbelConverter>>>();
    private List<Consumer<RbelConverter>> initializers = new ArrayList<Consumer<RbelConverter>>();
    private Map<String, Key> keys = new HashMap<String, Key>();

    public RbelConfiguration addPostConversionListener(Class<? extends RbelElement> clazz, BiConsumer<RbelElement, RbelConverter> consumer) {
        if (!this.postConversionListener.containsKey(clazz)) {
            this.postConversionListener.put(clazz, new ArrayList());
        }
        this.postConversionListener.get(clazz).add(consumer);
        return this;
    }

    public RbelConfiguration addInitializer(Consumer<RbelConverter> initializer) {
        this.initializers.add(initializer);
        return this;
    }

    public RbelConfiguration addKey(String keyId, Key key) {
        this.keys.put(keyId, key);
        return this;
    }

    public Map<Class<? extends RbelElement>, List<BiConsumer<RbelElement, RbelConverter>>> getPostConversionListener() {
        return this.postConversionListener;
    }

    public List<Consumer<RbelConverter>> getInitializers() {
        return this.initializers;
    }

    public Map<String, Key> getKeys() {
        return this.keys;
    }

    public void setPostConversionListener(Map<Class<? extends RbelElement>, List<BiConsumer<RbelElement, RbelConverter>>> postConversionListener) {
        this.postConversionListener = postConversionListener;
    }

    public void setInitializers(List<Consumer<RbelConverter>> initializers) {
        this.initializers = initializers;
    }

    public void setKeys(Map<String, Key> keys) {
        this.keys = keys;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RbelConfiguration)) {
            return false;
        }
        RbelConfiguration other = (RbelConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<Class<? extends RbelElement>, List<BiConsumer<RbelElement, RbelConverter>>> this$postConversionListener = this.getPostConversionListener();
        Map<Class<? extends RbelElement>, List<BiConsumer<RbelElement, RbelConverter>>> other$postConversionListener = other.getPostConversionListener();
        if (this$postConversionListener == null ? other$postConversionListener != null : !((Object)this$postConversionListener).equals(other$postConversionListener)) {
            return false;
        }
        List<Consumer<RbelConverter>> this$initializers = this.getInitializers();
        List<Consumer<RbelConverter>> other$initializers = other.getInitializers();
        if (this$initializers == null ? other$initializers != null : !((Object)this$initializers).equals(other$initializers)) {
            return false;
        }
        Map<String, Key> this$keys = this.getKeys();
        Map<String, Key> other$keys = other.getKeys();
        return !(this$keys == null ? other$keys != null : !((Object)this$keys).equals(other$keys));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RbelConfiguration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<Class<? extends RbelElement>, List<BiConsumer<RbelElement, RbelConverter>>> $postConversionListener = this.getPostConversionListener();
        result = result * 59 + ($postConversionListener == null ? 43 : ((Object)$postConversionListener).hashCode());
        List<Consumer<RbelConverter>> $initializers = this.getInitializers();
        result = result * 59 + ($initializers == null ? 43 : ((Object)$initializers).hashCode());
        Map<String, Key> $keys = this.getKeys();
        result = result * 59 + ($keys == null ? 43 : ((Object)$keys).hashCode());
        return result;
    }

    public String toString() {
        return "RbelConfiguration(postConversionListener=" + this.getPostConversionListener() + ", initializers=" + this.getInitializers() + ", keys=" + this.getKeys() + ")";
    }

    public RbelConfiguration(Map<Class<? extends RbelElement>, List<BiConsumer<RbelElement, RbelConverter>>> postConversionListener, List<Consumer<RbelConverter>> initializers, Map<String, Key> keys) {
        this.postConversionListener = postConversionListener;
        this.initializers = initializers;
        this.keys = keys;
    }

    public RbelConfiguration() {
    }
}

