/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.apps;

import com.github.tomakehurst.wiremock.WireMockServer;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import com.github.tomakehurst.wiremock.http.ContentTypeHeader;
import com.github.tomakehurst.wiremock.http.HttpHeaders;
import com.github.tomakehurst.wiremock.http.MultiValue;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.http.Response;
import de.gematik.rbellogger.converter.RbelConverter;
import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.RbelHttpRequest;
import de.gematik.rbellogger.data.RbelHttpResponse;
import de.gematik.rbellogger.data.RbelMapElement;
import de.gematik.rbellogger.data.RbelPathElement;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import wiremock.com.google.common.net.MediaType;

public class WiremockCapture {
    private static final Logger log = LoggerFactory.getLogger(WiremockCapture.class);
    private final RbelConverter rbel;
    private final String proxyFor;
    private WireMockServer wireMockServer;
    private boolean isInitialized;

    public void run() {
        this.initialize();
    }

    public WiremockCapture initialize() {
        if (this.isInitialized) {
            return this;
        }
        WireMockConfiguration wireMockConfiguration = WireMockConfiguration.options().dynamicPort().dynamicHttpsPort().trustAllProxyTargets(true).enableBrowserProxying(false);
        this.wireMockServer = new WireMockServer(wireMockConfiguration);
        this.wireMockServer.start();
        this.wireMockServer.stubFor(WireMock.any(WireMock.anyUrl()).willReturn(WireMock.aResponse().proxiedFrom(this.proxyFor)));
        this.wireMockServer.addMockServiceRequestListener((request, response) -> {
            this.rbel.convertMessage(this.requestToRbelMessage(request));
            this.rbel.convertMessage(this.responseToRbelMessage(response));
        });
        return this;
    }

    private RbelElement requestToRbelMessage(Request request) {
        return RbelHttpRequest.builder().method(request.getMethod().getName()).path((RbelPathElement)this.rbel.convertMessage(request.getUrl())).header(this.mapHeader(request.getHeaders())).body(this.convertMessageBody(request.getBodyAsString(), request.getHeaders().getContentTypeHeader())).build();
    }

    private RbelElement responseToRbelMessage(Response response) {
        return RbelHttpResponse.builder().responseCode(response.getStatus()).header(this.mapHeader(response.getHeaders())).body(this.convertMessageBody(response.getBodyAsString(), response.getHeaders().getContentTypeHeader())).build();
    }

    private RbelElement convertMessageBody(String bodyAsString, ContentTypeHeader contentTypeHeader) {
        if (Optional.ofNullable(contentTypeHeader).map(ContentTypeHeader::mimeTypePart).map(mime -> mime.equals(MediaType.FORM_DATA.toString())).orElse(false).booleanValue()) {
            try {
                return new RbelMapElement(Stream.of(bodyAsString.split("&")).map(str -> str.split("=")).collect(Collectors.toMap(array -> array[0], array -> this.rbel.convertMessage(array[1]))));
            }
            catch (Exception e) {
                log.warn("Unable to parse form-data '" + bodyAsString + "'. Using fallback");
                return this.rbel.convertMessage(bodyAsString);
            }
        }
        return this.rbel.convertMessage(bodyAsString);
    }

    private RbelElement mapHeader(HttpHeaders headers) {
        Map<String, RbelElement> headersMap = headers.all().stream().collect(Collectors.toMap(MultiValue::key, httpHeader -> this.rbel.convertMessage(httpHeader.firstValue())));
        return new RbelMapElement(headersMap);
    }

    public String getProxyAdress() {
        return "http://localhost:" + this.wireMockServer.port();
    }

    public String getTlsProxyAdress() {
        return "https://localhost:" + this.wireMockServer.httpsPort();
    }

    WiremockCapture(RbelConverter rbel, String proxyFor, WireMockServer wireMockServer, boolean isInitialized) {
        this.rbel = rbel;
        this.proxyFor = proxyFor;
        this.wireMockServer = wireMockServer;
        this.isInitialized = isInitialized;
    }

    public static WiremockCaptureBuilder builder() {
        return new WiremockCaptureBuilder();
    }

    public RbelConverter getRbel() {
        return this.rbel;
    }

    public String getProxyFor() {
        return this.proxyFor;
    }

    public WireMockServer getWireMockServer() {
        return this.wireMockServer;
    }

    public boolean isInitialized() {
        return this.isInitialized;
    }

    public void setWireMockServer(WireMockServer wireMockServer) {
        this.wireMockServer = wireMockServer;
    }

    public void setInitialized(boolean isInitialized) {
        this.isInitialized = isInitialized;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WiremockCapture)) {
            return false;
        }
        WiremockCapture other = (WiremockCapture)o;
        if (!other.canEqual(this)) {
            return false;
        }
        RbelConverter this$rbel = this.getRbel();
        RbelConverter other$rbel = other.getRbel();
        if (this$rbel == null ? other$rbel != null : !this$rbel.equals(other$rbel)) {
            return false;
        }
        String this$proxyFor = this.getProxyFor();
        String other$proxyFor = other.getProxyFor();
        if (this$proxyFor == null ? other$proxyFor != null : !this$proxyFor.equals(other$proxyFor)) {
            return false;
        }
        WireMockServer this$wireMockServer = this.getWireMockServer();
        WireMockServer other$wireMockServer = other.getWireMockServer();
        if (this$wireMockServer == null ? other$wireMockServer != null : !this$wireMockServer.equals(other$wireMockServer)) {
            return false;
        }
        return this.isInitialized() == other.isInitialized();
    }

    protected boolean canEqual(Object other) {
        return other instanceof WiremockCapture;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        RbelConverter $rbel = this.getRbel();
        result = result * 59 + ($rbel == null ? 43 : $rbel.hashCode());
        String $proxyFor = this.getProxyFor();
        result = result * 59 + ($proxyFor == null ? 43 : $proxyFor.hashCode());
        WireMockServer $wireMockServer = this.getWireMockServer();
        result = result * 59 + ($wireMockServer == null ? 43 : $wireMockServer.hashCode());
        result = result * 59 + (this.isInitialized() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "WiremockCapture(rbel=" + this.getRbel() + ", proxyFor=" + this.getProxyFor() + ", wireMockServer=" + this.getWireMockServer() + ", isInitialized=" + this.isInitialized() + ")";
    }

    public static class WiremockCaptureBuilder {
        private RbelConverter rbel;
        private String proxyFor;
        private WireMockServer wireMockServer;
        private boolean isInitialized;

        WiremockCaptureBuilder() {
        }

        public WiremockCaptureBuilder rbel(RbelConverter rbel) {
            this.rbel = rbel;
            return this;
        }

        public WiremockCaptureBuilder proxyFor(String proxyFor) {
            this.proxyFor = proxyFor;
            return this;
        }

        public WiremockCaptureBuilder wireMockServer(WireMockServer wireMockServer) {
            this.wireMockServer = wireMockServer;
            return this;
        }

        public WiremockCaptureBuilder isInitialized(boolean isInitialized) {
            this.isInitialized = isInitialized;
            return this;
        }

        public WiremockCapture build() {
            return new WiremockCapture(this.rbel, this.proxyFor, this.wireMockServer, this.isInitialized);
        }

        public String toString() {
            return "WiremockCapture.WiremockCaptureBuilder(rbel=" + this.rbel + ", proxyFor=" + this.proxyFor + ", wireMockServer=" + this.wireMockServer + ", isInitialized=" + this.isInitialized + ")";
        }
    }
}

