/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.apps;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.sun.jna.Platform;
import de.gematik.rbellogger.apps.PCapException;
import de.gematik.rbellogger.converter.RbelConfiguration;
import de.gematik.rbellogger.converter.RbelConverter;
import de.gematik.rbellogger.converter.RbelValueShader;
import de.gematik.rbellogger.converter.initializers.RbelKeyFolderInitializer;
import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.RbelJsonElement;
import de.gematik.rbellogger.data.RbelJweElement;
import de.gematik.rbellogger.data.RbelMapElement;
import de.gematik.rbellogger.renderer.RbelHtmlRenderer;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.util.Arrays;
import java.util.Base64;
import java.util.Optional;
import java.util.function.BiConsumer;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.io.FileUtils;
import org.pcap4j.core.BpfProgram;
import org.pcap4j.core.NotOpenException;
import org.pcap4j.core.PacketListener;
import org.pcap4j.core.PcapDumper;
import org.pcap4j.core.PcapHandle;
import org.pcap4j.core.PcapNativeException;
import org.pcap4j.core.PcapNetworkInterface;
import org.pcap4j.core.PcapStat;
import org.pcap4j.core.Pcaps;
import org.pcap4j.packet.Packet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import wiremock.org.apache.commons.codec.digest.DigestUtils;

public class PCapCapture {
    private static final Logger log = LoggerFactory.getLogger(PCapCapture.class);
    @Parameter(names={"-device"})
    private String deviceName;
    @Parameter(names={"-list-devices"})
    private boolean listDevices;
    @Parameter(names={"-pcap"})
    private String pcapFile;
    @Parameter(names={"-filter"})
    private String filter;
    @Parameter(names={"-dump"})
    private boolean printMessageToSystemOut;
    @Parameter(names={"-html"})
    private boolean bHtml;
    @Parameter(names={"-shade-values"})
    private String shadeValues = null;
    private RbelConverter rbel;
    private static final BiConsumer<RbelElement, RbelConverter> RBEL_IDP_TOKEN_KEY_LISTENER = (element, converter) -> Optional.ofNullable(((RbelJweElement)element).getBody()).filter(RbelJsonElement.class::isInstance).map(RbelJsonElement.class::cast).map(RbelJsonElement::getJsonElement).filter(RbelMapElement.class::isInstance).map(RbelMapElement.class::cast).map(RbelMapElement::getChildElements).filter(map -> map.containsKey("token_key")).map(map -> (RbelElement)map.get("token_key")).map(tokenB64 -> Base64.getUrlDecoder().decode(tokenB64.getContent())).map(tokenKeyBytes -> new SecretKeySpec((byte[])tokenKeyBytes, "AES")).ifPresent(aesKey -> converter.getKeyIdToKeyDatabase().put("token_key", (Key)aesKey));

    public static void main(String[] args) {
        PCapCapture.setWindowsNpcapPath();
        PCapCapture main = new PCapCapture();
        JCommander.newBuilder().addObject(main).build().parse(args);
        main.run();
    }

    private static void setWindowsNpcapPath() {
        if (System.getProperty("os.name").startsWith("Windows")) {
            Object prop = System.getProperty("jna.library.path");
            prop = prop == null || ((String)prop).isEmpty() ? "C:/Windows/System32/Npcap" : (String)prop + ";C:/Windows/System32/Npcap";
            System.setProperty("jna.library.path", (String)prop);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        PcapHandle handle;
        PcapDumper dumper = null;
        if (this.printMessageToSystemOut) {
            log.info("Activated system out channel");
        }
        if (this.listDevices) {
            this.printAllPcapDevicesToSystemOut();
            return;
        }
        if (this.deviceName != null) {
            handle = this.getLivePcapHandle();
            dumper = handle.dumpOpen("out.pcap");
        } else if (this.pcapFile != null) {
            handle = this.getOfflinePcapHandle();
        } else {
            throw new IllegalArgumentException("Either device or pcap file must be specified");
        }
        if (this.rbel == null) {
            this.rbel = RbelConverter.build(new RbelConfiguration().addKey("IDP symmetricEncryptionKey", new SecretKeySpec(DigestUtils.sha256("geheimerSchluesselDerNochGehashtWird"), "AES")).addInitializer(new RbelKeyFolderInitializer("src/test/resources")).addPostConversionListener(RbelJweElement.class, RBEL_IDP_TOKEN_KEY_LISTENER));
        }
        if (!handle.isOpen()) {
            throw new IllegalAccessException("Source not open for reading!");
        }
        if (this.filter == null) {
            this.filter = "host 127.0.0.1 and tcp port 8080";
        }
        log.info("Applying filter '" + this.filter + "'");
        try {
            handle.setFilter(this.filter, BpfProgram.BpfCompileMode.OPTIMIZE);
            int maxPackets = -1;
            handle.loop(-1, new RBelPacketListener(handle, dumper));
        }
        catch (InterruptedException e) {
            log.info("Packet capturing interrupted...");
        }
        finally {
            this.printStatsAndCloseConnections(handle, dumper);
        }
        if (dumper != null) {
            log.info("Saved traffic to " + new File("out.pcap").getAbsolutePath());
        }
        if (this.bHtml) {
            this.exportToHtml();
        }
    }

    private void printStatsAndCloseConnections(PcapHandle handle, PcapDumper dumper) throws PcapNativeException, NotOpenException {
        if (this.deviceName != null && this.printMessageToSystemOut) {
            PcapStat stats = handle.getStats();
            log.info("Packets received: " + stats.getNumPacketsReceived());
            log.info("Packets dropped: " + stats.getNumPacketsDropped());
            log.info("Packets dropped by interface: " + stats.getNumPacketsDroppedByIf());
            if (Platform.isWindows()) {
                log.info("Packets captured: " + stats.getNumPacketsCaptured());
            }
        }
        if (dumper != null) {
            dumper.close();
        }
        handle.close();
    }

    private void exportToHtml() throws IOException {
        String html;
        if (this.shadeValues != null) {
            RbelValueShader shader = new RbelValueShader();
            shader.loadFromResource(this.shadeValues);
            html = RbelHtmlRenderer.render(this.rbel.getMessageHistory(), shader);
            this.shadeValues = null;
        } else {
            html = RbelHtmlRenderer.render(this.rbel.getMessageHistory());
        }
        FileUtils.writeStringToFile(new File("out.html"), html, StandardCharsets.UTF_8);
        log.info("Saved HTML report to " + new File("out.html").getAbsolutePath());
    }

    private void printAllPcapDevicesToSystemOut() throws PcapNativeException {
        Pcaps.findAllDevs().forEach(dev -> log.info((dev.isUp() ? "UP " : "DOWN ") + dev.getName() + " - " + dev.getDescription()));
    }

    private PcapHandle getLivePcapHandle() throws PcapNativeException {
        log.info("Capturing traffic live from device " + this.deviceName);
        PcapNetworkInterface device = Pcaps.getDevByName(this.deviceName);
        int snapshotLength = 65536;
        int readTimeout = 50;
        PcapHandle handle = device.openLive(65536, PcapNetworkInterface.PromiscuousMode.PROMISCUOUS, 50);
        return handle;
    }

    private PcapHandle getOfflinePcapHandle() throws PcapNativeException {
        PcapHandle handle;
        log.info("Reading traffic from pcap file " + new File(this.pcapFile).getAbsolutePath());
        try {
            handle = Pcaps.openOffline(this.pcapFile, PcapHandle.TimestampPrecision.NANO);
        }
        catch (PcapNativeException e) {
            handle = Pcaps.openOffline(this.pcapFile);
        }
        return handle;
    }

    public static PCapCaptureBuilder builder() {
        return new PCapCaptureBuilder();
    }

    public PCapCapture() {
    }

    public PCapCapture(String deviceName, boolean listDevices, String pcapFile, String filter, boolean printMessageToSystemOut, boolean bHtml, String shadeValues, RbelConverter rbel) {
        this.deviceName = deviceName;
        this.listDevices = listDevices;
        this.pcapFile = pcapFile;
        this.filter = filter;
        this.printMessageToSystemOut = printMessageToSystemOut;
        this.bHtml = bHtml;
        this.shadeValues = shadeValues;
        this.rbel = rbel;
    }

    public static class PCapCaptureBuilder {
        private String deviceName;
        private boolean listDevices;
        private String pcapFile;
        private String filter;
        private boolean printMessageToSystemOut;
        private boolean bHtml;
        private String shadeValues;
        private RbelConverter rbel;

        PCapCaptureBuilder() {
        }

        public PCapCaptureBuilder deviceName(String deviceName) {
            this.deviceName = deviceName;
            return this;
        }

        public PCapCaptureBuilder listDevices(boolean listDevices) {
            this.listDevices = listDevices;
            return this;
        }

        public PCapCaptureBuilder pcapFile(String pcapFile) {
            this.pcapFile = pcapFile;
            return this;
        }

        public PCapCaptureBuilder filter(String filter) {
            this.filter = filter;
            return this;
        }

        public PCapCaptureBuilder printMessageToSystemOut(boolean printMessageToSystemOut) {
            this.printMessageToSystemOut = printMessageToSystemOut;
            return this;
        }

        public PCapCaptureBuilder bHtml(boolean bHtml) {
            this.bHtml = bHtml;
            return this;
        }

        public PCapCaptureBuilder shadeValues(String shadeValues) {
            this.shadeValues = shadeValues;
            return this;
        }

        public PCapCaptureBuilder rbel(RbelConverter rbel) {
            this.rbel = rbel;
            return this;
        }

        public PCapCapture build() {
            return new PCapCapture(this.deviceName, this.listDevices, this.pcapFile, this.filter, this.printMessageToSystemOut, this.bHtml, this.shadeValues, this.rbel);
        }

        public String toString() {
            return "PCapCapture.PCapCaptureBuilder(deviceName=" + this.deviceName + ", listDevices=" + this.listDevices + ", pcapFile=" + this.pcapFile + ", filter=" + this.filter + ", printMessageToSystemOut=" + this.printMessageToSystemOut + ", bHtml=" + this.bHtml + ", shadeValues=" + this.shadeValues + ", rbel=" + this.rbel + ")";
        }
    }

    class RBelPacketListener
    implements PacketListener {
        private final PcapHandle handle;
        private final PcapDumper dumper;
        private boolean chunkedTransfer = false;
        private String chunkedMessage;

        @Override
        public void gotPacket(Packet packet) {
            String content = this.getPayloadAsString(packet);
            this.processMessage(content);
            try {
                if (this.dumper != null) {
                    this.dumper.dump(packet, this.handle.getTimestamp());
                }
            }
            catch (NotOpenException e) {
                e.printStackTrace();
            }
        }

        private void processMessage(String content) {
            try {
                if (this.chunkedTransfer) {
                    this.processChunkedMessage(content);
                }
                if (!this.chunkedTransfer) {
                    this.processSimpleHttpPackets(content);
                }
            }
            catch (Exception e) {
                throw new PCapException("Failed parsing content '" + content + "'", e);
            }
        }

        private void processChunkedMessage(String content) {
            if (!this.isHttp(content)) {
                int eol = content.indexOf("\r\n");
                this.chunkedMessage = this.chunkedMessage + (eol == -1 ? content : content.substring(eol + 4));
            } else {
                RbelElement convertedMultiPartMsg = PCapCapture.this.rbel.convertMessage(this.chunkedMessage);
                if (PCapCapture.this.printMessageToSystemOut) {
                    log.info("Multi:" + convertedMultiPartMsg.getContent());
                }
                this.chunkedMessage = null;
                this.chunkedTransfer = false;
            }
        }

        private void processSimpleHttpPackets(String content) {
            RbelElement convertMessage;
            if (content.contains("GET /EXIT_RBELLOGGER")) {
                this.handle.breakLoop();
                return;
            }
            if (this.isHttpResponse(content)) {
                convertMessage = PCapCapture.this.rbel.convertMessage(content);
            } else if (this.isGetOrDeleteRequest(content)) {
                convertMessage = PCapCapture.this.rbel.convertMessage(content);
            } else if (content.startsWith("POST ") || content.startsWith("PUT")) {
                this.chunkedMessage = content;
                this.chunkedTransfer = true;
                convertMessage = null;
            } else {
                convertMessage = PCapCapture.this.rbel.convertMessage(content);
            }
            if (PCapCapture.this.printMessageToSystemOut && convertMessage != null && !content.isEmpty()) {
                log.info("RBEL: " + convertMessage.getContent());
            }
        }

        private String getPayloadAsString(Packet packet) {
            Packet pp = packet.getPayload();
            if (pp == null) {
                throw new PCapException("Payload of packet is NULL!");
            }
            int offset = 0;
            while (pp != null) {
                if (pp.getHeader() != null) {
                    offset += pp.getHeader().length();
                }
                pp = pp.getPayload();
            }
            byte[] by = packet.getPayload().getRawData();
            by = Arrays.copyOfRange(by, offset, by.length);
            return new String(by);
        }

        private boolean isHttp(String content) {
            return this.isHttpRequest(content) || this.isHttpResponse(content);
        }

        private boolean isHttpResponse(String content) {
            return content.startsWith("HTTP/");
        }

        private boolean isHttpRequest(String content) {
            return this.isGetOrDeleteRequest(content) || this.isPostOrPutRequest(content);
        }

        private boolean isGetOrDeleteRequest(String content) {
            return content.startsWith("GET ") || content.startsWith("DELETE ");
        }

        private boolean isPostOrPutRequest(String content) {
            return content.startsWith("POST ") || content.startsWith("PUT ");
        }

        public RBelPacketListener(PcapHandle handle, PcapDumper dumper) {
            this.handle = handle;
            this.dumper = dumper;
        }
    }
}

