/*
 * Decompiled with CFR 0.152.
 */
package org.jnetpcap.protocol.voip;

import org.jnetpcap.nio.JBuffer;
import org.jnetpcap.packet.JHeader;
import org.jnetpcap.packet.JSubHeader;
import org.jnetpcap.packet.annotate.Dynamic;
import org.jnetpcap.packet.annotate.Field;
import org.jnetpcap.packet.annotate.Header;
import org.jnetpcap.packet.annotate.HeaderLength;
import org.jnetpcap.packet.annotate.ProtocolSuite;

@Header(spec={"rfc3550"}, suite=ProtocolSuite.VOIP, description="real-time transfer protocol")
public class Rtp
extends JHeader {
    public static final int CC_MASK = 15;
    public static final int CC_OFFSET = 0;
    public static final int CSRC_LENGTH = 4;
    public static final String DESCRIPTION = "real-time transfer protocol";
    public static final int EXTENSION_MASK = 16;
    public static final int EXTENSION_OFFSET = 4;
    public static int ID = 48;
    public static final int MARKER_MASK = 128;
    public static final int MARKER_OFFSET = 7;
    public static final int PADDING_MASK = 32;
    public static final int PADDING_OFFSET = 5;
    public static final String RFC = "rfc3550";
    public static final int RTP_UDP_PORT = 5004;
    public static final int STATIC_HEADER_LENGTH = 12;
    public static final ProtocolSuite SUITE = ProtocolSuite.VOIP;
    public static final int TYPE_MASK = 127;
    public static final int TYPE_OFFSET = 0;
    public static final int VERSION_MASK = 192;
    public static final int VERSION_OFFSET = 6;

    private static int baseHeaderLength(JBuffer jBuffer, int n) {
        byte by = jBuffer.getByte(n);
        int n2 = (by & 0xF) >> 0;
        return 12 + n2 * 4;
    }

    @HeaderLength
    public static int headerLength(JBuffer jBuffer, int n) {
        int n2 = Rtp.baseHeaderLength(jBuffer, n);
        if ((jBuffer.getByte(n) & 0x10) > 0) {
            return n2 + Extension.headerLength(jBuffer, n + n2);
        }
        return n2;
    }

    @HeaderLength(value=HeaderLength.Type.POSTFIX)
    public static int postfixLength(JBuffer jBuffer, int n) {
        if ((jBuffer.getByte(n) & 0x20) > 0) {
            return jBuffer.getUByte(jBuffer.size() - 1);
        }
        return 5;
    }

    @Field(offset=4, length=4)
    public int count() {
        return (super.getByte(0) & 0xF) >> 0;
    }

    @Field(offset=96)
    public int[] csrc() {
        int n = this.count();
        int[] nArray = new int[n];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = super.getInt(12 + i * 4);
        }
        return nArray;
    }

    @Dynamic(value=Field.Property.LENGTH)
    public int csrcLength() {
        return this.count() * 4 * 8;
    }

    @Field(offset=3, length=1)
    public boolean hasExtension() {
        return (super.getByte(0) & 0x10) >> 4 > 0;
    }

    @Field(offset=8, length=1)
    public boolean hasMarker() {
        return (super.getByte(1) & 0x80) >> 7 > 0;
    }

    @Field(offset=2, length=1)
    public boolean hasPadding() {
        return (super.getByte(0) & 0x20) >> 5 > 0;
    }

    public int paddingLength() {
        if (!this.hasPostfix()) {
            return 0;
        }
        int n = this.packet.getUByte(this.getPostfixOffset() + this.getPostfixLength() - 1);
        return n;
    }

    @Field(offset=16, length=16)
    public int sequence() {
        return super.getUShort(2);
    }

    @Field(offset=64, length=32)
    public long ssrc() {
        return super.getUInt(8);
    }

    @Field(offset=32, length=32)
    public long timestamp() {
        return super.getUInt(4);
    }

    @Field(offset=9, length=7)
    public int type() {
        return (super.getByte(1) & 0x7F) >> 0;
    }

    public PayloadType typeEnum() {
        return PayloadType.valueOf(this.type());
    }

    @Field(offset=0, length=2)
    public int version() {
        return (super.getByte(0) & 0xC0) >> 6;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PayloadType {
        CN,
        DVI4_16K,
        DVI4_8K,
        G711,
        G721,
        G722,
        G723,
        G728,
        GSM,
        L16_1CH,
        L16_2CH,
        LPC,
        MPA,
        PCMA,
        QCELP,
        RESERVED1,
        RESERVED2;


        public static PayloadType valueOf(int n) {
            return PayloadType.values()[n];
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class Extension
    extends JSubHeader<Rtp> {
        public static final int STATIC_HEADER_LENGTH = 4;

        @HeaderLength
        public static int headerLength(JBuffer jBuffer, int n) {
            return jBuffer.getUShort(2) * 4 + 4;
        }

        @Field(offset=16, length=16)
        public int length() {
            return super.getUShort(2);
        }

        public int profileSpecific() {
            return super.getUShort(0);
        }
    }
}

