/*
 * Decompiled with CFR 0.152.
 */
package org.jnetpcap.packet;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.jnetpcap.ByteBufferHandler;
import org.jnetpcap.JBufferHandler;
import org.jnetpcap.Pcap;
import org.jnetpcap.PcapHeader;
import org.jnetpcap.header.MyHeader;
import org.jnetpcap.nio.JBuffer;
import org.jnetpcap.nio.JMemory;
import org.jnetpcap.packet.JHeaderScanner;
import org.jnetpcap.packet.JMemoryPacket;
import org.jnetpcap.packet.JPacket;
import org.jnetpcap.packet.JPacketHandler;
import org.jnetpcap.packet.JRegistry;
import org.jnetpcap.packet.JScanner;
import org.jnetpcap.packet.PcapPacket;
import org.jnetpcap.packet.PeeringException;
import org.jnetpcap.packet.TestUtils;
import org.jnetpcap.packet.format.TextFormatter;

public class TestJScanner
extends TestUtils {
    private int[] flags;

    @Override
    protected void setUp() throws Exception {
        this.flags = JRegistry.getAllFlags();
    }

    @Override
    protected void tearDown() throws Exception {
        JRegistry.setAllFlags(this.flags);
    }

    public void _testJScannerInit() {
        new JScanner();
    }

    public void _testJScannerSizeOf() {
        TestJScanner.assertTrue((String)("sizeof=" + JScanner.sizeof()), (JScanner.sizeof() > 0 && JScanner.sizeof() < 100000 ? 1 : 0) != 0);
    }

    public void _testScanOnePacket() throws IOException {
        JMemoryPacket jMemoryPacket = new JMemoryPacket(new byte[]{-96, -95, -94, -93, -92, -91, -80, -79, -78, -77, -76, -75, 0, 8});
        JScanner jScanner = new JScanner();
        jScanner.scan(jMemoryPacket, 1);
        TextFormatter textFormatter = new TextFormatter();
        textFormatter.format(jMemoryPacket);
    }

    public void _testScanFileBBHandler() throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        final Pcap pcap = Pcap.openOffline("tests/test-l2tp.pcap", stringBuilder);
        final PcapPacket pcapPacket = new PcapPacket(JMemory.Type.POINTER);
        final JScanner jScanner = new JScanner();
        long l = System.currentTimeMillis();
        final TextFormatter textFormatter = new TextFormatter();
        pcap.loop(-1, new ByteBufferHandler<String>(){
            int i = 0;

            @Override
            public void nextPacket(PcapHeader pcapHeader, ByteBuffer byteBuffer, String string) {
                if (this.i == 200) {
                    pcap.breakloop();
                    return;
                }
                System.out.println("\nPacket #" + this.i);
                try {
                    pcapPacket.peer(byteBuffer);
                }
                catch (PeeringException peeringException) {
                    peeringException.printStackTrace();
                }
                jScanner.scan(pcapPacket, 1);
                textFormatter.setFrameIndex(this.i++);
            }
        }, "");
        long l2 = System.currentTimeMillis();
        System.out.printf("time=%d ms\n", l2 - l);
        pcap.close();
    }

    public void _testScanFileJBHandler() throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        final Pcap pcap = Pcap.openOffline("tests/test-l2tp.pcap", stringBuilder);
        final PcapPacket pcapPacket = new PcapPacket(JMemory.Type.POINTER);
        final JScanner jScanner = new JScanner();
        long l = System.currentTimeMillis();
        final TextFormatter textFormatter = new TextFormatter();
        pcap.loop(-1, new JBufferHandler<String>(){
            int i = 0;

            @Override
            public void nextPacket(PcapHeader pcapHeader, JBuffer jBuffer, String string) {
                if (this.i == 200) {
                    pcap.breakloop();
                    return;
                }
                System.out.println("\nPacket #" + this.i);
                pcapPacket.peer(jBuffer);
                jScanner.scan(pcapPacket, 1);
                textFormatter.setFrameIndex(this.i++);
            }
        }, "");
        long l2 = System.currentTimeMillis();
        System.out.printf("time=%d ms\n", l2 - l);
        pcap.close();
    }

    public void testScanFileJPHandler() throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        Pcap pcap = Pcap.openOffline("tests/test-vlan.pcap", stringBuilder);
        TextFormatter textFormatter = new TextFormatter();
        JScanner jScanner = new JScanner();
        pcap.loop(-1, 1, new JPacketHandler<String>(){
            int i = 0;

            @Override
            public void nextPacket(JPacket jPacket, String string) {
            }
        }, "");
        pcap.close();
    }

    public void testScannerConstructorAnnotatedMyHeaderClass() {
        new JHeaderScanner(MyHeader.class);
    }

    public void testInvokeGetHeaderLengthAnnotated() {
        PcapPacket pcapPacket = TestUtils.getPcapPacket("tests/test-afs.pcap", 0);
        JHeaderScanner jHeaderScanner = new JHeaderScanner(MyHeader.class);
        TestJScanner.assertEquals((int)20, (int)jHeaderScanner.getHeaderLength(pcapPacket, 14));
        System.out.printf("length=%d %d\n", jHeaderScanner.getHeaderLength(pcapPacket, 14), pcapPacket.getUByte(14) & 0xF);
    }

    public void testFlagNonOverride() {
        PcapPacket pcapPacket = TestJScanner.getPcapPacket("tests/test-http-jpeg.pcap", 5);
        TestJScanner.assertTrue((boolean)pcapPacket.hasHeader(1));
        TestJScanner.assertTrue((boolean)pcapPacket.hasHeader(2));
        TestJScanner.assertTrue((boolean)pcapPacket.hasHeader(4));
        TestJScanner.assertTrue((boolean)pcapPacket.hasHeader(13));
    }

    public void testFlagOverride() {
        JScanner.bindingOverride(4, true);
        JScanner.heuristicCheck(4, false);
        JPacket.getDefaultScanner().reloadAll();
        PcapPacket pcapPacket = TestJScanner.getPcapPacket("tests/test-http-jpeg.pcap", 5);
        TestJScanner.assertTrue((boolean)pcapPacket.hasHeader(1));
        TestJScanner.assertTrue((boolean)pcapPacket.hasHeader(2));
        TestJScanner.assertTrue((boolean)pcapPacket.hasHeader(4));
        TestJScanner.assertFalse((boolean)pcapPacket.hasHeader(13));
        JScanner.heuristicCheck(4, true);
        JPacket.getDefaultScanner().reloadAll();
    }

    public void testFlagPostHeuristics() {
        JScanner.bindingOverride(4, true);
        JScanner.heuristicPostCheck(4, true);
        PcapPacket pcapPacket = TestJScanner.getPcapPacket("tests/test-http-jpeg.pcap", 5);
        TestJScanner.assertTrue((boolean)pcapPacket.hasHeader(1));
        TestJScanner.assertTrue((boolean)pcapPacket.hasHeader(2));
        TestJScanner.assertTrue((boolean)pcapPacket.hasHeader(4));
        TestJScanner.assertTrue((boolean)pcapPacket.hasHeader(13));
    }

    public void testPacketState() {
        PcapPacket pcapPacket = TestJScanner.getPcapPacket("tests/test-http-jpeg.pcap", 5);
        TestJScanner.assertNotNull((Object)pcapPacket);
        System.out.println(pcapPacket.getState().toDebugString());
    }

    public void testGetFrameNumber() {
        TestJScanner.assertTrue((JScanner.getThreadLocal().getFrameNumber() != 0L ? 1 : 0) != 0);
        System.out.printf("frameNumber=%d\n", JScanner.getThreadLocal().getFrameNumber());
    }

    public void testSetFrameNumber() {
        long l = JScanner.getThreadLocal().getFrameNumber();
        JScanner.getThreadLocal().setFrameNumber(l + 1L);
        TestJScanner.assertEquals((long)(l + 1L), (long)JScanner.getThreadLocal().getFrameNumber());
        System.out.printf("frameNumber=%d\n", JScanner.getThreadLocal().getFrameNumber());
    }
}

