/*
 * Decompiled with CFR 0.152.
 */
package org.jnetpcap.bugs;

import java.nio.ByteBuffer;
import org.jnetpcap.nio.JBuffer;
import org.jnetpcap.packet.JMemoryPacket;
import org.jnetpcap.packet.PcapPacket;
import org.jnetpcap.packet.PeeringException;
import org.jnetpcap.packet.TestUtils;

public class Bug2828030_wirelen_not_set_in_JMemoryPacket
extends TestUtils {
    private byte[] data;

    @Override
    protected void setUp() throws Exception {
        PcapPacket pcapPacket = Bug2828030_wirelen_not_set_in_JMemoryPacket.getPcapPacket("tests/test-l2tp.pcap", 0);
        this.data = pcapPacket.getByteArray(0, pcapPacket.size());
    }

    @Override
    protected void tearDown() throws Exception {
        this.data = null;
    }

    public void testScannerExceptionWithByteArray() {
        JMemoryPacket jMemoryPacket = new JMemoryPacket(this.data);
        Bug2828030_wirelen_not_set_in_JMemoryPacket.assertNotNull((Object)jMemoryPacket);
        jMemoryPacket.scan(1);
    }

    public void testScannerExceptionWithIByteArray() {
        JMemoryPacket jMemoryPacket = new JMemoryPacket(1, this.data);
        Bug2828030_wirelen_not_set_in_JMemoryPacket.assertNotNull((Object)jMemoryPacket);
    }

    public void testScannerExceptionWithJBuffer() {
        JBuffer jBuffer = new JBuffer(this.data);
        JMemoryPacket jMemoryPacket = new JMemoryPacket(jBuffer);
        Bug2828030_wirelen_not_set_in_JMemoryPacket.assertNotNull((Object)jMemoryPacket);
        jMemoryPacket.scan(1);
    }

    public void testScannerExceptionWithIJBuffer() {
        JBuffer jBuffer = new JBuffer(this.data);
        JMemoryPacket jMemoryPacket = new JMemoryPacket(1, jBuffer);
        Bug2828030_wirelen_not_set_in_JMemoryPacket.assertNotNull((Object)jMemoryPacket);
    }

    public void testScannerExceptionWithByteBuffer() throws PeeringException {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(this.data.length);
        byteBuffer.put(this.data).clear();
        JMemoryPacket jMemoryPacket = new JMemoryPacket(byteBuffer);
        Bug2828030_wirelen_not_set_in_JMemoryPacket.assertNotNull((Object)jMemoryPacket);
        jMemoryPacket.scan(1);
    }

    public void testScannerExceptionWithIByteBuffer() throws PeeringException {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(this.data.length);
        byteBuffer.put(this.data).clear();
        JMemoryPacket jMemoryPacket = new JMemoryPacket(1, byteBuffer);
        Bug2828030_wirelen_not_set_in_JMemoryPacket.assertNotNull((Object)jMemoryPacket);
    }
}

