/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.renderer;

import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.facet.RbelHostnameFacet;
import de.gematik.rbellogger.data.facet.RbelHttpMessageFacet;
import de.gematik.rbellogger.data.facet.RbelHttpRequestFacet;
import de.gematik.rbellogger.data.facet.RbelHttpResponseFacet;
import de.gematik.rbellogger.data.facet.RbelMessageTimingFacet;
import de.gematik.rbellogger.data.facet.RbelRequestFacet;
import de.gematik.rbellogger.data.facet.RbelResponseFacet;
import de.gematik.rbellogger.data.facet.RbelTcpIpMessageFacet;
import de.gematik.rbellogger.renderer.RbelHtmlFacetRenderer;
import de.gematik.rbellogger.renderer.RbelHtmlRenderer;
import de.gematik.rbellogger.renderer.RbelHtmlRenderingToolkit;
import j2html.TagCreator;
import j2html.tags.ContainerTag;
import j2html.tags.DomContent;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public class RbelMessageRenderer
implements RbelHtmlFacetRenderer {
    public static ContainerTag buildAddressInfo(RbelElement element) {
        String icon;
        String right;
        String left;
        if (!element.hasFacet(RbelTcpIpMessageFacet.class)) {
            return TagCreator.span();
        }
        RbelTcpIpMessageFacet messageFacet = element.getFacetOrFail(RbelTcpIpMessageFacet.class);
        if (messageFacet.getSender().getFacet(RbelHostnameFacet.class).isEmpty() && messageFacet.getReceiver().getFacet(RbelHostnameFacet.class).isEmpty()) {
            return TagCreator.span();
        }
        Optional<Boolean> isRequest = RbelMessageRenderer.determineIsRequest(element);
        if (isRequest.isEmpty() || isRequest.get().booleanValue()) {
            left = messageFacet.getSender().getFacet(RbelHostnameFacet.class).map(RbelHostnameFacet::toString).orElse(null);
            right = messageFacet.getReceiver().getFacet(RbelHostnameFacet.class).map(RbelHostnameFacet::toString).orElse(null);
            icon = "fa-arrow-right";
        } else {
            left = messageFacet.getReceiver().getFacet(RbelHostnameFacet.class).map(RbelHostnameFacet::toString).orElse(null);
            right = messageFacet.getSender().getFacet(RbelHostnameFacet.class).map(RbelHostnameFacet::toString).orElse(null);
            icon = "fa-arrow-left";
        }
        return (ContainerTag)TagCreator.span().withText(left == null ? "" : left).with((DomContent)RbelHtmlRenderingToolkit.icon(icon)).with((DomContent)TagCreator.text(right == null ? "" : right)).withClass("is-size-6 ml-4");
    }

    private static Optional<Boolean> determineIsRequest(RbelElement element) {
        if (element.hasFacet(RbelRequestFacet.class)) {
            return Optional.of(true);
        }
        if (element.hasFacet(RbelResponseFacet.class)) {
            return Optional.of(false);
        }
        return Optional.empty();
    }

    public static ContainerTag buildTimingInfo(RbelElement element) {
        if (!element.hasFacet(RbelMessageTimingFacet.class)) {
            return TagCreator.span();
        }
        RbelMessageTimingFacet timingFacet = element.getFacetOrFail(RbelMessageTimingFacet.class);
        return (ContainerTag)TagCreator.span().with((DomContent)RbelHtmlRenderingToolkit.icon("fa-clock")).withText(timingFacet.getTransmissionTime().format(DateTimeFormatter.ISO_TIME)).withClass("is-size-6 ml-4 ");
    }

    @Override
    public boolean checkForRendering(RbelElement element) {
        return element.hasFacet(RbelHttpMessageFacet.class) && element.getParentNode() != null;
    }

    @Override
    public ContainerTag performRendering(RbelElement element, Optional<String> key, RbelHtmlRenderingToolkit renderingToolkit) {
        Optional<RbelHttpMessageFacet> httpMessageFacet = element.getFacet(RbelHttpMessageFacet.class);
        Optional<RbelHttpRequestFacet> httpRequestFacet = element.getFacet(RbelHttpRequestFacet.class);
        Optional<RbelHttpResponseFacet> httpResponseFacet = element.getFacet(RbelHttpResponseFacet.class);
        Optional<Boolean> isRequest = RbelMessageRenderer.determineIsRequest(element);
        ArrayList<Object> messageTitleElements = new ArrayList<Object>();
        messageTitleElements.add(TagCreator.a().withName(element.getUuid()));
        messageTitleElements.add(TagCreator.i().withClasses("fas fa-toggle-on toggle-icon is-pulled-right mr-3 is-size-3", httpRequestFacet.map(f -> "has-text-link").orElse("has-text-success")));
        messageTitleElements.add(RbelHtmlRenderer.showContentButtonAndDialog(element));
        messageTitleElements.add(TagCreator.h1(new DomContent[]{renderingToolkit.constructMessageId(element), this.getRequestOrReplySymbol(isRequest), httpRequestFacet.map(f -> (ContainerTag)TagCreator.span().with((DomContent)((ContainerTag)((ContainerTag)TagCreator.span(" " + f.getMethod().getRawStringContent() + " " + f.getPathAsString()).withClass("is-family-monospace title is-size-4 ml-3")).withTitle(f.getPathAsString())).with(RbelHtmlRenderingToolkit.addNotes(f.getPath(), new String[0]))).withClass("has-text-link text-ellipsis")).orElse(TagCreator.span()), httpResponseFacet.map(response -> (ContainerTag)TagCreator.span(response.getResponseCode().getRawStringContent()).withClass("is-family-monospace title ml-3")).orElse(TagCreator.span("")), TagCreator.span().with(RbelMessageRenderer.buildTimingInfo(element), RbelMessageRenderer.buildAddressInfo(element)).withStyle(isRequest.map(r -> (Boolean)isRequest.get() != false ? "display: block;" : "").orElse(""))}).withClasses("title", "ml-3", "text-ellipsis", isRequest.map(req -> req != false ? "has-text-link" : "has-text-success").orElse("")));
        messageTitleElements.addAll(RbelHtmlRenderingToolkit.addNotes(element, new String[0]));
        List<DomContent> messageBodyElements = new ArrayList<ContainerTag>();
        if (httpMessageFacet.isPresent()) {
            messageBodyElements = this.performRenderingForBody(renderingToolkit, httpMessageFacet, httpRequestFacet);
        } else {
            messageBodyElements.add(renderingToolkit.convert(element));
        }
        return RbelHtmlRenderer.collapsibleCard((ContainerTag)TagCreator.div().with(messageTitleElements).withClass("full-width"), RbelHtmlRenderingToolkit.ancestorTitle().with(messageBodyElements), "msg-card", "mx-3 " + isRequest.map(r -> r != false ? "mt-5" : "mt-2").orElse("mt-3"));
    }

    private List<DomContent> performRenderingForBody(RbelHtmlRenderingToolkit renderingToolkit, Optional<RbelHttpMessageFacet> httpMessageFacet, Optional<RbelHttpRequestFacet> httpRequestFacet) {
        ArrayList headerTitleElements = new ArrayList();
        headerTitleElements.add(TagCreator.i().withClasses("fas fa-toggle-on toggle-icon is-pulled-right mr-3 is-size-3 has-text-primary"));
        headerTitleElements.add(TagCreator.div(httpRequestFacet.map(f -> RbelHtmlRenderingToolkit.t2("REQ Headers")).orElseGet(() -> RbelHtmlRenderingToolkit.t2("RES Headers"))).withClass("has-text-primary"));
        ArrayList bodyTitleElements = new ArrayList();
        bodyTitleElements.add(TagCreator.i().withClasses("fas fa-toggle-on toggle-icon is-pulled-right mr-3 is-size-3 has-text-info"));
        bodyTitleElements.add(TagCreator.div(httpRequestFacet.map(f -> RbelHtmlRenderingToolkit.t2("REQ Body")).orElseGet(() -> RbelHtmlRenderingToolkit.t2("RES Body"))).withClass("has-text-info"));
        ArrayList<DomContent> messageBodyElements = new ArrayList<DomContent>();
        messageBodyElements.add(RbelHtmlRenderingToolkit.ancestorTitle().with((DomContent)((ContainerTag)TagCreator.div().withClass("tile is-parent is-vertical pr-3")).with(new DomContent[]{TagCreator.div().with((DomContent)RbelHtmlRenderer.collapsibleCard(((ContainerTag)TagCreator.div().withClass("tile is-child pr-3")).with(headerTitleElements), renderingToolkit.convert(httpMessageFacet.get().getHeader(), Optional.empty()), "is-primary notification", "my-3")), StringUtils.isBlank(httpMessageFacet.get().getBody().getRawStringContent()) ? TagCreator.div("Empty body").withClass("is-info notification tile is-child") : TagCreator.div().with((DomContent)RbelHtmlRenderer.collapsibleCard(((ContainerTag)TagCreator.div().withClass("tile is-child pr-3")).with(bodyTitleElements), renderingToolkit.convert(httpMessageFacet.get().getBody(), Optional.empty()), "is-info notification", "my-3"))})));
        return messageBodyElements;
    }

    private DomContent getRequestOrReplySymbol(Optional<Boolean> isRequestOptional) {
        return isRequestOptional.map(isRequest -> {
            if (isRequest.booleanValue()) {
                return (ContainerTag)((ContainerTag)TagCreator.i().withClass("fas fa-share mr-3")).withTitle("Request");
            }
            return (ContainerTag)((ContainerTag)TagCreator.i().withClass("fas fa-reply mr-3")).withTitle("Response");
        }).orElse(TagCreator.span());
    }
}

