/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.data;

import de.gematik.rbellogger.converter.RbelConverter;
import de.gematik.rbellogger.data.RbelMultiMap;
import de.gematik.rbellogger.data.facet.RbelFacet;
import de.gematik.rbellogger.data.facet.RbelNestedFacet;
import de.gematik.rbellogger.data.facet.RbelNoteFacet;
import de.gematik.rbellogger.data.facet.RbelRootFacet;
import de.gematik.rbellogger.data.facet.RbelValueFacet;
import de.gematik.rbellogger.data.util.RbelElementTreePrinter;
import de.gematik.rbellogger.util.RbelException;
import de.gematik.rbellogger.util.RbelPathExecutor;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RbelElement {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RbelElement.class);
    private final String uuid;
    private final byte[] rawContent;
    private final transient RbelElement parentNode;
    private final List<RbelFacet> facets = new ArrayList<RbelFacet>();
    private Optional<Charset> charset;

    public RbelElement(byte[] rawContent, RbelElement parentNode) {
        this(null, rawContent, parentNode, Optional.empty());
    }

    public RbelElement(byte[] rawContent, RbelElement parentNode, Optional<Charset> charset) {
        this(null, rawContent, parentNode, charset);
    }

    public RbelElement(@Nullable String uuid, byte[] rawContent, RbelElement parentNode, Optional<Charset> charset) {
        this.uuid = StringUtils.isNotEmpty(uuid) ? uuid : UUID.randomUUID().toString();
        this.rawContent = rawContent;
        this.parentNode = parentNode;
        this.charset = charset == null ? Optional.empty() : charset;
    }

    public static RbelElement wrap(byte[] rawValue, @NonNull RbelElement parentNode, Object value) {
        if (parentNode == null) {
            throw new NullPointerException("parentNode is marked non-null but is null");
        }
        return new RbelElement(rawValue, parentNode).addFacet(new RbelValueFacet<Object>(value));
    }

    public static RbelElement wrap(@NonNull RbelElement parentNode, Object value) {
        if (parentNode == null) {
            throw new NullPointerException("parentNode is marked non-null but is null");
        }
        return new RbelElement(value.toString().getBytes(parentNode.getElementCharset()), parentNode).addFacet(new RbelValueFacet<Object>(value));
    }

    public <T> Optional<T> getFacet(@NonNull Class<T> clazz) {
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        return this.facets.stream().filter(facet -> clazz.isAssignableFrom(facet.getClass())).map(clazz::cast).findFirst();
    }

    public <T extends RbelFacet> boolean hasFacet(Class<T> clazz) {
        return this.getFacet(clazz).isPresent();
    }

    public RbelElement addFacet(RbelFacet facet) {
        this.facets.add(facet);
        return this;
    }

    public List<RbelElement> getChildNodes() {
        return this.facets.stream().map(RbelFacet::getChildElements).map(RbelMultiMap::getValues).flatMap(Collection::stream).map(Map.Entry::getValue).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public RbelMultiMap getChildNodesWithKey() {
        return this.facets.stream().map(RbelFacet::getChildElements).map(RbelMultiMap::getValues).flatMap(Collection::stream).filter(el -> el.getValue() != null).collect(RbelMultiMap.COLLECTOR);
    }

    public void triggerPostConversionListener(RbelConverter context) {
        for (RbelElement element : this.getChildNodes()) {
            element.triggerPostConversionListener(context);
        }
        context.triggerPostConversionListenerFor(this);
    }

    public List<RbelElement> traverseAndReturnNestedMembers() {
        return this.getChildNodes().stream().map(RbelElement::traverseAndReturnNestedMembersInternal).flatMap(Collection::stream).collect(Collectors.toList());
    }

    List<RbelElement> traverseAndReturnNestedMembersInternal() {
        log.trace("Traversing into {}: facets are {}", (Object)this.findNodePath(), (Object)this.getFacets().stream().map(Object::getClass).map(Class::getSimpleName).collect(Collectors.toList()));
        if (this.hasFacet(RbelRootFacet.class)) {
            return List.of(this);
        }
        return this.getChildNodes().stream().map(RbelElement::traverseAndReturnNestedMembersInternal).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public boolean isStructuralHelperElement() {
        return false;
    }

    public String findNodePath() {
        LinkedList<Optional<String>> keyList = new LinkedList<Optional<String>>();
        AtomicReference<RbelElement> ptr = new AtomicReference<RbelElement>(this);
        while (ptr.get().getParentNode() != null) {
            keyList.addFirst(ptr.get().getParentNode().getChildNodesWithKey().stream().filter(entry -> entry.getValue() == ptr.get()).map(Map.Entry::getKey).findFirst());
            ptr.set(ptr.get().getParentNode());
        }
        return keyList.stream().filter(Optional::isPresent).map(Optional::get).collect(Collectors.joining("."));
    }

    public Optional<RbelElement> getFirst(String key) {
        return this.getChildNodesWithKey().stream().filter(entry -> ((String)entry.getKey()).equals(key)).map(Map.Entry::getValue).findFirst();
    }

    public List<RbelElement> getAll(String key) {
        return this.getChildNodesWithKey().stream().filter(entry -> ((String)entry.getKey()).equals(key)).map(Map.Entry::getValue).collect(Collectors.toList());
    }

    public Optional<String> findKeyInParentElement() {
        return Optional.of(this).map(RbelElement::getParentNode).filter(Objects::nonNull).stream().flatMap(parent -> parent.getChildNodesWithKey().stream()).filter(e -> e.getValue() == this).map(Map.Entry::getKey).findFirst();
    }

    public List<RbelElement> findRbelPathMembers(String rbelPath) {
        return new RbelPathExecutor(this, rbelPath).execute();
    }

    @Nullable
    public String getRawStringContent() {
        if (this.rawContent == null) {
            return null;
        }
        return new String(this.rawContent, this.getElementCharset());
    }

    public Charset getElementCharset() {
        return this.charset.or(() -> Optional.ofNullable(this.parentNode).filter(Objects::nonNull).map(RbelElement::getElementCharset)).orElse(StandardCharsets.UTF_8);
    }

    public <T extends RbelFacet> T getFacetOrFail(Class<T> facetClass) {
        return (T)((RbelFacet)this.getFacet(facetClass).orElseThrow());
    }

    public String toString() {
        return new ToStringBuilder(this).append("uuid", this.uuid).append("facets", this.facets).append("path", this.findNodePath()).toString();
    }

    public Optional<Object> seekValue() {
        return this.getFacet(RbelValueFacet.class).map(RbelValueFacet::getValue).filter(Objects::nonNull);
    }

    public Optional<String> printValue() {
        return this.getFacet(RbelValueFacet.class).map(RbelValueFacet::getValue).filter(Objects::nonNull).map(Object::toString);
    }

    public <T> Optional<T> seekValue(Class<T> clazz) {
        return this.getFacet(RbelValueFacet.class).map(RbelValueFacet::getValue).filter(Objects::nonNull).filter(clazz::isInstance).map(clazz::cast);
    }

    public Optional<String> getKey() {
        if (this.parentNode == null) {
            return Optional.empty();
        }
        for (Map.Entry<String, RbelElement> ptr : this.parentNode.getChildNodesWithKey().getValues()) {
            if (ptr.getValue() != this) continue;
            return Optional.ofNullable(ptr.getKey());
        }
        throw new RbelException("Unable to find key for element " + this);
    }

    public void addOrReplaceFacet(RbelFacet facet) {
        if (this.hasFacet(facet.getClass())) {
            this.facets.remove(this.getFacet(facet.getClass()).get());
        }
        this.facets.add(facet);
    }

    public Optional<RbelElement> findElement(String rbelPath) {
        List<RbelElement> resultList = this.findRbelPathMembers(rbelPath);
        if (resultList.isEmpty()) {
            return Optional.empty();
        }
        if (resultList.size() == 1) {
            return Optional.of(resultList.get(0));
        }
        throw new RbelPathNotUniqueException("RbelPath '" + rbelPath + "' is not unique! Found " + resultList.size() + " elements, expected only one!");
    }

    public String printTreeStructureWithoutColors() {
        return RbelElementTreePrinter.builder().rootElement(this).printColors(false).build().execute();
    }

    public String printTreeStructure() {
        return RbelElementTreePrinter.builder().rootElement(this).build().execute();
    }

    public String printTreeStructure(int maximumLevels, boolean printKeys) {
        return RbelElementTreePrinter.builder().rootElement(this).printKeys(printKeys).maximumLevels(maximumLevels).build().execute();
    }

    public List<RbelNoteFacet> getNotes() {
        return this.facets.stream().flatMap(facet -> {
            if (facet instanceof RbelNestedFacet) {
                return ((RbelNestedFacet)facet).getNestedElement().getFacets().stream();
            }
            return Stream.of(facet);
        }).filter(RbelNoteFacet.class::isInstance).map(RbelNoteFacet.class::cast).collect(Collectors.toUnmodifiableList());
    }

    public RbelElement findMessage() {
        RbelElement position = this;
        while (position.getParentNode() != null) {
            position = position.getParentNode();
        }
        return position;
    }

    @Generated
    public static RbelElementBuilder builder() {
        return new RbelElementBuilder();
    }

    @Generated
    public RbelElementBuilder toBuilder() {
        return new RbelElementBuilder().uuid(this.uuid).rawContent(this.rawContent).parentNode(this.parentNode).charset(this.charset);
    }

    @Generated
    public String getUuid() {
        return this.uuid;
    }

    @Generated
    public byte[] getRawContent() {
        return this.rawContent;
    }

    @Generated
    public RbelElement getParentNode() {
        return this.parentNode;
    }

    @Generated
    public List<RbelFacet> getFacets() {
        return this.facets;
    }

    @Generated
    public void setCharset(Optional<Charset> charset) {
        this.charset = charset;
    }

    @Generated
    private Optional<Charset> getCharset() {
        return this.charset;
    }

    @Generated
    public static class RbelElementBuilder {
        @Generated
        private String uuid;
        @Generated
        private byte[] rawContent;
        @Generated
        private RbelElement parentNode;
        @Generated
        private Optional<Charset> charset;

        @Generated
        RbelElementBuilder() {
        }

        @Generated
        public RbelElementBuilder uuid(@Nullable String uuid) {
            this.uuid = uuid;
            return this;
        }

        @Generated
        public RbelElementBuilder rawContent(byte[] rawContent) {
            this.rawContent = rawContent;
            return this;
        }

        @Generated
        public RbelElementBuilder parentNode(RbelElement parentNode) {
            this.parentNode = parentNode;
            return this;
        }

        @Generated
        public RbelElementBuilder charset(Optional<Charset> charset) {
            this.charset = charset;
            return this;
        }

        @Generated
        public RbelElement build() {
            return new RbelElement(this.uuid, this.rawContent, this.parentNode, this.charset);
        }

        @Generated
        public String toString() {
            return "RbelElement.RbelElementBuilder(uuid=" + this.uuid + ", rawContent=" + Arrays.toString(this.rawContent) + ", parentNode=" + this.parentNode + ", charset=" + this.charset + ")";
        }
    }

    private static class RbelPathNotUniqueException
    extends RuntimeException {
        public RbelPathNotUniqueException(String s2) {
            super(s2);
        }
    }
}

