/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.converter;

import de.gematik.rbellogger.converter.RbelConverter;
import de.gematik.rbellogger.converter.RbelConverterPlugin;
import de.gematik.rbellogger.converter.brainpool.BrainpoolCurves;
import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.facet.RbelFacet;
import de.gematik.rbellogger.data.facet.RbelRootFacet;
import de.gematik.rbellogger.data.facet.RbelVauErpFacet;
import de.gematik.rbellogger.key.RbelKey;
import de.gematik.rbellogger.util.CryptoUtils;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECPoint;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import lombok.Generated;
import org.bouncycastle.util.encoders.DecoderException;
import org.bouncycastle.util.encoders.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RbelErpVauDecrpytionConverter
implements RbelConverterPlugin {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RbelErpVauDecrpytionConverter.class);

    @Override
    public void consumeElement(RbelElement element, RbelConverter context) {
        log.trace("Trying to decipher '{}'...", (Object)element.getRawStringContent());
        this.decipherVauMessage(element, context).ifPresent(vauMsg -> {
            element.addFacet((RbelFacet)vauMsg);
            element.addFacet(new RbelRootFacet<RbelVauErpFacet>((RbelVauErpFacet)vauMsg));
        });
    }

    private Optional<byte[]> decrypt(byte[] encMessage, ECPrivateKey secretKey) {
        try {
            if (encMessage.length < 1 || encMessage[0] != 1) {
                return Optional.empty();
            }
            ECPublicKey otherSidePublicKey = this.extractPublicKeyFromVauMessage(encMessage);
            byte[] sharedSecret = CryptoUtils.ecka(secretKey, otherSidePublicKey);
            byte[] aesKeyBytes = CryptoUtils.hkdf(sharedSecret, "ecies-vau-transport", 16);
            SecretKeySpec aesKey = new SecretKeySpec(aesKeyBytes, "AES");
            byte[] ciphertext = Arrays.copyOfRange(encMessage, 65, encMessage.length);
            log.trace("Decrypting. AesKey '{}' and ciphertext {}", (Object)Base64.getEncoder().encodeToString(aesKeyBytes), (Object)Base64.getEncoder().encodeToString(ciphertext));
            return CryptoUtils.decrypt(ciphertext, aesKey);
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    private ECPublicKey extractPublicKeyFromVauMessage(byte[] encMessage) throws NoSuchAlgorithmException, InvalidKeySpecException {
        ECPoint ecPoint = new ECPoint(new BigInteger(1, Arrays.copyOfRange(encMessage, 1, 33)), new BigInteger(1, Arrays.copyOfRange(encMessage, 33, 65)));
        ECPublicKeySpec keySpec = new ECPublicKeySpec(ecPoint, BrainpoolCurves.BP256);
        return (ECPublicKey)KeyFactory.getInstance("EC").generatePublic(keySpec);
    }

    private Optional<RbelVauErpFacet> decipherVauMessage(RbelElement element, RbelConverter converter) {
        List potentialVauKeys = converter.getRbelKeyManager().getAllKeys().filter(key -> key.getKey() instanceof ECPrivateKey || key.getKey() instanceof SecretKey).collect(Collectors.toList());
        for (RbelKey rbelKey : potentialVauKeys) {
            Optional<byte[]> decryptedBytes = this.decrypt(element.getRawContent(), rbelKey.getKey());
            if (!decryptedBytes.isPresent()) continue;
            try {
                log.trace("Succesfully deciphered VAU message! ({})", (Object)new String(decryptedBytes.get(), StandardCharsets.UTF_8));
                if (this.isVauResponse(decryptedBytes)) {
                    return this.buildVauMessageFromCleartextResponse(converter, decryptedBytes.get(), element.getRawContent(), rbelKey, element);
                }
                return this.buildVauMessageFromCleartextRequest(converter, decryptedBytes.get(), element.getRawContent(), rbelKey, element);
            }
            catch (RuntimeException e) {
                log.error("Exception while deciphering VAU message:", e);
                throw e;
            }
        }
        return Optional.empty();
    }

    private boolean isVauResponse(Optional<byte[]> decryptedBytes) {
        return decryptedBytes.map(bytes -> new String((byte[])bytes, StandardCharsets.UTF_8)).map(s2 -> s2.split("1 [\\da-f]{32} ").length).map(length -> length > 1).orElse(false);
    }

    private Optional<byte[]> decrypt(byte[] content, Key key) {
        if (key instanceof ECPrivateKey) {
            return this.decrypt(content, (ECPrivateKey)key);
        }
        if (key instanceof SecretKey) {
            return CryptoUtils.decrypt(content, key, 12, 16);
        }
        throw new RuntimeException("Unexpected key-type encountered (" + key.getClass().getSimpleName() + ")");
    }

    private Optional<RbelVauErpFacet> buildVauMessageFromCleartextRequest(RbelConverter converter, byte[] decryptedBytes, byte[] encryptedMessage, RbelKey decryptionKey, RbelElement parentNode) {
        String[] vauMessageParts = new String(decryptedBytes, StandardCharsets.UTF_8).split(" ", 5);
        SecretKeySpec responseKey = this.buildAesKeyFromHex(vauMessageParts[3]);
        converter.getRbelKeyManager().addKey("VAU Response-Key", responseKey, 0);
        return Optional.of(RbelVauErpFacet.builder().message(converter.convertElement(vauMessageParts[4], parentNode)).encryptedMessage(RbelElement.wrap(encryptedMessage, parentNode, null)).requestId(RbelElement.wrap(parentNode, vauMessageParts[2])).pVersionNumber(RbelElement.wrap(parentNode, Integer.parseInt(vauMessageParts[0]))).responseKey(RbelElement.wrap(parentNode, responseKey)).keyIdUsed(RbelElement.wrap(parentNode, decryptionKey.getKeyName())).decryptedPString(RbelElement.wrap(decryptedBytes, parentNode, new String(decryptedBytes, StandardCharsets.UTF_8))).keyUsed(Optional.of(decryptionKey)).build());
    }

    private Optional<RbelVauErpFacet> buildVauMessageFromCleartextResponse(RbelConverter converter, byte[] decryptedBytes, byte[] encryptedMessage, RbelKey keyUsed, RbelElement parentNode) {
        String[] vauMessageParts = new String(decryptedBytes, StandardCharsets.UTF_8).split(" ", 3);
        return Optional.of(RbelVauErpFacet.builder().message(converter.convertElement(vauMessageParts[2], parentNode)).encryptedMessage(RbelElement.wrap(parentNode, encryptedMessage)).requestId(RbelElement.wrap(parentNode, vauMessageParts[1])).pVersionNumber(RbelElement.wrap(parentNode, Integer.parseInt(vauMessageParts[0]))).keyIdUsed(RbelElement.wrap(parentNode, keyUsed.getKeyName())).keyUsed(Optional.of(keyUsed)).decryptedPString(RbelElement.wrap(parentNode, new String(decryptedBytes, StandardCharsets.UTF_8))).build());
    }

    private SecretKeySpec buildAesKeyFromHex(String hexEncodedKey) {
        try {
            return new SecretKeySpec(Hex.decode(hexEncodedKey), "AES");
        }
        catch (DecoderException e) {
            throw new RuntimeException("Error during Key decoding from '" + hexEncodedKey + "'", e);
        }
    }
}

