/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.util;

import de.gematik.rbellogger.converter.RbelConverter;
import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.RbelHostname;
import de.gematik.rbellogger.data.facet.RbelHostnameFacet;
import de.gematik.rbellogger.data.facet.RbelMessageTimingFacet;
import de.gematik.rbellogger.data.facet.RbelTcpIpMessageFacet;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONObject;

public class RbelFileWriterUtils {
    public static final String FILE_DIVIDER = "\n";
    private static final String RAW_MESSAGE_CONTENT = "rawMessageContent";
    private static final String SENDER_HOSTNAME = "senderHostname";
    private static final String RECEIVER_HOSTNAME = "receiverHostname";
    private static final String SEQUENCE_NUMBER = "sequenceNumber";
    private static final String MESSAGE_TIME = "timestamp";
    private static final String MESSAGE_UUID = "uuid";

    public static String convertToRbelFileString(RbelElement rbelElement) {
        JSONObject jsonObject = new JSONObject(Map.of(RAW_MESSAGE_CONTENT, Base64.getEncoder().encodeToString(rbelElement.getRawContent()), SENDER_HOSTNAME, rbelElement.getFacet(RbelTcpIpMessageFacet.class).map(RbelTcpIpMessageFacet::getSender).filter(Objects::nonNull).flatMap(element -> element.getFacet(RbelHostnameFacet.class)).map(RbelHostnameFacet::toString).orElse(""), RECEIVER_HOSTNAME, rbelElement.getFacet(RbelTcpIpMessageFacet.class).map(RbelTcpIpMessageFacet::getReceiver).filter(Objects::nonNull).flatMap(element -> element.getFacet(RbelHostnameFacet.class)).map(RbelHostnameFacet::toString).orElse(""), SEQUENCE_NUMBER, rbelElement.getFacet(RbelTcpIpMessageFacet.class).map(RbelTcpIpMessageFacet::getSequenceNumber).map(Object::toString).orElse(""), MESSAGE_TIME, rbelElement.getFacet(RbelMessageTimingFacet.class).map(RbelMessageTimingFacet::getTransmissionTime).map(Object::toString).orElse(""), MESSAGE_UUID, rbelElement.getUuid()));
        return jsonObject + FILE_DIVIDER;
    }

    public static List<RbelElement> convertFromRbelFile(String rbelFileContent, RbelConverter rbelConverter) {
        return Arrays.stream(rbelFileContent.split(FILE_DIVIDER)).filter(StringUtils::isNotEmpty).map(JSONObject::new).map(content -> RbelFileWriterUtils.parseFileObject(rbelConverter, content)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    private static Optional<RbelElement> parseFileObject(RbelConverter rbelConverter, JSONObject messageObject) {
        try {
            String msgUuid = messageObject.optString(MESSAGE_UUID);
            if (new ArrayList<RbelElement>(rbelConverter.getMessageHistory()).stream().anyMatch(msg -> msg.getUuid().equals(msgUuid))) {
                return Optional.empty();
            }
            return Optional.of(rbelConverter.parseMessage(RbelElement.builder().rawContent(Base64.getDecoder().decode(messageObject.getString(RAW_MESSAGE_CONTENT))).uuid(msgUuid).parentNode(null).build(), (RbelHostname)RbelHostname.fromString(messageObject.getString(SENDER_HOSTNAME)).orElse(null), (RbelHostname)RbelHostname.fromString(messageObject.getString(RECEIVER_HOSTNAME)).orElse(null), messageObject.has(MESSAGE_TIME) ? RbelFileWriterUtils.parseTransmissionTimeFromString(messageObject.getString(MESSAGE_TIME)) : Optional.empty()));
        }
        catch (Exception e) {
            throw new RbelFileReadingException("Error while converting from object '" + messageObject.toString() + "'", e);
        }
    }

    private static Optional<ZonedDateTime> parseTransmissionTimeFromString(String time) {
        if (StringUtils.isBlank((CharSequence)time)) {
            return Optional.empty();
        }
        return Optional.of(ZonedDateTime.parse(time));
    }

    @Generated
    private RbelFileWriterUtils() {
    }

    private static class RbelFileReadingException
    extends RuntimeException {
        public RbelFileReadingException(String s, Exception e) {
            super(s, e);
        }
    }
}

