/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.converter.listener;

import de.gematik.rbellogger.configuration.RbelFileSaveInfo;
import de.gematik.rbellogger.converter.RbelConverter;
import de.gematik.rbellogger.converter.RbelConverterPlugin;
import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.facet.RbelTcpIpMessageFacet;
import de.gematik.rbellogger.util.RbelFileWriterUtils;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import lombok.Generated;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;

public class RbelFileAppenderPlugin
implements RbelConverterPlugin {
    private final RbelFileSaveInfo fileSaveInfo;

    public RbelFileAppenderPlugin(RbelFileSaveInfo fileSaveInfo) {
        this.fileSaveInfo = fileSaveInfo;
        if (fileSaveInfo.isWriteToFile() && StringUtils.isNotEmpty((CharSequence)fileSaveInfo.getFilename()) && fileSaveInfo.isClearFileOnBoot()) {
            FileUtils.deleteQuietly((File)new File(fileSaveInfo.getFilename()));
        }
    }

    @Override
    public void consumeElement(RbelElement rbelElement, RbelConverter converter) {
        if (this.fileSaveInfo.isWriteToFile() && StringUtils.isNotEmpty((CharSequence)this.fileSaveInfo.getFilename()) && rbelElement.hasFacet(RbelTcpIpMessageFacet.class)) {
            try {
                FileUtils.writeStringToFile((File)new File(this.fileSaveInfo.getFilename()), (String)RbelFileWriterUtils.convertToRbelFileString(rbelElement), (Charset)Charset.defaultCharset(), (boolean)true);
            }
            catch (IOException e) {
                throw new RuntimeException("Exception while trying to save RbelElement to file '" + this.fileSaveInfo.getFilename() + "'!", e);
            }
        }
    }

    @Generated
    public RbelFileSaveInfo getFileSaveInfo() {
        return this.fileSaveInfo;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RbelFileAppenderPlugin)) {
            return false;
        }
        RbelFileAppenderPlugin other = (RbelFileAppenderPlugin)o;
        if (!other.canEqual(this)) {
            return false;
        }
        RbelFileSaveInfo this$fileSaveInfo = this.getFileSaveInfo();
        RbelFileSaveInfo other$fileSaveInfo = other.getFileSaveInfo();
        return !(this$fileSaveInfo == null ? other$fileSaveInfo != null : !((Object)this$fileSaveInfo).equals(other$fileSaveInfo));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RbelFileAppenderPlugin;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        RbelFileSaveInfo $fileSaveInfo = this.getFileSaveInfo();
        result = result * 59 + ($fileSaveInfo == null ? 43 : ((Object)$fileSaveInfo).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "RbelFileAppenderPlugin(fileSaveInfo=" + this.getFileSaveInfo() + ")";
    }
}

