/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.converter;

import de.gematik.rbellogger.converter.RbelConverter;
import de.gematik.rbellogger.converter.RbelConverterPlugin;
import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.facet.RbelBinaryFacet;
import de.gematik.rbellogger.data.facet.RbelFacet;
import de.gematik.rbellogger.data.facet.RbelSicctCommandFacet;
import de.gematik.rbellogger.data.facet.RbelSicctEnvelopeFacet;
import de.gematik.rbellogger.data.facet.RbelSicctHeaderFacet;
import de.gematik.rbellogger.data.sicct.RbelSicctCommand;
import de.gematik.rbellogger.data.sicct.SicctMessageType;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RbelSicctCommandConverter
implements RbelConverterPlugin {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RbelSicctCommandConverter.class);

    @Override
    public void consumeElement(RbelElement element, RbelConverter context) {
        if (element.getParentNode() == null) {
            return;
        }
        if (element.getParentNode().hasFacet(RbelSicctEnvelopeFacet.class) && this.findMessageType(element).map(msgType -> msgType == SicctMessageType.C_COMMAND).orElse(false).booleanValue()) {
            RbelSicctCommandFacet sicctCommandFacet = this.buildBodyFacet(element);
            element.addFacet(sicctCommandFacet);
            context.convertElement(sicctCommandFacet.getHeader());
            context.convertElement(sicctCommandFacet.getBody());
        } else if (element.getParentNode().hasFacet(RbelSicctCommandFacet.class) && this.findMessageType(element).map(msgType -> msgType == SicctMessageType.C_COMMAND).orElse(false).booleanValue()) {
            element.addFacet(this.buildHeaderFacet(element));
        }
    }

    private RbelFacet buildHeaderFacet(RbelElement element) {
        RbelElement cla = new RbelElement(ArrayUtils.subarray((byte[])element.getRawContent(), (int)0, (int)1), element);
        RbelElement ins = new RbelElement(ArrayUtils.subarray((byte[])element.getRawContent(), (int)1, (int)2), element);
        RbelElement p1 = new RbelElement(ArrayUtils.subarray((byte[])element.getRawContent(), (int)2, (int)3), element);
        RbelElement p2 = new RbelElement(ArrayUtils.subarray((byte[])element.getRawContent(), (int)3, (int)4), element);
        cla.addFacet(new RbelBinaryFacet());
        ins.addFacet(new RbelBinaryFacet());
        p1.addFacet(new RbelBinaryFacet());
        p2.addFacet(new RbelBinaryFacet());
        return RbelSicctHeaderFacet.builder().cla(cla).ins(ins).p1(p1).p2(p2).command(RbelSicctCommand.from(cla, ins).orElse(null)).build();
    }

    private RbelSicctCommandFacet buildBodyFacet(RbelElement element) {
        byte[] header = ArrayUtils.subarray((byte[])element.getRawContent(), (int)0, (int)4);
        byte[] body = ArrayUtils.subarray((byte[])element.getRawContent(), (int)4, (int)element.getRawContent().length);
        return RbelSicctCommandFacet.builder().header(new RbelElement(header, element)).body(new RbelElement(body, element)).build();
    }

    private Optional<SicctMessageType> findMessageType(RbelElement element) {
        return element.getFacet(RbelSicctEnvelopeFacet.class).or(() -> element.getParentNode().getFacet(RbelSicctEnvelopeFacet.class)).or(() -> element.getParentNode().getParentNode().getFacet(RbelSicctEnvelopeFacet.class)).map(RbelSicctEnvelopeFacet::getMessageType).flatMap(RbelElement::seekValue).filter(SicctMessageType.class::isInstance).map(SicctMessageType.class::cast);
    }
}

