/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.converter;

import de.gematik.rbellogger.RbelOptions;
import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.RbelMultiMap;
import de.gematik.rbellogger.data.facet.RbelHttpHeaderFacet;
import de.gematik.rbellogger.data.facet.RbelHttpMessageFacet;
import de.gematik.rbellogger.data.facet.RbelHttpRequestFacet;
import de.gematik.rbellogger.data.facet.RbelHttpResponseFacet;
import de.gematik.rbellogger.data.facet.RbelJsonFacet;
import de.gematik.rbellogger.data.facet.RbelNestedFacet;
import java.beans.ConstructorProperties;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.jexl3.JexlBuilder;
import org.apache.commons.jexl3.JexlContext;
import org.apache.commons.jexl3.JexlExpression;
import org.apache.commons.jexl3.MapContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RbelJexlExecutor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RbelJexlExecutor.class);
    private static final Map<Integer, JexlExpression> JEXL_EXPRESSION_CACHE = new HashMap<Integer, JexlExpression>();

    public boolean matchesAsJexlExpression(Object element, String jexlExpression) {
        return this.matchesAsJexlExpression(element, jexlExpression, Optional.empty());
    }

    public boolean matchesAsJexlExpression(Object element, String jexlExpression, Optional<String> key) {
        try {
            JexlExpression expression = this.buildExpression(this.evaluateRbelPathExpressions(jexlExpression, element));
            MapContext mapContext = new MapContext(this.buildJexlMapContext(element, key));
            boolean result = Optional.of(expression.evaluate((JexlContext)mapContext)).filter(Boolean.class::isInstance).map(Boolean.class::cast).orElse(false);
            if (result && RbelOptions.ACTIVATE_JEXL_DEBUGGING) {
                if (element instanceof RbelElement) {
                    log.debug("Found match: '{}' with path {} matches '{}'", new Object[]{element, ((RbelElement)element).findNodePath(), jexlExpression});
                } else {
                    log.debug("Found match: '{}' matches '{}'", element, (Object)jexlExpression);
                }
            }
            return result;
        }
        catch (Exception e) {
            if (RbelOptions.ACTIVATE_JEXL_DEBUGGING) {
                log.info("Error during Jexl-Evaluation.", (Throwable)e);
            }
            return false;
        }
    }

    private String evaluateRbelPathExpressions(String jexlExpression, Object element) {
        if (!(element instanceof RbelElement) || !jexlExpression.contains("$.")) {
            return jexlExpression;
        }
        String rbelPath = Arrays.stream(jexlExpression.split(" ")).filter(str -> str.startsWith("$.") && str.length() > 2).findAny().orElseThrow();
        return jexlExpression.replace(rbelPath, "\"" + ((RbelElement)element).findElement(rbelPath).map(RbelElement::getRawStringContent).orElse("") + "\"");
    }

    private JexlExpression buildExpression(String jexlExpression) {
        int hashCode = jexlExpression.hashCode();
        if (JEXL_EXPRESSION_CACHE.containsKey(hashCode)) {
            return JEXL_EXPRESSION_CACHE.get(hashCode);
        }
        JexlExpression expression = new JexlBuilder().create().createExpression(jexlExpression);
        JEXL_EXPRESSION_CACHE.put(hashCode, expression);
        return expression;
    }

    public Map<String, Object> buildJexlMapContext(Object element, Optional<String> key) {
        Optional<RbelElement> requestMessage;
        HashMap<String, Object> mapContext = new HashMap<String, Object>();
        Optional<RbelElement> parentElement = this.getParentElement(element);
        mapContext.put("element", element);
        mapContext.put("parent", parentElement.orElse(null));
        Optional<RbelElement> message = this.findMessage(element);
        mapContext.put("message", message.map(this::convertToJexlMessage).orElse(null));
        if (element instanceof RbelElement) {
            mapContext.put("charset", ((RbelElement)element).getElementCharset().displayName());
            mapContext.put("@", this.buildPositionDescriptor((RbelElement)element));
        }
        if ((requestMessage = this.tryToFindRequestMessage(element)).filter(msg -> message.isPresent()).map(msg -> message.get() == msg).orElse(false).booleanValue()) {
            mapContext.put("request", mapContext.get("message"));
            mapContext.put("isRequest", true);
            mapContext.put("isResponse", false);
        } else {
            mapContext.put("request", requestMessage.map(this::convertToJexlMessage).orElse(null));
            mapContext.put("isRequest", false);
            mapContext.put("isResponse", true);
        }
        mapContext.put("facets", Optional.ofNullable(element).filter(RbelElement.class::isInstance).map(RbelElement.class::cast).map(RbelElement::getFacets).stream().flatMap(Collection::stream).map(Object::getClass).map(Class::getSimpleName).collect(Collectors.toSet()));
        mapContext.put("key", key.or(() -> this.tryToFindKeyFromParentMap(element, parentElement)).orElse(null));
        mapContext.put("path", Optional.ofNullable(element).filter(RbelElement.class::isInstance).map(RbelElement.class::cast).map(RbelElement::findNodePath).orElse(null));
        mapContext.put("type", element.getClass().getSimpleName());
        if (element instanceof RbelElement) {
            mapContext.put("content", ((RbelElement)element).getRawStringContent());
        } else {
            mapContext.put("content", element.toString());
        }
        return mapContext;
    }

    private Map<String, String> buildPositionDescriptor(RbelElement element) {
        HashMap<String, String> result = new HashMap<String, String>();
        element.getChildNodesWithKey().stream().forEach(entry -> {
            if (((RbelElement)entry.getValue()).hasFacet(RbelJsonFacet.class) && ((RbelElement)entry.getValue()).hasFacet(RbelNestedFacet.class)) {
                result.put((String)entry.getKey(), ((RbelElement)entry.getValue()).getFacetOrFail(RbelNestedFacet.class).getNestedElement().getRawStringContent());
            } else {
                result.put((String)entry.getKey(), ((RbelElement)entry.getValue()).getRawStringContent());
            }
        });
        return result;
    }

    private Optional<RbelElement> tryToFindRequestMessage(Object element) {
        if (!(element instanceof RbelElement)) {
            return Optional.empty();
        }
        Optional<RbelElement> message = this.findMessage(element);
        if (message.isEmpty()) {
            return Optional.empty();
        }
        if (message.get().getFacet(RbelHttpRequestFacet.class).isPresent()) {
            return message;
        }
        return message.flatMap(el -> el.getFacet(RbelHttpResponseFacet.class)).map(RbelHttpResponseFacet::getRequest);
    }

    private JexlMessage convertToJexlMessage(RbelElement element) {
        Optional<RbelElement> bodyOptional = element.getFirst("body");
        return JexlMessage.builder().request(element.getFacet(RbelHttpRequestFacet.class).isPresent()).response(element.getFacet(RbelHttpResponseFacet.class).isPresent()).method(element.getFacet(RbelHttpRequestFacet.class).map(RbelHttpRequestFacet::getMethod).map(RbelElement::getRawStringContent).orElse(null)).url(element.getFacet(RbelHttpRequestFacet.class).map(RbelHttpRequestFacet::getPath).map(RbelElement::getRawStringContent).orElse(null)).bodyAsString(bodyOptional.map(RbelElement::getRawStringContent).orElse(null)).body(bodyOptional.orElse(null)).headers(element.getFacet(RbelHttpMessageFacet.class).map(RbelHttpMessageFacet::getHeader).flatMap(el -> el.getFacet(RbelHttpHeaderFacet.class)).filter(RbelHttpHeaderFacet.class::isInstance).map(RbelHttpHeaderFacet.class::cast).map(RbelHttpHeaderFacet::entries).stream().flatMap(Collection::stream).collect(Collectors.groupingBy(e -> (String)e.getKey(), Collectors.mapping(e -> ((RbelElement)e.getValue()).getRawStringContent(), Collectors.toList())))).build();
    }

    private Optional<RbelElement> findMessage(Object element) {
        RbelElement ptr;
        if (!(element instanceof RbelElement)) {
            return Optional.empty();
        }
        for (ptr = (RbelElement)element; ptr.getParentNode() != null && ptr.getParentNode() != ptr; ptr = ptr.getParentNode()) {
        }
        if (ptr.hasFacet(RbelHttpMessageFacet.class) && ptr.getParentNode() == null) {
            return Optional.of(ptr);
        }
        return Optional.empty();
    }

    private Optional<RbelElement> getParentElement(Object element) {
        return Optional.ofNullable(element).filter(RbelElement.class::isInstance).map(RbelElement.class::cast).map(RbelElement::getParentNode);
    }

    private Optional<String> tryToFindKeyFromParentMap(Object element, Optional<RbelElement> parent) {
        return parent.stream().map(RbelElement::getChildNodesWithKey).flatMap(RbelMultiMap::stream).filter(entry -> entry.getValue() == element).map(Map.Entry::getKey).findFirst();
    }

    @Generated
    public RbelJexlExecutor() {
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RbelJexlExecutor)) {
            return false;
        }
        RbelJexlExecutor other = (RbelJexlExecutor)o;
        return other.canEqual(this);
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RbelJexlExecutor;
    }

    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }

    @Generated
    public String toString() {
        return "RbelJexlExecutor()";
    }

    public static class JexlMessage {
        public final String method;
        public final String url;
        public final boolean request;
        public final boolean response;
        public final Map<String, List<String>> headers;
        public final String bodyAsString;
        public final RbelElement body;

        @ConstructorProperties(value={"method", "url", "request", "response", "headers", "bodyAsString", "body"})
        @Generated
        JexlMessage(String method, String url, boolean request, boolean response, Map<String, List<String>> headers, String bodyAsString, RbelElement body) {
            this.method = method;
            this.url = url;
            this.request = request;
            this.response = response;
            this.headers = headers;
            this.bodyAsString = bodyAsString;
            this.body = body;
        }

        @Generated
        public static JexlMessageBuilder builder() {
            return new JexlMessageBuilder();
        }

        @Generated
        public String getMethod() {
            return this.method;
        }

        @Generated
        public String getUrl() {
            return this.url;
        }

        @Generated
        public boolean isRequest() {
            return this.request;
        }

        @Generated
        public boolean isResponse() {
            return this.response;
        }

        @Generated
        public Map<String, List<String>> getHeaders() {
            return this.headers;
        }

        @Generated
        public String getBodyAsString() {
            return this.bodyAsString;
        }

        @Generated
        public RbelElement getBody() {
            return this.body;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof JexlMessage)) {
                return false;
            }
            JexlMessage other = (JexlMessage)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isRequest() != other.isRequest()) {
                return false;
            }
            if (this.isResponse() != other.isResponse()) {
                return false;
            }
            String this$method = this.getMethod();
            String other$method = other.getMethod();
            if (this$method == null ? other$method != null : !this$method.equals(other$method)) {
                return false;
            }
            String this$url = this.getUrl();
            String other$url = other.getUrl();
            if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
                return false;
            }
            Map<String, List<String>> this$headers = this.getHeaders();
            Map<String, List<String>> other$headers = other.getHeaders();
            if (this$headers == null ? other$headers != null : !((Object)this$headers).equals(other$headers)) {
                return false;
            }
            String this$bodyAsString = this.getBodyAsString();
            String other$bodyAsString = other.getBodyAsString();
            if (this$bodyAsString == null ? other$bodyAsString != null : !this$bodyAsString.equals(other$bodyAsString)) {
                return false;
            }
            RbelElement this$body = this.getBody();
            RbelElement other$body = other.getBody();
            return !(this$body == null ? other$body != null : !this$body.equals(other$body));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof JexlMessage;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isRequest() ? 79 : 97);
            result = result * 59 + (this.isResponse() ? 79 : 97);
            String $method = this.getMethod();
            result = result * 59 + ($method == null ? 43 : $method.hashCode());
            String $url = this.getUrl();
            result = result * 59 + ($url == null ? 43 : $url.hashCode());
            Map<String, List<String>> $headers = this.getHeaders();
            result = result * 59 + ($headers == null ? 43 : ((Object)$headers).hashCode());
            String $bodyAsString = this.getBodyAsString();
            result = result * 59 + ($bodyAsString == null ? 43 : $bodyAsString.hashCode());
            RbelElement $body = this.getBody();
            result = result * 59 + ($body == null ? 43 : $body.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "RbelJexlExecutor.JexlMessage(method=" + this.getMethod() + ", url=" + this.getUrl() + ", request=" + this.isRequest() + ", response=" + this.isResponse() + ", headers=" + this.getHeaders() + ", bodyAsString=" + this.getBodyAsString() + ", body=" + this.getBody() + ")";
        }

        @Generated
        public static class JexlMessageBuilder {
            @Generated
            private String method;
            @Generated
            private String url;
            @Generated
            private boolean request;
            @Generated
            private boolean response;
            @Generated
            private Map<String, List<String>> headers;
            @Generated
            private String bodyAsString;
            @Generated
            private RbelElement body;

            @Generated
            JexlMessageBuilder() {
            }

            @Generated
            public JexlMessageBuilder method(String method) {
                this.method = method;
                return this;
            }

            @Generated
            public JexlMessageBuilder url(String url) {
                this.url = url;
                return this;
            }

            @Generated
            public JexlMessageBuilder request(boolean request) {
                this.request = request;
                return this;
            }

            @Generated
            public JexlMessageBuilder response(boolean response) {
                this.response = response;
                return this;
            }

            @Generated
            public JexlMessageBuilder headers(Map<String, List<String>> headers) {
                this.headers = headers;
                return this;
            }

            @Generated
            public JexlMessageBuilder bodyAsString(String bodyAsString) {
                this.bodyAsString = bodyAsString;
                return this;
            }

            @Generated
            public JexlMessageBuilder body(RbelElement body) {
                this.body = body;
                return this;
            }

            @Generated
            public JexlMessage build() {
                return new JexlMessage(this.method, this.url, this.request, this.response, this.headers, this.bodyAsString, this.body);
            }

            @Generated
            public String toString() {
                return "RbelJexlExecutor.JexlMessage.JexlMessageBuilder(method=" + this.method + ", url=" + this.url + ", request=" + this.request + ", response=" + this.response + ", headers=" + this.headers + ", bodyAsString=" + this.bodyAsString + ", body=" + this.body + ")";
            }
        }
    }
}

