/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.converter;

import de.gematik.rbellogger.converter.RbelConverter;
import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.RbelMultiMap;
import de.gematik.rbellogger.data.facet.RbelXmlFacet;
import java.io.IOException;
import java.util.Locale;
import java.util.Optional;
import lombok.Generated;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Attribute;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

class RbelHtmlConverter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RbelHtmlConverter.class);
    private static final String XML_TEXT_KEY = "text";

    RbelHtmlConverter() {
    }

    Optional<Document> parseHtml(String text) throws IOException, SAXException {
        String lowerCase = text.toLowerCase(Locale.ROOT);
        if (!(lowerCase.contains("<html") && lowerCase.contains("</html>") && lowerCase.startsWith("<"))) {
            return Optional.empty();
        }
        return Optional.of(Jsoup.parse((String)text));
    }

    void buildXmlElementForNode(Node branch, RbelElement parentElement, RbelConverter converter) {
        RbelMultiMap childElements = new RbelMultiMap();
        parentElement.addFacet(RbelXmlFacet.builder().childElements(childElements).build());
        for (Node childNode : branch.childNodes()) {
            if (childNode instanceof TextNode) {
                childElements.put(XML_TEXT_KEY, converter.convertElement(((TextNode)childNode).getWholeText(), parentElement));
                continue;
            }
            RbelElement rbelChildElement = new RbelElement(childNode.toString().getBytes(), parentElement);
            childElements.put(childNode.nodeName(), rbelChildElement);
            this.buildXmlElementForNode(childNode, rbelChildElement, converter);
        }
        if (branch instanceof Element) {
            for (Attribute attribute : branch.attributes()) {
                childElements.put(attribute.getKey(), converter.convertElement(attribute.getValue(), parentElement));
            }
        }
    }
}

