/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.configuration;

import de.gematik.rbellogger.RbelLogger;
import de.gematik.rbellogger.captures.RbelCapturer;
import de.gematik.rbellogger.configuration.RbelFileSaveInfo;
import de.gematik.rbellogger.converter.RbelConverter;
import de.gematik.rbellogger.converter.RbelConverterPlugin;
import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.key.RbelKey;
import java.beans.ConstructorProperties;
import java.security.Key;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import lombok.Generated;

public class RbelConfiguration {
    private List<RbelConverterPlugin> postConversionListener;
    private Map<Class<? extends RbelElement>, List<BiFunction<RbelElement, RbelConverter, RbelElement>>> preConversionMappers;
    private List<Consumer<RbelConverter>> initializers;
    private Map<String, RbelKey> keys;
    private RbelCapturer capturer;
    private boolean activateAsn1Parsing;
    private RbelFileSaveInfo fileSaveInfo;
    private int rbelBufferSizeInMb;
    private boolean manageBuffer;

    public RbelConfiguration addPostConversionListener(RbelConverterPlugin listener) {
        this.postConversionListener.add(listener);
        return this;
    }

    public RbelConfiguration withFileSaveInfo(RbelFileSaveInfo fileSaveInfo) {
        this.fileSaveInfo = fileSaveInfo;
        return this;
    }

    public <T extends RbelElement> RbelConfiguration addPreConversionMapper(Class<T> clazz, BiFunction<T, RbelConverter, RbelElement> mapper) {
        if (!this.preConversionMappers.containsKey(clazz)) {
            this.preConversionMappers.put(clazz, new ArrayList());
        }
        this.preConversionMappers.get(clazz).add((rawKey, context) -> (RbelElement)mapper.apply((Object)rawKey, (RbelConverter)context));
        return this;
    }

    public RbelConfiguration addInitializer(Consumer<RbelConverter> initializer) {
        this.initializers.add(initializer);
        return this;
    }

    public RbelConfiguration addKey(String keyId, Key key, int precedence) {
        this.keys.put(keyId, RbelKey.builder().key(key).keyName(keyId).precedence(precedence).build());
        return this;
    }

    public RbelConfiguration addCapturer(RbelCapturer capturer) {
        this.capturer = capturer;
        return this;
    }

    public RbelConfiguration setActivateAsn1Parsing(boolean activateAsn1Parsing) {
        this.activateAsn1Parsing = activateAsn1Parsing;
        return this;
    }

    public RbelLogger constructRbelLogger() {
        return RbelLogger.build(this);
    }

    @Generated
    private static List<RbelConverterPlugin> $default$postConversionListener() {
        return new ArrayList<RbelConverterPlugin>();
    }

    @Generated
    private static Map<Class<? extends RbelElement>, List<BiFunction<RbelElement, RbelConverter, RbelElement>>> $default$preConversionMappers() {
        return new HashMap<Class<? extends RbelElement>, List<BiFunction<RbelElement, RbelConverter, RbelElement>>>();
    }

    @Generated
    private static List<Consumer<RbelConverter>> $default$initializers() {
        return new ArrayList<Consumer<RbelConverter>>();
    }

    @Generated
    private static Map<String, RbelKey> $default$keys() {
        return new HashMap<String, RbelKey>();
    }

    @Generated
    private static boolean $default$activateAsn1Parsing() {
        return true;
    }

    @Generated
    private static int $default$rbelBufferSizeInMb() {
        return 1024;
    }

    @Generated
    private static boolean $default$manageBuffer() {
        return false;
    }

    @Generated
    public static RbelConfigurationBuilder builder() {
        return new RbelConfigurationBuilder();
    }

    @Generated
    public List<RbelConverterPlugin> getPostConversionListener() {
        return this.postConversionListener;
    }

    @Generated
    public Map<Class<? extends RbelElement>, List<BiFunction<RbelElement, RbelConverter, RbelElement>>> getPreConversionMappers() {
        return this.preConversionMappers;
    }

    @Generated
    public List<Consumer<RbelConverter>> getInitializers() {
        return this.initializers;
    }

    @Generated
    public Map<String, RbelKey> getKeys() {
        return this.keys;
    }

    @Generated
    public RbelCapturer getCapturer() {
        return this.capturer;
    }

    @Generated
    public boolean isActivateAsn1Parsing() {
        return this.activateAsn1Parsing;
    }

    @Generated
    public RbelFileSaveInfo getFileSaveInfo() {
        return this.fileSaveInfo;
    }

    @Generated
    public int getRbelBufferSizeInMb() {
        return this.rbelBufferSizeInMb;
    }

    @Generated
    public boolean isManageBuffer() {
        return this.manageBuffer;
    }

    @Generated
    public void setPostConversionListener(List<RbelConverterPlugin> postConversionListener) {
        this.postConversionListener = postConversionListener;
    }

    @Generated
    public void setPreConversionMappers(Map<Class<? extends RbelElement>, List<BiFunction<RbelElement, RbelConverter, RbelElement>>> preConversionMappers) {
        this.preConversionMappers = preConversionMappers;
    }

    @Generated
    public void setInitializers(List<Consumer<RbelConverter>> initializers) {
        this.initializers = initializers;
    }

    @Generated
    public void setKeys(Map<String, RbelKey> keys) {
        this.keys = keys;
    }

    @Generated
    public void setCapturer(RbelCapturer capturer) {
        this.capturer = capturer;
    }

    @Generated
    public void setFileSaveInfo(RbelFileSaveInfo fileSaveInfo) {
        this.fileSaveInfo = fileSaveInfo;
    }

    @Generated
    public void setRbelBufferSizeInMb(int rbelBufferSizeInMb) {
        this.rbelBufferSizeInMb = rbelBufferSizeInMb;
    }

    @Generated
    public void setManageBuffer(boolean manageBuffer) {
        this.manageBuffer = manageBuffer;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RbelConfiguration)) {
            return false;
        }
        RbelConfiguration other = (RbelConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isActivateAsn1Parsing() != other.isActivateAsn1Parsing()) {
            return false;
        }
        if (this.getRbelBufferSizeInMb() != other.getRbelBufferSizeInMb()) {
            return false;
        }
        if (this.isManageBuffer() != other.isManageBuffer()) {
            return false;
        }
        List<RbelConverterPlugin> this$postConversionListener = this.getPostConversionListener();
        List<RbelConverterPlugin> other$postConversionListener = other.getPostConversionListener();
        if (this$postConversionListener == null ? other$postConversionListener != null : !((Object)this$postConversionListener).equals(other$postConversionListener)) {
            return false;
        }
        Map<Class<? extends RbelElement>, List<BiFunction<RbelElement, RbelConverter, RbelElement>>> this$preConversionMappers = this.getPreConversionMappers();
        Map<Class<? extends RbelElement>, List<BiFunction<RbelElement, RbelConverter, RbelElement>>> other$preConversionMappers = other.getPreConversionMappers();
        if (this$preConversionMappers == null ? other$preConversionMappers != null : !((Object)this$preConversionMappers).equals(other$preConversionMappers)) {
            return false;
        }
        List<Consumer<RbelConverter>> this$initializers = this.getInitializers();
        List<Consumer<RbelConverter>> other$initializers = other.getInitializers();
        if (this$initializers == null ? other$initializers != null : !((Object)this$initializers).equals(other$initializers)) {
            return false;
        }
        Map<String, RbelKey> this$keys = this.getKeys();
        Map<String, RbelKey> other$keys = other.getKeys();
        if (this$keys == null ? other$keys != null : !((Object)this$keys).equals(other$keys)) {
            return false;
        }
        RbelCapturer this$capturer = this.getCapturer();
        RbelCapturer other$capturer = other.getCapturer();
        if (this$capturer == null ? other$capturer != null : !((Object)this$capturer).equals(other$capturer)) {
            return false;
        }
        RbelFileSaveInfo this$fileSaveInfo = this.getFileSaveInfo();
        RbelFileSaveInfo other$fileSaveInfo = other.getFileSaveInfo();
        return !(this$fileSaveInfo == null ? other$fileSaveInfo != null : !((Object)this$fileSaveInfo).equals(other$fileSaveInfo));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RbelConfiguration;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isActivateAsn1Parsing() ? 79 : 97);
        result = result * 59 + this.getRbelBufferSizeInMb();
        result = result * 59 + (this.isManageBuffer() ? 79 : 97);
        List<RbelConverterPlugin> $postConversionListener = this.getPostConversionListener();
        result = result * 59 + ($postConversionListener == null ? 43 : ((Object)$postConversionListener).hashCode());
        Map<Class<? extends RbelElement>, List<BiFunction<RbelElement, RbelConverter, RbelElement>>> $preConversionMappers = this.getPreConversionMappers();
        result = result * 59 + ($preConversionMappers == null ? 43 : ((Object)$preConversionMappers).hashCode());
        List<Consumer<RbelConverter>> $initializers = this.getInitializers();
        result = result * 59 + ($initializers == null ? 43 : ((Object)$initializers).hashCode());
        Map<String, RbelKey> $keys = this.getKeys();
        result = result * 59 + ($keys == null ? 43 : ((Object)$keys).hashCode());
        RbelCapturer $capturer = this.getCapturer();
        result = result * 59 + ($capturer == null ? 43 : ((Object)$capturer).hashCode());
        RbelFileSaveInfo $fileSaveInfo = this.getFileSaveInfo();
        result = result * 59 + ($fileSaveInfo == null ? 43 : ((Object)$fileSaveInfo).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "RbelConfiguration(postConversionListener=" + this.getPostConversionListener() + ", preConversionMappers=" + this.getPreConversionMappers() + ", initializers=" + this.getInitializers() + ", keys=" + this.getKeys() + ", capturer=" + this.getCapturer() + ", activateAsn1Parsing=" + this.isActivateAsn1Parsing() + ", fileSaveInfo=" + this.getFileSaveInfo() + ", rbelBufferSizeInMb=" + this.getRbelBufferSizeInMb() + ", manageBuffer=" + this.isManageBuffer() + ")";
    }

    @ConstructorProperties(value={"postConversionListener", "preConversionMappers", "initializers", "keys", "capturer", "activateAsn1Parsing", "fileSaveInfo", "rbelBufferSizeInMb", "manageBuffer"})
    @Generated
    public RbelConfiguration(List<RbelConverterPlugin> postConversionListener, Map<Class<? extends RbelElement>, List<BiFunction<RbelElement, RbelConverter, RbelElement>>> preConversionMappers, List<Consumer<RbelConverter>> initializers, Map<String, RbelKey> keys, RbelCapturer capturer, boolean activateAsn1Parsing, RbelFileSaveInfo fileSaveInfo, int rbelBufferSizeInMb, boolean manageBuffer) {
        this.postConversionListener = postConversionListener;
        this.preConversionMappers = preConversionMappers;
        this.initializers = initializers;
        this.keys = keys;
        this.capturer = capturer;
        this.activateAsn1Parsing = activateAsn1Parsing;
        this.fileSaveInfo = fileSaveInfo;
        this.rbelBufferSizeInMb = rbelBufferSizeInMb;
        this.manageBuffer = manageBuffer;
    }

    @Generated
    public RbelConfiguration() {
        this.postConversionListener = RbelConfiguration.$default$postConversionListener();
        this.preConversionMappers = RbelConfiguration.$default$preConversionMappers();
        this.initializers = RbelConfiguration.$default$initializers();
        this.keys = RbelConfiguration.$default$keys();
        this.activateAsn1Parsing = RbelConfiguration.$default$activateAsn1Parsing();
        this.rbelBufferSizeInMb = RbelConfiguration.$default$rbelBufferSizeInMb();
        this.manageBuffer = RbelConfiguration.$default$manageBuffer();
    }

    @Generated
    public static class RbelConfigurationBuilder {
        @Generated
        private boolean postConversionListener$set;
        @Generated
        private List<RbelConverterPlugin> postConversionListener$value;
        @Generated
        private boolean preConversionMappers$set;
        @Generated
        private Map<Class<? extends RbelElement>, List<BiFunction<RbelElement, RbelConverter, RbelElement>>> preConversionMappers$value;
        @Generated
        private boolean initializers$set;
        @Generated
        private List<Consumer<RbelConverter>> initializers$value;
        @Generated
        private boolean keys$set;
        @Generated
        private Map<String, RbelKey> keys$value;
        @Generated
        private RbelCapturer capturer;
        @Generated
        private boolean activateAsn1Parsing$set;
        @Generated
        private boolean activateAsn1Parsing$value;
        @Generated
        private RbelFileSaveInfo fileSaveInfo;
        @Generated
        private boolean rbelBufferSizeInMb$set;
        @Generated
        private int rbelBufferSizeInMb$value;
        @Generated
        private boolean manageBuffer$set;
        @Generated
        private boolean manageBuffer$value;

        @Generated
        RbelConfigurationBuilder() {
        }

        @Generated
        public RbelConfigurationBuilder postConversionListener(List<RbelConverterPlugin> postConversionListener) {
            this.postConversionListener$value = postConversionListener;
            this.postConversionListener$set = true;
            return this;
        }

        @Generated
        public RbelConfigurationBuilder preConversionMappers(Map<Class<? extends RbelElement>, List<BiFunction<RbelElement, RbelConverter, RbelElement>>> preConversionMappers) {
            this.preConversionMappers$value = preConversionMappers;
            this.preConversionMappers$set = true;
            return this;
        }

        @Generated
        public RbelConfigurationBuilder initializers(List<Consumer<RbelConverter>> initializers) {
            this.initializers$value = initializers;
            this.initializers$set = true;
            return this;
        }

        @Generated
        public RbelConfigurationBuilder keys(Map<String, RbelKey> keys) {
            this.keys$value = keys;
            this.keys$set = true;
            return this;
        }

        @Generated
        public RbelConfigurationBuilder capturer(RbelCapturer capturer) {
            this.capturer = capturer;
            return this;
        }

        @Generated
        public RbelConfigurationBuilder activateAsn1Parsing(boolean activateAsn1Parsing) {
            this.activateAsn1Parsing$value = activateAsn1Parsing;
            this.activateAsn1Parsing$set = true;
            return this;
        }

        @Generated
        public RbelConfigurationBuilder fileSaveInfo(RbelFileSaveInfo fileSaveInfo) {
            this.fileSaveInfo = fileSaveInfo;
            return this;
        }

        @Generated
        public RbelConfigurationBuilder rbelBufferSizeInMb(int rbelBufferSizeInMb) {
            this.rbelBufferSizeInMb$value = rbelBufferSizeInMb;
            this.rbelBufferSizeInMb$set = true;
            return this;
        }

        @Generated
        public RbelConfigurationBuilder manageBuffer(boolean manageBuffer) {
            this.manageBuffer$value = manageBuffer;
            this.manageBuffer$set = true;
            return this;
        }

        @Generated
        public RbelConfiguration build() {
            List<RbelConverterPlugin> postConversionListener$value = this.postConversionListener$value;
            if (!this.postConversionListener$set) {
                postConversionListener$value = RbelConfiguration.$default$postConversionListener();
            }
            Map<Class<? extends RbelElement>, List<BiFunction<RbelElement, RbelConverter, RbelElement>>> preConversionMappers$value = this.preConversionMappers$value;
            if (!this.preConversionMappers$set) {
                preConversionMappers$value = RbelConfiguration.$default$preConversionMappers();
            }
            List<Consumer<RbelConverter>> initializers$value = this.initializers$value;
            if (!this.initializers$set) {
                initializers$value = RbelConfiguration.$default$initializers();
            }
            Map<String, RbelKey> keys$value = this.keys$value;
            if (!this.keys$set) {
                keys$value = RbelConfiguration.$default$keys();
            }
            boolean activateAsn1Parsing$value = this.activateAsn1Parsing$value;
            if (!this.activateAsn1Parsing$set) {
                activateAsn1Parsing$value = RbelConfiguration.$default$activateAsn1Parsing();
            }
            int rbelBufferSizeInMb$value = this.rbelBufferSizeInMb$value;
            if (!this.rbelBufferSizeInMb$set) {
                rbelBufferSizeInMb$value = RbelConfiguration.$default$rbelBufferSizeInMb();
            }
            boolean manageBuffer$value = this.manageBuffer$value;
            if (!this.manageBuffer$set) {
                manageBuffer$value = RbelConfiguration.$default$manageBuffer();
            }
            return new RbelConfiguration(postConversionListener$value, preConversionMappers$value, initializers$value, keys$value, this.capturer, activateAsn1Parsing$value, this.fileSaveInfo, rbelBufferSizeInMb$value, manageBuffer$value);
        }

        @Generated
        public String toString() {
            return "RbelConfiguration.RbelConfigurationBuilder(postConversionListener$value=" + this.postConversionListener$value + ", preConversionMappers$value=" + this.preConversionMappers$value + ", initializers$value=" + this.initializers$value + ", keys$value=" + this.keys$value + ", capturer=" + this.capturer + ", activateAsn1Parsing$value=" + this.activateAsn1Parsing$value + ", fileSaveInfo=" + this.fileSaveInfo + ", rbelBufferSizeInMb$value=" + this.rbelBufferSizeInMb$value + ", manageBuffer$value=" + this.manageBuffer$value + ")";
        }
    }
}

