/*
 * Decompiled with CFR 0.152.
 */
package org.jnetpcap.util;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.jnetpcap.nio.JBuffer;
import org.jnetpcap.nio.JMemory;
import org.jnetpcap.nio.JMemoryPool;
import org.jnetpcap.nio.JNumber;
import org.jnetpcap.packet.PeeringException;

public class SlidingBuffer {
    private long leftSequence = 0L;
    private long rightSequence = 0L;
    private final JBuffer storage;
    private final int size;

    public SlidingBuffer(int n) {
        this.size = n;
        this.storage = JMemoryPool.buffer(n + JNumber.Type.getBiggestSize());
    }

    public int findUTF8String(long l, char ... cArray) {
        return this.storage.findUTF8String(this.map(l), cArray);
    }

    public byte getByte(long l) {
        return this.storage.getByte(this.map(l));
    }

    public byte[] getByteArray(long l, byte[] byArray) {
        return this.storage.getByteArray(this.map(l), byArray);
    }

    public byte[] getByteArray(long l, int n) {
        return this.storage.getByteArray(this.map(l), n);
    }

    public double getDouble(long l) {
        return this.storage.getDouble(this.map(l));
    }

    public float getFloat(long l) {
        return this.storage.getFloat(this.map(l));
    }

    public int getInt(long l) {
        return this.storage.getInt(this.map(l));
    }

    public long getLong(long l) {
        return this.storage.getLong(this.map(l));
    }

    public short getShort(long l) {
        return this.storage.getShort(this.map(l));
    }

    public int getUByte(long l) {
        return this.storage.getUByte(this.map(l));
    }

    public long getUInt(long l) {
        return this.storage.getUInt(this.map(l));
    }

    public int getUShort(long l) {
        return this.storage.getUShort(this.map(l));
    }

    public char getUTF8Char(long l) {
        return this.storage.getUTF8Char(this.map(l));
    }

    public String getUTF8String(long l, char ... cArray) {
        return this.storage.getUTF8String(this.map(l), cArray);
    }

    public String getUTF8String(long l, int n) {
        return this.storage.getUTF8String(this.map(l), n);
    }

    public StringBuilder getUTF8String(int n, StringBuilder stringBuilder, char ... cArray) {
        return this.storage.getUTF8String(this.map(n), stringBuilder, cArray);
    }

    public StringBuilder getUTF8String(long l, StringBuilder stringBuilder, int n) {
        return this.storage.getUTF8String(this.map(l), stringBuilder, n);
    }

    public int hashCode() {
        return this.storage.hashCode();
    }

    public boolean isInitialized() {
        return this.storage.isInitialized();
    }

    public boolean isJMemoryBasedOwner() {
        return this.storage.isJMemoryBasedOwner();
    }

    public final boolean isOwner() {
        return this.storage.isOwner();
    }

    public boolean isReadonly() {
        return this.storage.isReadonly();
    }

    public ByteOrder order() {
        return this.storage.order();
    }

    public void order(ByteOrder byteOrder) {
        this.storage.order(byteOrder);
    }

    public int peer(ByteBuffer byteBuffer) throws PeeringException {
        return this.storage.peer(byteBuffer);
    }

    public int peer(JBuffer jBuffer, int n, int n2) throws IndexOutOfBoundsException {
        return this.storage.peer(jBuffer, n, n2);
    }

    public int peer(JBuffer jBuffer) {
        return this.storage.peer(jBuffer);
    }

    public int peer(JMemory jMemory) {
        return this.storage.peer(jMemory);
    }

    public void setByte(long l, byte by) {
        this.storage.setByte(this.map(l), by);
    }

    public void setByteArray(long l, byte[] byArray) {
        this.storage.setByteArray(this.map(l), byArray);
    }

    public void setByteBuffer(int n, ByteBuffer byteBuffer) {
        this.storage.setByteBuffer(n, byteBuffer);
    }

    public void setDouble(long l, double d) {
        this.storage.setDouble(this.map(l), d);
    }

    public void setFloat(long l, float f) {
        this.storage.setFloat(this.map(l), f);
    }

    public void setInt(long l, int n) {
        this.storage.setInt(this.map(l), n);
    }

    public void setLong(long l, long l2) {
        this.storage.setLong(this.map(l), l2);
    }

    public void setShort(long l, short s2) {
        this.storage.setShort(this.map(l), s2);
    }

    public void setUByte(long l, int n) {
        this.storage.setUByte(this.map(l), n);
    }

    public void setUInt(long l, long l2) {
        this.storage.setUInt(this.map(l), l2);
    }

    private int map(long l) {
        return (int)(l - this.leftSequence);
    }

    public void setUShort(long l, int n) {
        this.storage.setUShort(this.map(l), n);
    }

    public int length() {
        return (int)(this.rightSequence - this.leftSequence);
    }

    public String toDebugString() {
        return this.storage.toDebugString();
    }

    public String toHexdump() {
        return this.storage.toHexdump();
    }

    public String toHexdump(int n, boolean bl, boolean bl2, boolean bl3) {
        return this.storage.toHexdump(n, bl, bl2, bl3);
    }

    public String toString() {
        return this.storage.toString();
    }

    public int transferFrom(byte[] byArray) {
        return this.storage.transferFrom(byArray);
    }

    public int transferFrom(ByteBuffer byteBuffer, int n) {
        return this.storage.transferFrom(byteBuffer, (int)((long)n - this.leftSequence));
    }

    public int transferFrom(JBuffer jBuffer) {
        this.advance(jBuffer.size());
        return this.storage.transferFrom(jBuffer);
    }

    private void advance(int n) {
        if (this.rightSequence + (long)n > (long)this.size) {
            // empty if block
        }
    }

    public int transferTo(ByteBuffer byteBuffer, int n, int n2) {
        return this.storage.transferTo(byteBuffer, (int)((long)n - this.leftSequence), n2);
    }

    public int transferTo(ByteBuffer byteBuffer) {
        return this.storage.transferTo(byteBuffer);
    }

    public int transferTo(JBuffer jBuffer, int n, int n2, int n3) {
        return this.storage.transferTo(jBuffer, (int)((long)n - this.leftSequence), n2, n3);
    }

    public int transferTo(JBuffer jBuffer) {
        return this.storage.transferTo(jBuffer);
    }
}

