/*
 * Decompiled with CFR 0.152.
 */
package org.jnetpcap.protocol.tcpip.radius;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.jnetpcap.protocol.tcpip.Radius;
import org.jnetpcap.protocol.tcpip.radius.FreeRadiusTokenizer;

public class FreeRadiusDictionary {
    private static final FreeRadiusTokenizer.TokenType ATTRIBUTE = FreeRadiusTokenizer.TokenType.ATTRIBUTE;
    private static final FreeRadiusTokenizer.TokenType EOL = FreeRadiusTokenizer.TokenType.EOL;
    private static final FreeRadiusTokenizer.TokenType ID = FreeRadiusTokenizer.TokenType.ID;
    private static final FreeRadiusTokenizer.TokenType INCLUDE = FreeRadiusTokenizer.TokenType.INCLUDE;
    private static final FreeRadiusTokenizer.TokenType NUM = FreeRadiusTokenizer.TokenType.NUMBER;
    private static final String RESOURCE_ROOT = "org/jnetpcap/protocol/tcpip/radius/";
    private static final FreeRadiusTokenizer.TokenType TYPE = FreeRadiusTokenizer.TokenType.VALUE_TYPE;
    public final Attributes attributes = new Attributes();
    private final Vendors vendors = new Vendors();
    private boolean verbose = false;

    public FreeRadiusDictionary() {
        this("dictionary");
    }

    public FreeRadiusDictionary(String string) {
        this(RESOURCE_ROOT, string);
    }

    public FreeRadiusDictionary(String string, String string2) {
        if (!string.endsWith("/")) {
            string = string + "/";
        }
    }

    public Attribute attribute(int n) {
        return (Attribute)this.attributes.get(n);
    }

    public Attribute attribute(int n, int n2) {
        Attributes attributes = ((Vendor)this.vendors.get((Object)Integer.valueOf((int)n))).attributes;
        if (attributes == null) {
            return null;
        }
        return (Attribute)attributes.get(n2);
    }

    private InputStream openResource(String string) {
        InputStream inputStream = FreeRadiusDictionary.class.getClassLoader().getResourceAsStream(string);
        return inputStream;
    }

    public boolean process() throws IOException {
        return this.process(RESOURCE_ROOT, "dictionary");
    }

    public boolean process(String string) throws IOException {
        return this.process(RESOURCE_ROOT, string);
    }

    public boolean process(String string, String string2) throws IOException {
        InputStream inputStream = this.openResource(string + string2);
        if (inputStream == null) {
            return false;
        }
        FreeRadiusTokenizer freeRadiusTokenizer = new FreeRadiusTokenizer(inputStream);
        int n = 1;
        int n2 = 1;
        Vendor vendor = null;
        boolean bl = false;
        while (freeRadiusTokenizer.hasNextToken()) {
            Object object;
            Object object2;
            String string3;
            if (freeRadiusTokenizer.predicate(EOL)) {
                freeRadiusTokenizer.consume();
                continue;
            }
            if (freeRadiusTokenizer.predicate(INCLUDE, ID, EOL)) {
                string3 = freeRadiusTokenizer.get(null, ID, null).stringValue();
                if (this.verbose) {
                    System.out.printf("INCLUDE=%s root=%s\n", string3, string);
                }
                this.process(string, string3);
                continue;
            }
            if (freeRadiusTokenizer.predicate(ATTRIBUTE, ID, NUM, TYPE, EOL)) {
                string3 = freeRadiusTokenizer.get(null, ID).stringValue();
                int n3 = freeRadiusTokenizer.get().intValue();
                String string4 = freeRadiusTokenizer.get(ID, null).stringValue();
                if (vendor != null) {
                    object2 = vendor.attributes.put(n3, string3, string4);
                    if (this.verbose) {
                        System.out.printf("VENDOR(%s): ATTRIBUTE=%s\n", vendor.name, object2);
                    }
                } else {
                    object2 = this.attributes.put(n3, string3, string4);
                    if (this.verbose) {
                        System.out.printf("ATTRIBUTE=%s\n", object2);
                    }
                }
                if (bl) continue;
                vendor = null;
                continue;
            }
            if (freeRadiusTokenizer.predicate(ATTRIBUTE, ID, NUM, TYPE, ID, EOL)) {
                string3 = freeRadiusTokenizer.get(null, ID).stringValue();
                long l = freeRadiusTokenizer.get().longValue();
                object2 = freeRadiusTokenizer.get(ID, null).stringValue();
                vendor = this.vendors.valueOf(freeRadiusTokenizer.get().stringValue());
                object = vendor.attributes.put(l, string3, (String)object2);
                if (!this.verbose) continue;
                System.out.printf("VENDOR(%s): ATTRIBUTE=%s\n", vendor.name, object);
                continue;
            }
            if (freeRadiusTokenizer.predicate(FreeRadiusTokenizer.TokenType.VALUE, ID, ID, NUM, EOL)) {
                string3 = freeRadiusTokenizer.get(null, ID).stringValue();
                String string5 = freeRadiusTokenizer.get().stringValue();
                long l = freeRadiusTokenizer.get(NUM, null).longValue();
                object = vendor == null ? this.attributes : vendor.attributes;
                Attribute attribute = ((Attributes)object).valueOf(string3);
                if (attribute == null) {
                    if (!this.verbose) continue;
                    System.out.printf("ERROR: %s not found in %s; VALUE=%s(%d)\n", string3, string2, string5, l);
                    continue;
                }
                attribute.values.put(l, string5);
                if (this.verbose && vendor == null) {
                    System.out.printf("%s VALUE=%s(%d)\n", attribute, string5, l);
                    continue;
                }
                if (!this.verbose || vendor == null) continue;
                System.out.printf("VENDOR(%s): %s VALUE=%s(%d)\n", vendor.name, attribute, string5, l);
                continue;
            }
            if (freeRadiusTokenizer.predicate(FreeRadiusTokenizer.TokenType.VENDOR, ID, NUM, FreeRadiusTokenizer.TokenType.FORMAT, NUM, NUM, EOL)) {
                string3 = freeRadiusTokenizer.get(null, ID).stringValue();
                long l = freeRadiusTokenizer.get(NUM).longValue();
                n = freeRadiusTokenizer.get(null, NUM).intValue();
                n2 = freeRadiusTokenizer.get(NUM, null).intValue();
                vendor = this.vendors.put(l, string3, n, n2);
                if (this.verbose) {
                    System.out.printf("VENDOR: %s\n", vendor);
                }
                vendor = null;
                continue;
            }
            if (freeRadiusTokenizer.predicate(FreeRadiusTokenizer.TokenType.VENDOR, ID, NUM, EOL)) {
                string3 = freeRadiusTokenizer.get(null, ID).stringValue();
                long l = freeRadiusTokenizer.get(NUM, null).longValue();
                vendor = this.vendors.put(l, string3, n, n2);
                if (this.verbose) {
                    System.out.printf("VENDOR: %s\n", vendor);
                }
                vendor = null;
                continue;
            }
            if (freeRadiusTokenizer.predicate(FreeRadiusTokenizer.TokenType.BEGIN_VENDOR, ID, EOL)) {
                vendor = this.vendors.valueOf(freeRadiusTokenizer.get(null, ID, null).stringValue());
                bl = true;
                if (!this.verbose) continue;
                System.out.printf("BEGIN-VENDOR(%s)\n", vendor.name);
                continue;
            }
            if (freeRadiusTokenizer.predicate(FreeRadiusTokenizer.TokenType.END_VENDOR, ID, EOL)) {
                string3 = freeRadiusTokenizer.get(null, ID, null).stringValue();
                vendor = null;
                bl = false;
                if (!this.verbose) continue;
                System.out.printf("END-VENDOR(%s)\n", string3);
                continue;
            }
            freeRadiusTokenizer.consume();
        }
        return true;
    }

    public void setVerbose(boolean bl) {
        this.verbose = bl;
    }

    public String value(int n, int n2) {
        Attribute attribute = this.attribute(n);
        return attribute.values.get(n2);
    }

    public String value(int n, int n2, int n3) {
        Attribute attribute = this.attribute(n, n2);
        return attribute.values.get(n3);
    }

    public Vendor vendor(long l) {
        return (Vendor)this.vendors.get(l);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Vendors
    extends HashMap<Long, Vendor> {
        private static final long serialVersionUID = 9089071071454562950L;

        @Override
        public Vendor put(long l, String string) {
            Vendor vendor = new Vendor(string, l);
            this.put(Long.valueOf(l), vendor);
            return vendor;
        }

        public Vendor put(long l, String string, int n, int n2) {
            Vendor vendor = new Vendor(string, l, n, n2);
            this.put(Long.valueOf(l), vendor);
            return vendor;
        }

        public Vendor valueOf(String string) {
            for (Vendor vendor : this.values()) {
                if (!string.equals(vendor.name)) continue;
                return vendor;
            }
            return null;
        }
    }

    public static class Vendor {
        public final Attributes attributes = new Attributes();
        public final long code;
        public final int lenLen;
        public final String name;
        public final int typeLen;

        public Vendor(String string, long l) {
            this.name = string;
            this.code = l;
            this.typeLen = 1;
            this.lenLen = 1;
        }

        public Vendor(String string, long l, int n, int n2) {
            this.name = string;
            this.code = l;
            this.typeLen = n;
            this.lenLen = n2;
        }

        public String toString() {
            return String.format("%s(%d) format=%d,%d", this.name, this.code, this.typeLen, this.lenLen);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Attributes
    extends HashMap<Long, Attribute> {
        private static final long serialVersionUID = 5690140802351434597L;

        public boolean hasAttribute(String string) {
            for (Attribute attribute : this.values()) {
                if (!attribute.name.equals(string)) continue;
                return true;
            }
            return false;
        }

        public Attribute put(long l, String string, String string2) {
            Attribute attribute;
            if (this.hasAttribute(string)) {
                attribute = this.valueOf(string);
                this.remove(attribute.code);
                attribute.code = l;
                attribute.typeString = string2;
            } else {
                attribute = new Attribute(l, string, string2);
            }
            super.put(l, attribute);
            return attribute;
        }

        public Attribute valueOf(String string) {
            for (Attribute attribute : this.values()) {
                if (!attribute.name.equals(string)) continue;
                return attribute;
            }
            Attribute attribute = new Attribute(string.hashCode(), string, null);
            this.put(attribute.code, attribute);
            return attribute;
        }
    }

    public static class Attribute {
        public long code;
        public final String name;
        public String typeString;
        public Radius.AVType type;
        public final Map<Long, String> values = new HashMap<Long, String>();

        public Attribute(long l, String string, String string2) {
            this.code = l;
            this.name = string;
            this.typeString = string2;
            this.type = Radius.AVType.parseAVType(string2);
        }

        public String toString() {
            if (this.typeString == null) {
                return String.format("%s(TEMPORARY_CODE=0X%X):NOT_DEFINED_YET", this.name, this.code);
            }
            return String.format("%s(%d):%s", this.name, this.code, this.typeString);
        }
    }
}

