/*
 * Decompiled with CFR 0.152.
 */
package org.jnetpcap.protocol.tcpip;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jnetpcap.nio.JBuffer;
import org.jnetpcap.packet.JHeader;
import org.jnetpcap.packet.JPacket;
import org.jnetpcap.packet.JRegistry;
import org.jnetpcap.packet.RegistryHeaderErrors;
import org.jnetpcap.packet.annotate.Bind;
import org.jnetpcap.packet.annotate.Dynamic;
import org.jnetpcap.packet.annotate.Field;
import org.jnetpcap.packet.annotate.FieldSetter;
import org.jnetpcap.packet.annotate.Header;
import org.jnetpcap.packet.annotate.HeaderLength;
import org.jnetpcap.packet.format.JFormatter;
import org.jnetpcap.packet.structure.JField;
import org.jnetpcap.protocol.tcpip.Udp;
import org.jnetpcap.protocol.tcpip.radius.FreeRadiusDictionary;
import org.jnetpcap.protocol.tcpip.radius.RadiusAVPField;

@Header(description="Remote Authentication Dial-In User Service", osi=Header.Layer.APPLICATION)
public class Radius
extends JHeader {
    private static final Type[] attributeTypes = new Type[256];
    private static final int CAPACITY = 256;
    private static final FreeRadiusDictionary dictionary;
    private final List<JField> avps = new ArrayList<JField>(64);
    private final Data[] data = new Data[256];
    private int dataCount = 0;

    public Radius() {
        for (int i = 0; i < 256; ++i) {
            this.data[i] = new Data();
        }
    }

    @Bind(to=Udp.class)
    public static boolean bind2Udp(JPacket jPacket, Udp udp) {
        return udp.destination() == 1812 || udp.source() == 1812 || udp.destination() == 1813 || udp.source() == 1813 || udp.destination() == 3799 || udp.source() == 3799 || udp.destination() == 1646 || udp.source() == 1646;
    }

    @HeaderLength
    public static int headerLength(JBuffer jBuffer, int n) {
        return jBuffer.getUShort(16);
    }

    public int attributeInt(int n) {
        return this.attributeInt(0, n);
    }

    public int attributeInt(int n, int n2) {
        Data data = this.findData(n, n2);
        if (data == null) {
            return 0;
        }
        return super.getInt(data.offset + data.t + data.l);
    }

    public byte[] attributeIp6addr(int n) {
        return this.attributeIp6addr(0, n);
    }

    public byte[] attributeIp6addr(int n, int n2) {
        Data data = this.findData(n, n2);
        if (data == null) {
            return null;
        }
        return super.getByteArray(data.offset + data.t + data.l, 16);
    }

    public byte[] attributeIpaddr(int n) {
        return this.attributeIpaddr(0, n);
    }

    public byte[] attributeIpaddr(int n, int n2) {
        Data data = this.findData(n, n2);
        if (data == null) {
            return null;
        }
        return super.getByteArray(data.offset + data.t + data.l, 4);
    }

    public byte[] attributeOctets(int n) {
        return this.attributeOctets(0, n);
    }

    public byte[] attributeOctets(int n, int n2) {
        Data data = this.findData(n, n2);
        if (data == null) {
            return null;
        }
        return super.getByteArray(data.offset + data.t + data.l, data.length - data.t - data.l);
    }

    public String attributeString(int n) {
        return this.attributeString(0, n);
    }

    public String attributeString(int n, int n2) {
        Data data = this.findData(n, n2);
        if (data == null) {
            return null;
        }
        return super.getUTF8String(data.offset + data.t + data.l, data.length - data.t - data.l);
    }

    public long attributeTime(int n) {
        return this.attributeTime(0, n);
    }

    public long attributeTime(int n, int n2) {
        Data data = this.findData(n, n2);
        if (data == null) {
            return 0L;
        }
        return super.getUInt(data.offset + data.t + data.l);
    }

    public long attributeUInt(int n) {
        return this.attributeUInt(0, n);
    }

    public long attributeUInt(int n, int n2) {
        Data data = this.findData(n, n2);
        if (data == null) {
            return 0L;
        }
        return super.getUInt(data.offset + data.t + data.l);
    }

    @Field(offset=32, length=128, format="#octets#")
    public byte[] authenticator() {
        return super.getByteArray(4, 16);
    }

    @FieldSetter
    public void authenticator(byte[] byArray) {
        if (byArray.length != 16) {
            throw new IllegalArgumentException("expecting 16 byte array");
        }
        super.setByteArray(8, byArray);
    }

    public byte[] authenticatorByteArray(byte[] byArray) {
        return super.getByteArray(8, byArray);
    }

    @Field(offset=0, length=8)
    public int code() {
        return super.getUByte(0);
    }

    @FieldSetter
    public void code(int n) {
        super.setUByte(0, n);
    }

    @Dynamic(value=Field.Property.DESCRIPTION)
    public String codeDescription() {
        return this.codeEnum().toString();
    }

    public Code codeEnum() {
        return Code.valueOf(this.code());
    }

    private RadiusAVPField createAVP(int n, FreeRadiusDictionary.Attribute attribute, long l, int n2) {
        int n3 = n + 2;
        int n4 = n2 - 2;
        if (attribute.typeString.equals("string")) {
            String string = String.format("%s", attribute.name);
            String string2 = this.getUTF8String(n3, n4);
            return new RadiusAVPField(string, (int)l, n, n4, (Object)string2, JFormatter.Style.STRING);
        }
        if (attribute.typeString.equals("integer")) {
            String string = String.format("%s", attribute.name);
            long l2 = this.getUInt(n3);
            String string3 = attribute.values.get(l2);
            if (string3 == null) {
                return new RadiusAVPField(string, (int)l, n, n4, (Object)l2, JFormatter.Style.INT_DEC);
            }
            return new RadiusAVPField(string, (int)l, n, n4, l2, JFormatter.Style.INT_DEC, string3);
        }
        if (attribute.typeString.equals("ipaddr") || attribute.typeString.equals("ipv4prefix")) {
            String string = String.format("%s", attribute.name);
            byte[] byArray = this.getByteArray(n3, 4);
            return new RadiusAVPField(string, (int)l, n, n4, (Object)byArray, JFormatter.Style.BYTE_ARRAY_IP4_ADDRESS);
        }
        if (attribute.typeString.equals("ipv6addr")) {
            String string = String.format("%s", attribute.name);
            byte[] byArray = this.getByteArray(n3, 16);
            return new RadiusAVPField(string, (int)l, n, n4, (Object)byArray, JFormatter.Style.BYTE_ARRAY_IP6_ADDRESS);
        }
        if (attribute.typeString.equals("octets")) {
            String string = String.format("%s", attribute.name);
            byte[] byArray = this.getByteArray(n3, n4);
            return new RadiusAVPField(string, (int)l, n, n4, (Object)byArray, JFormatter.Style.BYTE_ARRAY_OCTET_STREAM);
        }
        return null;
    }

    private RadiusAVPField createAVP(int n, int n2, int n3, AVType aVType) {
        JFormatter.Style style;
        Object object;
        String string = Type.valueOf(n2).name();
        switch (aVType) {
            case INTEGER: {
                object = super.getInt(n + 2);
                style = JFormatter.Style.INT_DEC;
                break;
            }
            case IPADDR: {
                object = this.getByteArray(n + 2, 4);
                style = JFormatter.Style.BYTE_ARRAY_IP4_ADDRESS;
                break;
            }
            case STRING: {
                object = this.getUTF8String(n + 2, n3 - 2);
                style = JFormatter.Style.STRING;
                break;
            }
            case DATE: {
                object = this.getUInt(n + 2);
                style = JFormatter.Style.TIMESTAMP_SECONDS;
                break;
            }
            case OCTETS: {
                object = this.getByteArray(n + 2, n3 - 2);
                style = JFormatter.Style.BYTE_ARRAY_OCTET_STREAM;
                break;
            }
            default: {
                throw new IllegalStateException("unknow AVP type: " + (Object)((Object)aVType));
            }
        }
        return new RadiusAVPField(string, n2, n, n3, object, style);
    }

    private RadiusAVPField createSVA(int n, FreeRadiusDictionary.Vendor vendor, FreeRadiusDictionary.Attribute attribute, long l, int n2) {
        int n3 = n + vendor.typeLen + vendor.lenLen;
        int n4 = n2 - vendor.typeLen - vendor.lenLen;
        String string = String.format(" +%s", attribute.name);
        if (attribute.typeString.equals("string")) {
            String string2 = this.getUTF8String(n3, n4);
            return new RadiusAVPField(string, (int)l, n, n4, (Object)string2, JFormatter.Style.STRING);
        }
        if (attribute.typeString.equals("integer")) {
            long l2 = this.getUInt(n3);
            String string3 = attribute.values.get(l2);
            if (string3 == null) {
                return new RadiusAVPField(string, (int)l, n, n4, (Object)l2, JFormatter.Style.INT_DEC);
            }
            return new RadiusAVPField(string, (int)l, n, n4, l2, JFormatter.Style.INT_DEC, string3);
        }
        if (attribute.typeString.equals("ipaddr") || attribute.typeString.equals("ipv4prefix")) {
            byte[] byArray = this.getByteArray(n3, 4);
            return new RadiusAVPField(string, (int)l, n, n4, (Object)byArray, JFormatter.Style.BYTE_ARRAY_IP4_ADDRESS);
        }
        if (attribute.typeString.equals("ipv6addr")) {
            byte[] byArray = this.getByteArray(n3, 16);
            return new RadiusAVPField(string, (int)l, n, n4, (Object)byArray, JFormatter.Style.BYTE_ARRAY_IP6_ADDRESS);
        }
        if (attribute.typeString.equals("octets")) {
            byte[] byArray = this.getByteArray(n3, n4);
            return new RadiusAVPField(string, (int)l, n, n4, (Object)byArray, JFormatter.Style.BYTE_ARRAY_OCTET_STREAM);
        }
        return null;
    }

    protected void decodeHeader() {
        this.avps.clear();
        this.dataCount = 0;
        int n = this.length();
        FreeRadiusDictionary.Vendor vendor = null;
        int n2 = 0;
        block3: for (int i = 20; i < n; i += n2) {
            int n3 = super.getUByte(i);
            n2 = super.getUByte(i + 1);
            switch (n3) {
                case 26: {
                    long l = this.getUInt(i + 2);
                    if (vendor == null || vendor.code != l) {
                        vendor = dictionary.vendor(l);
                    }
                    int n4 = vendor == null ? 1 : vendor.typeLen;
                    int n5 = vendor == null ? 1 : vendor.lenLen;
                    long l2 = 0L;
                    if (n4 == 1) {
                        l2 = this.getUByte(i + 6);
                    } else if (n4 == 2) {
                        l2 = this.getUShort(i + 6);
                    } else if (n4 == 4) {
                        l2 = this.getInt(i + 6);
                    }
                    int n6 = n4;
                    if (n5 == 1) {
                        n6 = this.getUByte(i + 6 + n4);
                    } else if (n5 == 2) {
                        n6 = this.getUShort(i + 6 + n4);
                    } else if (n5 == 4) {
                        n6 = this.getInt(i + 6 + n4);
                    }
                    Data data = this.data[this.dataCount++];
                    data.code = l2;
                    data.length = n6;
                    data.vendor = l;
                    data.offset = i + 6;
                    data.t = n4;
                    data.l = n5;
                    continue block3;
                }
                default: {
                    Data data = this.data[this.dataCount++];
                    data.code = n3;
                    data.length = n2;
                    data.vendor = 0L;
                    data.offset = i;
                    data.t = 1;
                    data.l = 1;
                }
            }
        }
    }

    protected void decodeHeaderToAVPFields() {
        JField[] jFieldArray;
        for (JField object : jFieldArray = super.getFields()) {
            this.avps.add(object);
        }
        int n = this.length();
        int n2 = 0;
        block4: for (int i = 20; i < n; i += n2) {
            Type type = attributeTypes[super.getUByte(i)];
            n2 = super.getUByte(i + 1);
            switch (type) {
                case VENDOR_SPECIFIC: {
                    Object object;
                    long l = this.getUInt(i + 2);
                    FreeRadiusDictionary.Vendor vendor = dictionary.vendor(l);
                    long l2 = 0L;
                    if (vendor.typeLen == 1) {
                        l2 = this.getUByte(i + 6);
                    } else if (vendor.typeLen == 2) {
                        l2 = this.getUShort(i + 6);
                    } else if (vendor.typeLen == 4) {
                        l2 = this.getInt(i + 6);
                    }
                    int n3 = vendor.typeLen;
                    if (vendor.lenLen == 1) {
                        n3 = this.getUByte(i + 6 + vendor.typeLen);
                    } else if (vendor.lenLen == 2) {
                        n3 = this.getUShort(i + 6 + vendor.typeLen);
                    } else if (vendor.lenLen == 4) {
                        n3 = this.getInt(i + 6 + vendor.typeLen);
                    }
                    int n4 = i + 6 + vendor.typeLen + vendor.lenLen;
                    int n5 = i + 6 + vendor.typeLen + vendor.lenLen;
                    int n6 = n3 - vendor.typeLen - vendor.lenLen;
                    FreeRadiusDictionary.Attribute attribute = (FreeRadiusDictionary.Attribute)vendor.attributes.get(l2);
                    if (attribute == null) {
                        object = String.format("+unknown(%s:%d)", vendor.name, l2);
                        RadiusAVPField radiusAVPField = new RadiusAVPField((String)object, n4, n3);
                        radiusAVPField.setAvpType((int)l2);
                        radiusAVPField.setValue(this.getByteArray(n5, n6));
                        radiusAVPField.setStyle(JFormatter.Style.BYTE_ARRAY_OCTET_STREAM);
                        this.avps.add(radiusAVPField);
                        continue block4;
                    }
                    object = this.createSVA(i + 6, vendor, attribute, l2, n3);
                    if (object == null) continue block4;
                    this.avps.add((JField)object);
                    continue block4;
                }
                default: {
                    FreeRadiusDictionary.Attribute attribute = (FreeRadiusDictionary.Attribute)Radius.dictionary.attributes.get(type.value);
                    if (attribute == null) {
                        this.avps.add(this.createAVP(i, type.value, n2, type.data));
                        continue block4;
                    }
                    Object object = this.createAVP(i, attribute, (long)type.value, n2);
                    if (object == null) continue block4;
                    this.avps.add((JField)object);
                }
            }
        }
    }

    private Data findData(int n, int n2) {
        for (int i = 0; i < this.dataCount; ++i) {
            Data data = this.data[i];
            if (data.vendor != (long)n || data.code != (long)n2) continue;
            return data;
        }
        return null;
    }

    public JField[] getFields() {
        if (this.avps.isEmpty()) {
            this.decodeHeaderToAVPFields();
        }
        return this.avps.toArray(new JField[this.avps.size()]);
    }

    @Field(offset=8, length=8)
    public int identifier() {
        return super.getUByte(1);
    }

    @FieldSetter
    public void identifier(int n) {
        super.setUByte(1, n);
    }

    @Field(offset=16, length=16, units="bytes")
    public int length() {
        return super.getUShort(2);
    }

    @FieldSetter
    public void length(int n) {
        super.setUShort(2, n);
    }

    @Field(offset=160, length=8, display="= = = = = = = = = = = = =", format="%s")
    private String separatorLine() {
        return "= = = = = = = = = = = = =";
    }

    static {
        for (int i = 0; i < attributeTypes.length; ++i) {
            Radius.attributeTypes[i] = Type.INVALID;
        }
        Type[] typeArray = Type.values();
        int n = typeArray.length;
        for (int i = 0; i < n; ++i) {
            Type type;
            Radius.attributeTypes[type.value] = type = typeArray[i];
        }
        dictionary = new FreeRadiusDictionary();
        try {
            dictionary.process();
            JRegistry.register(Radius.class);
        }
        catch (RegistryHeaderErrors registryHeaderErrors) {
            registryHeaderErrors.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        ACCT_AUTHENTIC(45, AVType.INTEGER),
        ACCT_DELAY_TIME(41, AVType.INTEGER),
        ACCT_INPUT_GIGAWORDS(52, AVType.OCTETS),
        ACCT_INPUT_OCTETS(42, AVType.INTEGER),
        ACCT_INPUT_PACKETS(47, AVType.INTEGER),
        ACCT_INTERIM_INTERVAL(85, AVType.OCTETS),
        ACCT_LINK_COUNT(51, AVType.OCTETS),
        ACCT_MULTI_SESSION_ID(50, AVType.OCTETS),
        ACCT_OUTPUT_OCTETS(43, AVType.INTEGER),
        ACCT_OUTPUT_PACKETS(48, AVType.INTEGER),
        ACCT_SESSION_ID(44, AVType.OCTETS),
        ACCT_SESSION_TIME(46, AVType.INTEGER),
        ACCT_STATUS_TYPE(40, AVType.INTEGER),
        ACCT_TERMINATE_CAUSE(49, AVType.INTEGER),
        ACCT_TUNNEL_CONNECTION(68, AVType.OCTETS),
        ACCT_TUNNEL_PACKETS_LOST(86, AVType.OCTETS),
        ARAP_CHALLENGE_RESPONE(84, AVType.OCTETS),
        ARAP_FEATURES(71, AVType.OCTETS),
        ARAP_PASSWORD(70, AVType.OCTETS),
        ARAP_SECURITY(73, AVType.OCTETS),
        ARAP_SECURITY_DATA(74, AVType.OCTETS),
        ARAP_ZONE_ACCESS(72, AVType.OCTETS),
        BASIC_LOCASTION_POLICY_RULES(129, AVType.OCTETS),
        CALLBACK_ID(20, AVType.OCTETS),
        CALLBACK_NUMBER(19, AVType.OCTETS),
        CALLED_STATION_ID(30, AVType.STRING),
        CALLING_STATION_ID(31, AVType.STRING),
        CHAP_CHALLENGE(60, AVType.OCTETS),
        CHAP_PASSWORD(3, AVType.STRING),
        CHARGEABLE_USER_IDENTITY(89, AVType.OCTETS),
        CLASS(25, AVType.OCTETS),
        CONFIGURATION_TOKEN(78, AVType.OCTETS),
        CONNECT_INFO(77, AVType.OCTETS),
        DELEGATE_IPV6_PREFIX(123, AVType.OCTETS),
        DIGEST_AKA_AUTS(118, AVType.OCTETS),
        DIGEST_ALGORITHM(111, AVType.OCTETS),
        DIGEST_AUTH_PARAM(117, AVType.OCTETS),
        DIGEST_CNONCE(113, AVType.OCTETS),
        DIGEST_DOMAIN(119, AVType.OCTETS),
        DIGEST_ENTITY_BODY_HASH(112, AVType.OCTETS),
        DIGEST_HA1(121, AVType.OCTETS),
        DIGEST_METHOD(108, AVType.OCTETS),
        DIGEST_NEXTNONCE(106, AVType.OCTETS),
        DIGEST_NONCE(105, AVType.OCTETS),
        DIGEST_NONCE_COUNT(114, AVType.OCTETS),
        DIGEST_OPAQUE(116, AVType.OCTETS),
        DIGEST_QOP(110, AVType.OCTETS),
        DIGEST_REALM(104, AVType.OCTETS),
        DIGEST_REPOSE_AUTH(107, AVType.OCTETS),
        DIGEST_RESPONSE(103, AVType.OCTETS),
        DIGEST_STALE(120, AVType.OCTETS),
        DIGEST_URI(109, AVType.OCTETS),
        DIGEST_USERNAME(115, AVType.OCTETS),
        EAP_KEY_NAME(102, AVType.OCTETS),
        EAP_MESSAGE(79, AVType.OCTETS),
        EGRESS_VLAN_NAME(58, AVType.OCTETS),
        EGRESS_VLANID(56, AVType.OCTETS),
        ERROR_CAUSE(101, AVType.OCTETS),
        EVENT_TIMESTAMP(55, AVType.DATE),
        EXTENDED_LOCATION_POLICY_RULES(130, AVType.OCTETS),
        FILTER_ID(11, AVType.OCTETS),
        FRAMED_APPLETALK_LINK(37, AVType.OCTETS),
        FRAMED_APPLETALK_NETWORK(38, AVType.OCTETS),
        FRAMED_APPLETALK_ZONE(39, AVType.OCTETS),
        FRAMED_COMPRESSION(13, AVType.INTEGER),
        FRAMED_INTERFACE_ID(96, AVType.OCTETS),
        FRAMED_IP_ADDRESS(8, AVType.IPADDR),
        FRAMED_IP_NETMASK(9, AVType.IPADDR),
        FRAMED_IPV6_POOL(100, AVType.OCTETS),
        FRAMED_IPV6_PREFIX(97, AVType.OCTETS),
        FRAMED_IPV6_ROUTE(99, AVType.OCTETS),
        FRAMED_IPX_NETWORK(23, AVType.IPXADDR),
        FRAMED_MANAGEMENT_PROTOCOL(133, AVType.OCTETS),
        FRAMED_MTU(12, AVType.INTEGER),
        FRAMED_POOL(88, AVType.OCTETS),
        FRAMED_PROTOCOL(7, AVType.INTEGER),
        FRAMED_ROUTE(22, AVType.OCTETS),
        FRAMED_ROUTING(10, AVType.IPADDR),
        IDLE_TIMEOUT(28, AVType.INTEGER),
        INGRESS_FILTERS(57, AVType.OCTETS),
        INVALID(0, AVType.OCTETS),
        LOCASTION_CAPABLE(131, AVType.OCTETS),
        LOCATION_DATA(128, AVType.OCTETS),
        LOCATION_INFORMATION(127, AVType.OCTETS),
        LOGIN_IP_HOST(14, AVType.IPADDR),
        LOGIN_IPV6_HOST(98, AVType.OCTETS),
        LOGIN_LAT_GROUP(36, AVType.OCTETS),
        LOGIN_LAT_NODE(35, AVType.OCTETS),
        LOGIN_LAT_PORT(63, AVType.OCTETS),
        LOGIN_LAT_SERVICE(34, AVType.OCTETS),
        LOGIN_SERVICE(15, AVType.INTEGER),
        LOGIN_TCP_PORT(16, AVType.INTEGER),
        MANAGEMENT_POLICY_ID(135, AVType.OCTETS),
        MANAGEMENT_PRIVILEGE_LEVEL(136, AVType.OCTETS),
        MANAGEMENT_TRANSPORT_PROTECTION(134, AVType.OCTETS),
        MESSAGE_AUTHENTICATOR(80, AVType.OCTETS),
        MIP6_FEATURE_VECTOR(124, AVType.OCTETS),
        MIPS_HOME_LINK_PREFIX(125, AVType.OCTETS),
        NAS_FILTER_RULE(92, AVType.OCTETS),
        NAS_IDENTIFIER(32, AVType.STRING),
        NAS_IP_ADDRESS(4, AVType.IPADDR),
        NAS_IPV6_ADDRESS(95, AVType.OCTETS),
        NAS_PORT(5, AVType.INTEGER),
        NAS_PORT_ID(87, AVType.OCTETS),
        NAS_PORT_TYPE(61, AVType.INTEGER),
        OPERATOR_NAME(126, AVType.OCTETS),
        ORIGINATING_LINE_INFO(94, AVType.OCTETS),
        PASSWORD_RETRY(75, AVType.OCTETS),
        PKM_AUTH_KEY(143, AVType.OCTETS),
        PKM_AUTH_WAIT_TIMEOUT(139, AVType.OCTETS),
        PKM_CA_CERT(138, AVType.OCTETS),
        PKM_CRYPTOSUITE_LIST(140, AVType.OCTETS),
        PKM_SA_DESCRIPTOR(142, AVType.OCTETS),
        PKM_SAID(141, AVType.OCTETS),
        PKM_SS_CERT(137, AVType.OCTETS),
        PORT_LIMIT(62, AVType.INTEGER),
        PROMPT(76, AVType.OCTETS),
        PROXY_STATE(33, AVType.OCTETS),
        REPLY_MESSAGE(18, AVType.OCTETS),
        REQUESTED_LOCATION_INFO(132, AVType.OCTETS),
        RESERVED17(17, AVType.OCTETS),
        RESERVED21(21, AVType.OCTETS),
        RESERVED54(54, AVType.OCTETS),
        RESERVED93(93, AVType.OCTETS),
        SERVICE_TYPE(6, AVType.INTEGER),
        SESSION_TIMEOUT(27, AVType.INTEGER),
        SIP_AOR(122, AVType.OCTETS),
        STATE(24, AVType.OCTETS),
        TERMINATION_ACTION(29, AVType.OCTETS),
        TUNNEL_ASSIGNMENT_ID(82, AVType.OCTETS),
        TUNNEL_CLIENT_AUTH_ID(90, AVType.OCTETS),
        TUNNEL_CLIENT_ENDPOINT(66, AVType.OCTETS),
        TUNNEL_MEDIUM_TYPE(65, AVType.OCTETS),
        TUNNEL_PASSWORD(69, AVType.OCTETS),
        TUNNEL_PREFERENCE(83, AVType.OCTETS),
        TUNNEL_PRIVATE_GROUP_ID(81, AVType.OCTETS),
        TUNNEL_SERVER_AUTH_ID(91, AVType.OCTETS),
        TUNNEL_SERVER_ENDPOINT(67, AVType.OCTETS),
        TUNNEL_TYPE(64, AVType.OCTETS),
        USER_NAME(1, AVType.STRING),
        USER_PASSWORD(2, AVType.STRING),
        USER_PRIORITY_TABLE(59, AVType.OCTETS),
        VENDOR_SPECIFIC(26, AVType.OCTETS);

        public final AVType data;
        public final int value;

        public static Type valueOf(int n) {
            for (Type type : Type.values()) {
                if (type.value != n) continue;
                return type;
            }
            return INVALID;
        }

        private Type(int n2) {
            this.value = n2;
            this.data = AVType.OCTETS;
        }

        private Type(int n2, AVType aVType) {
            this.value = n2;
            this.data = aVType;
        }
    }

    private static class Data {
        public long code;
        public int l = 1;
        public int length;
        public int offset;
        public int t = 1;
        public long vendor;

        private Data() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Code {
        ACCESS_ACCEPT(2),
        ACCESS_CHALLENGE(11),
        ACCESS_REJECT(3),
        ACCESS_REQUEST(1),
        ACCOUNTING_MESSAGE(10),
        ACCOUNTING_REQUEST(4),
        ACCOUNTING_RESPONSE(5),
        ACCOUNTING_STATUS(6),
        ALTERNATE_RESOURCE_RECLAIM_REQUEST(25),
        COA_ACK(44),
        COA_NAK(45),
        COA_REQUEST(43),
        DISCONNECT_ACK(41),
        DISCONNECT_NACK(42),
        DISCONNECT_REQUEST(40),
        EVENT_REQUEST(33),
        EVENT_RESPONSE(34),
        IP_ADDRESS_ALLOCATE(50),
        IP_ADDRESS_RELEASE(51),
        NAS_REBOOT_REQUEST(26),
        NAS_REBOOT_RESPONSE(27),
        NEW_PIN(30),
        NEXT_PASSCODE(29),
        PASSWORD_ACK(8),
        PASSWORD_EXPIRED(32),
        PASSWORD_REJECT(9),
        PASSWORD_REQUEST(7),
        RESERVED(0),
        RESERVED14(14),
        RESERVED15(15),
        RESERVED16(16),
        RESERVED17(17),
        RESERVED18(18),
        RESERVED19(19),
        RESERVED20(20),
        RESERVED28(28),
        RESERVED35(35),
        RESERVED36(36),
        RESERVED37(37),
        RESERVED38(38),
        RESERVED39(39),
        RESERVED46(46),
        RESERVED47(47),
        RESERVED48(48),
        RESERVED49(49),
        RESOURCE_FREE_REQUEST(21),
        RESOURCE_FREE_RESPONSE(22),
        RESOURCE_QUERY_REQUEST(23),
        RESOURCE_QUERY_RESPONSE(24),
        STATUS_CLIENT(13),
        STATUS_SERVER(12),
        TERMINATE_SESSION(31);

        public final int value;

        public static Code valueOf(int n) {
            for (Code code : Code.values()) {
                if (code.value != n) continue;
                return code;
            }
            return RESERVED;
        }

        private Code(int n2) {
            this.value = n2;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AVType {
        INTEGER("integer"),
        IPADDR("ipaddr"),
        IPXADDR("ipxaddr"),
        IP6ADDR("ip6addr"),
        IP6PREFIX("ip6prefix"),
        STRING("string"),
        DATE("date"),
        IFID("ifid"),
        OCTETS("octets");

        private final String str;

        private AVType(String string2) {
            this.str = string2;
        }

        public static AVType parseAVType(String string) {
            for (AVType aVType : AVType.values()) {
                if (!string.equals(aVType.str)) continue;
                return aVType;
            }
            return OCTETS;
        }
    }
}

