/*
 * Decompiled with CFR 0.152.
 */
package org.jnetpcap.protocol.network;

import org.jnetpcap.nio.JBuffer;
import org.jnetpcap.packet.JHeader;
import org.jnetpcap.packet.JHeaderChecksum;
import org.jnetpcap.packet.JPacket;
import org.jnetpcap.packet.annotate.Bind;
import org.jnetpcap.packet.annotate.Dynamic;
import org.jnetpcap.packet.annotate.Field;
import org.jnetpcap.packet.annotate.Header;
import org.jnetpcap.protocol.network.Ip4;
import org.jnetpcap.util.checksum.Checksum;

@Header(length=8)
public class GRE
extends JHeader
implements JHeaderChecksum {
    public static final int C_MASK = 1;
    public static final int RESERVED_MASK = 16382;
    public static final int VERSION_MASK = 57344;
    public static final int GRE_IP_TYPE = 47;

    @Bind(to=Ip4.class)
    public static boolean bindToIp4(JBuffer jBuffer, Ip4 ip4) {
        return ip4.type() == 47;
    }

    @Field(offset=0, length=1)
    public boolean c() {
        return (super.getUByte(0) & 1) != 0;
    }

    public void c(boolean bl) {
        int n = super.getUByte(0) & 0xFFFFFFFE;
        super.setUByte(0, bl ? n | 1 : n);
    }

    public int calculateChecksum() {
        JPacket jPacket = this.getPacket();
        return Checksum.inChecksum(jPacket, this.getHeaderOffset(), this.size() - this.getHeaderOffset());
    }

    @Field(offset=32, length=16, format="%x")
    public int checksum() {
        return super.getUShort(4);
    }

    public boolean checksum(int n) {
        this.c(true);
        super.setUShort(4, n);
        return true;
    }

    @Dynamic(value=Field.Property.DESCRIPTION)
    public String checksumDescription() {
        return this.isChecksumValid() ? "correct" : "incorect, should be " + Long.toHexString(this.calculateChecksum());
    }

    public boolean isChecksumValid() {
        return !this.c() || this.calculateChecksum() == this.checksum();
    }

    public boolean recalculateChecksum() {
        this.c(true);
        return this.checksum(this.calculateChecksum());
    }

    @Field(offset=1, length=13)
    public int reserved1() {
        return (super.getUShort(0) & 0x3FFE) >> 1;
    }

    public void reserved1(int n) {
        int n2 = super.getUShort(0) & 0xFFFFC001;
        super.setUShort(0, n2 | n << 1);
    }

    @Field(offset=48, length=16)
    public int reserved2() {
        return super.getUShort(12);
    }

    public void reserved2(int n) {
        super.setUShort(12, n);
    }

    @Field(offset=16, length=16)
    public int type() {
        return super.getUShort(2);
    }

    public void type(int n) {
        super.setUShort(0, n);
    }

    @Field(offset=13, length=3)
    public int version() {
        return super.getUShort(0) >> 13;
    }

    public void version(int n) {
        int n2 = super.getUShort(0) & 0xFFFF1FFF;
        super.setUShort(0, n2 | n << 13);
    }
}

